/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.csv;

import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.csv.CSVFilter;
import java.util.HashMap;
import java.util.Hashtable;

public class CSVUniqueColFilter
implements CSVFilter {
    private String _colToFilter;
    private int _colToFilterIdx = -1;
    private HashMap _uniqueMap = new HashMap();

    public CSVUniqueColFilter(String colToFilter) {
        this._colToFilter = colToFilter;
    }

    public CSVUniqueColFilter(int colToFilter) {
        this._colToFilterIdx = colToFilter;
    }

    public boolean doFilter(int row, String[] colNames, String[] csvValues, Hashtable colVarSubst) {
        if (this._colToFilterIdx == -1) {
            this._colToFilterIdx = ArrayUtil.contains(colNames, this._colToFilter);
        }
        if (this._colToFilterIdx != -1) {
            String value = csvValues[this._colToFilterIdx];
            if (this._uniqueMap.containsKey(value)) {
                return true;
            }
            this._uniqueMap.put(value, value);
            return false;
        }
        return false;
    }

    public void reset() {
        this._uniqueMap.clear();
    }

    public HashMap getUniqueMap() {
        return this._uniqueMap;
    }
}

