/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.File;
import java.util.Stack;
import java.util.Vector;

public class FileFinder {
    private Vector _files = new Vector();

    public Vector getFiles() {
        return this._files;
    }

    public static void main(String[] args) {
        String[] suffix = new String[]{".gif", ".jpg", ".tif"};
        String userDir = System.getProperty("user.dir");
        String path = new File(userDir).getParent();
        System.out.println("Looking in path:" + path);
        FileFinder ff = new FileFinder(path, suffix);
        ff.print();
    }

    public void print() {
        int noFiles = this._files.size();
        if (noFiles == 0) {
            System.out.println("No _files found.");
            return;
        }
        System.out.print("Found " + noFiles + " file");
        if (noFiles != 1) {
            System.out.println("s.");
        } else {
            System.out.println(".");
        }
        for (int i = 0; i < noFiles; ++i) {
            String path = ((File)this._files.elementAt(i)).getAbsolutePath();
            System.out.println(path);
        }
    }

    public FileFinder(String start, String[] extensions) {
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(start);
        if (startdir.isDirectory()) {
            dirs.push(new File(start));
        }
        while (dirs.size() > 0) {
            File dirFiles = (File)dirs.pop();
            String[] s = dirFiles.list();
            if (s == null) continue;
            for (int i = 0; i < s.length; ++i) {
                File file = new File(dirFiles.getAbsolutePath() + File.separator + s[i]);
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!FileFinder.match(s[i], extensions)) continue;
                this._files.addElement(file);
            }
        }
    }

    private static boolean match(String s1, String[] suffixes) {
        for (int i = 0; i < suffixes.length; ++i) {
            if (s1.length() < suffixes[i].length() || !s1.substring(s1.length() - suffixes[i].length(), s1.length()).equalsIgnoreCase(suffixes[i])) continue;
            return true;
        }
        return false;
    }
}

