/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class CompilingClassLoader
extends ClassLoader {
    private byte[] getBytes(String filename) throws IOException {
        File file = new File(filename);
        FileInputStream fin = new FileInputStream(file);
        long len = file.length();
        byte[] raw = new byte[(int)len];
        int r = fin.read(raw);
        if ((long)r != len) {
            throw new IOException("Can't read all, " + r + " != " + len);
        }
        fin.close();
        return raw;
    }

    private boolean compile(String javaFile) throws IOException {
        System.out.println("CCL: Compiling " + javaFile + "...");
        Process p = Runtime.getRuntime().exec("javac " + javaFile);
        try {
            p.waitFor();
        }
        catch (InterruptedException ie) {
            System.out.println(ie);
        }
        int ret = p.exitValue();
        return ret == 0;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clas = null;
        clas = this.findLoadedClass(name);
        String fileStub = name.replace('.', '/');
        String javaFilename = fileStub + ".java";
        String classFilename = fileStub + ".class";
        File javaFile = new File(javaFilename);
        File classFile = new File(classFilename);
        if (javaFile.exists() && (!classFile.exists() || javaFile.lastModified() > classFile.lastModified())) {
            try {
                if (!this.compile(javaFilename) || !classFile.exists()) {
                    throw new ClassNotFoundException("Compile failed: " + javaFilename);
                }
            }
            catch (IOException ie) {
                throw new ClassNotFoundException(ie.toString());
            }
        }
        try {
            byte[] raw = this.getBytes(classFilename);
            clas = this.defineClass(name, raw, 0, raw.length);
        }
        catch (IOException ie) {
            // empty catch block
        }
        if (clas == null) {
            clas = this.findSystemClass(name);
        }
        if (resolve && clas != null) {
            this.resolveClass(clas);
        }
        if (clas == null) {
            throw new ClassNotFoundException(name);
        }
        return clas;
    }
}

