/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.files;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.io.files.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files
extends Strings {
    private static final char altSeparatorChar = (char)(File.separatorChar == '/' ? 92 : 47);
    public static final int FIND_FILE = 1;
    public static final int FIND_DIRECTORY = 2;
    public static final int FIND_ALL = 3;
    public static FileFilter directoryFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    static /* synthetic */ Class class$com$jaxfront$core$util$io$files$Files;

    public static final String getFullPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static final String getFullPath(String path) {
        return Files.getFullPath(new File(path));
    }

    public static String relPath(String dir, String path) {
        String fulldir;
        String fullpath = Files.getFullPath(path);
        if (!fullpath.startsWith(new StringBuffer().append(fulldir = Files.getFullPath(dir)).append(File.separatorChar).toString())) {
            return path;
        }
        String result = fullpath.substring(fulldir.length() + 1);
        if (dir.indexOf(File.separatorChar) < 0 && path.indexOf(File.separatorChar) < 0 && (dir.indexOf(altSeparatorChar) >= 0 || path.indexOf(altSeparatorChar) >= 0)) {
            return result.replace(File.separatorChar, altSeparatorChar);
        }
        return result;
    }

    public static String path(String currentDir, String filepath) {
        return filepath.charAt(0) == File.separatorChar || filepath.charAt(0) == altSeparatorChar || filepath.indexOf(58) > 0 || Files.isEmpty(currentDir) ? filepath : new StringBuffer().append(currentDir).append(currentDir.endsWith(File.separator) ? "" : File.separator).append(filepath).toString();
    }

    public static String[] splitPath(String path) {
        return new String[]{Files.dirname(path), new File(path).getName()};
    }

    public static String dirname(File file) {
        String parent = file.getParent();
        if (parent == null) {
            parent = ".";
        }
        if (file.getPath().indexOf(File.separatorChar) < 0 && file.getPath().indexOf(altSeparatorChar) >= 0 && parent.indexOf(File.separatorChar) >= 0) {
            parent = parent.replace(File.separatorChar, altSeparatorChar);
        }
        return parent;
    }

    public static String dirname(String path) {
        String dirname = Files.dirname(new File(path));
        if (path.indexOf(altSeparatorChar) >= 0 && path.indexOf(File.separatorChar) < 0) {
            return dirname.replace(File.separatorChar, altSeparatorChar);
        }
        return dirname;
    }

    public static String filename(String path) {
        return new File(path).getName();
    }

    public static List find(File subdir, Pattern pattern) {
        ArrayList<String> resultSet = new ArrayList<String>();
        File[] contents = subdir.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            String path = Files.getFullPath(contents[i]);
            if (contents[i].isDirectory()) {
                resultSet.addAll(Files.find(contents[i], pattern));
                continue;
            }
            if (pattern.matcher(path).find()) {
                resultSet.add(path);
                continue;
            }
            if (!pattern.matcher(path = path.replace(File.separatorChar, '/')).find()) continue;
            resultSet.add(path);
        }
        return resultSet;
    }

    public static List find(String subdir, Pattern pattern) {
        return Files.find(new File(subdir), pattern);
    }

    public static List find(String subdir, String pattern) {
        try {
            return Files.find(subdir, Pattern.compile(pattern, 2));
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public static String findLatest(String subdir, String pattern, int whatExactly) {
        List all = Files.find(subdir, pattern);
        String currentFile = null;
        long currentTime = 0L;
        Iterator i = all.iterator();
        while (i.hasNext()) {
            boolean isGood;
            File candidate = new File(i.next().toString());
            boolean bl = isGood = ((candidate.isDirectory() ? 2 : (candidate.isFile() ? 1 : 0)) & whatExactly) != 0;
            if (currentTime >= candidate.lastModified() || !isGood) continue;
            try {
                currentTime = candidate.lastModified();
                currentFile = candidate.getCanonicalPath();
            }
            catch (Exception e) {}
        }
        return currentFile;
    }

    public static String findLatest(String subdir, String pattern) {
        return Files.findLatest(subdir, pattern, 3);
    }

    public static String findLatestFile(String subdir, String pattern) {
        return Files.findLatest(subdir, pattern, 1);
    }

    public static String findLatestDirectory(String subdir, String pattern) {
        return Files.findLatest(subdir, pattern, 2);
    }

    public static final File[] listSubdirectories(File dir) {
        return dir.isDirectory() ? dir.listFiles(directoryFilter) : null;
    }

    public static final String lastModified(File file) {
        return new Date(file.lastModified()).toString();
    }

    public static String getcwd() {
        return System.getProperty("user.dir");
    }

    public static String chdir(String dir) {
        String cwd = System.getProperty("user.dir");
        if (dir != null) {
            System.setProperty("user.dir", dir);
        }
        return cwd;
    }

    public static boolean deleteFile(String filename) {
        return Files.deleteFile(new File(filename));
    }

    public static boolean deleteFile(File file) {
        try {
            if (file.isDirectory()) {
                String fullpath = file.getCanonicalPath();
                String[] contents = file.list();
                for (int i = 0; i < contents.length; ++i) {
                    Files.deleteFile(new File(fullpath, contents[i]));
                }
            }
            return !file.exists() || file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean deleteFiles(List files) {
        boolean result = false;
        for (int i = 0; i < files.size() && (result = Files.deleteFile(files.get(i).toString())); ++i) {
        }
        return result;
    }

    public static FileOutputStream makeFile(String dirname, String filename, boolean append) throws IOException {
        File dir;
        if (!Files.isEmpty(dirname) && !(dir = new File(dirname)).isDirectory()) {
            if (dir.exists()) {
                dir.delete();
            }
            dir.mkdirs();
        }
        return new FileOutputStream(new File(dirname, filename), append);
    }

    public static FileOutputStream makeFile(String dir, String filename) throws IOException {
        return Files.makeFile(dir, filename, false);
    }

    public static FileOutputStream makeFile(String[] path, boolean append) throws IOException {
        return Files.makeFile(path[0], path[1], append);
    }

    public static FileOutputStream makeFile(String[] path) throws IOException {
        return Files.makeFile(path[0], path[1]);
    }

    public static FileOutputStream makeFile(String path, boolean append) throws IOException {
        return Files.makeFile(Files.splitPath(path), append);
    }

    public static FileOutputStream makeFile(String path) throws IOException {
        return Files.makeFile(Files.splitPath(path));
    }

    public static FileOutputStream makeFile(File file, boolean append) throws IOException {
        return Files.makeFile(file.getCanonicalPath(), append);
    }

    public static FileOutputStream makeFile(File file) throws IOException {
        return Files.makeFile(file.getCanonicalPath());
    }

    public static final OutputStreamWriter makeFileWriter(String path, String encoding) throws IOException {
        return new OutputStreamWriter((OutputStream)Files.makeFile(path), encoding);
    }

    public static final String readString(Reader reader) {
        try {
            int l;
            StringBuffer buf = new StringBuffer();
            char[] chars = new char[65536];
            while ((l = reader.read(chars)) > 0) {
                buf.append(chars, 0, l);
            }
            return buf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String readStringFromFile(File file) {
        try {
            return Files.readString(new FileReader(file));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String readStringFromFile(File file, String encoding) {
        try {
            return Files.readString(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String readStringFromFile(String filename) {
        return Files.readStringFromFile(new File(filename));
    }

    public static final byte[] readBytesFromStream(InputStream is) {
        try {
            int l;
            ArrayList<byte[]> chunkList = new ArrayList<byte[]>();
            StringBuffer buf = new StringBuffer();
            int total = 0;
            while ((l = is.available()) > 0) {
                byte[] chunk = new byte[l];
                is.read(chunk);
                chunkList.add(chunk);
                total += l;
            }
            byte[] buffer = new byte[total];
            int pos = 0;
            for (int i = 0; i < chunkList.size(); ++i) {
                byte[] chunk = (byte[])chunkList.get(i);
                System.arraycopy(chunk, 0, buffer, pos, chunk.length);
            }
            return buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final byte[] readBytesFromFile(String filename) {
        try {
            return Files.readBytesFromStream(new FileInputStream(filename));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File writeToFile(CharSequence data, String fileTo) {
        try {
            File file = new File(fileTo);
            OutputStreamWriter sw = new OutputStreamWriter(Files.makeFile(file));
            Files.write(sw, data);
            sw.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File writeToFile(char[] data, String fileTo) {
        try {
            File file = new File(fileTo);
            OutputStreamWriter sw = new OutputStreamWriter(Files.makeFile(file));
            sw.write(data);
            sw.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File writeToFile(byte[] data, String fileTo) {
        try {
            File file = new File(fileTo);
            FileOutputStream os = Files.makeFile(file);
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File writeBytesToFile(byte[] data, String fileTo) {
        return Files.writeToFile(data, fileTo);
    }

    public static final File writeToFile(InputStream is, String fileTo) throws IOException {
        File file = new File(fileTo);
        FileOutputStream os = Files.makeFile(file);
        Files.pipe(is, os, false);
        ((OutputStream)os).close();
        return file;
    }

    public static final File appendToFile(CharSequence data, String fileTo) {
        try {
            File file = new File(fileTo);
            OutputStreamWriter sw = new OutputStreamWriter(Files.makeFile(file, true));
            Files.write(sw, data);
            sw.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File appendToFile(char[] data, String fileTo) {
        try {
            File file = new File(fileTo);
            OutputStreamWriter sw = new OutputStreamWriter(Files.makeFile(file, true));
            sw.write(data);
            sw.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File appendToFile(byte[] data, String fileTo) {
        try {
            File file = new File(fileTo);
            FileOutputStream os = Files.makeFile(file, true);
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File appendBytesToFile(char[] data, String fileTo) {
        return Files.appendBytesToFile(Files.toBytes(data), fileTo);
    }

    public static final File appendBytesToFile(byte[] data, String fileTo) {
        return Files.appendToFile(data, fileTo);
    }

    public static final String getPackageName(String basePath, String currentPath) {
        String path = Files.relPath(basePath, currentPath);
        return path == null ? null : (path.equals(currentPath) ? null : path.replace(File.separatorChar, '.'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream in, OutputStream out, boolean isBlocking, ByteFilter filter) throws IOException {
        byte[] buf = new byte[50000];
        int total = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            int navailable;
            while ((navailable = isBlocking ? buf.length : in.available()) > 0 && (nread = in.read(buf, 0, Math.min(buf.length, navailable))) >= 0) {
                if (filter == null) {
                    out.write(buf, 0, nread);
                } else {
                    byte[] filtered = filter.filter(buf, nread);
                    out.write(filtered);
                }
                total += nread;
            }
        }
        out.flush();
        buf = null;
    }

    public static void pipe(InputStream in, OutputStream out, boolean isBlocking) throws IOException {
        Files.pipe(in, out, isBlocking, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pipe(Reader in, Writer out) {
        if (in == null) {
            return false;
        }
        if (out == null) {
            return false;
        }
        try {
            Reader reader = in;
            synchronized (reader) {
                int c;
                while (in.ready() && (c = in.read()) > 0) {
                    out.write(c);
                }
            }
            out.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean copy(String from, String to, String what) {
        return Files.copy(new File(from, what), new File(to, what), false);
    }

    public static boolean copy(File from, File to, String what, boolean overwrite) {
        return Files.copy(new File(from, what), new File(to, what), overwrite);
    }

    public static boolean copy(String from, String to, boolean overwrite) {
        return Files.copy(new File(from), new File(to), overwrite);
    }

    public static boolean copy(String from, String to) {
        return Files.copy(from, to, false);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean copy(File from, File to, boolean overwrite) {
        if (to != null && !overwrite && to.isFile() && to.exists()) {
            return false;
        }
        if (from.exists()) {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(Files.class$com$jaxfront$core$util$io$files$Files == null ? (Files.class$com$jaxfront$core$util$io$files$Files = Files.class$("com.jaxfront.core.util.io.files.Files")) : Files.class$com$jaxfront$core$util$io$files$Files, new StringBuffer().append("try to copy from:").append(from).append(" to:").append(to).toString());
            }
            if (from.isDirectory()) {
                contents = from.list();
                for (i = 0; contents != null && i < contents.length; ++i) {
                    Files.copy(from, to, contents[i], overwrite);
                }
            } else {
                os = null;
                is = null;
                try {
                    is = new FileInputStream(from);
                    os = Files.makeFile(to);
                    Files.pipe(is, os, false);
                    is.close();
                    os.close();
                }
                catch (IOException ex) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) ** GOTO lbl32
                        os.close();
                    }
                    catch (IOException ex2) {
                        LogRegistry.getInstance().warn(Files.class$com$jaxfront$core$util$io$files$Files == null ? (Files.class$com$jaxfront$core$util$io$files$Files = Files.class$("com.jaxfront.core.util.io.files.Files")) : Files.class$com$jaxfront$core$util$io$files$Files, ex.getMessage());
                        return false;
                    }
                }
            }
lbl32:
            // 4 sources

            time = from.lastModified();
            if (!to.setLastModified(time)) {
                return false;
            }
            newtime = to.lastModified();
            return time == newtime;
        }
        if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(Files.class$com$jaxfront$core$util$io$files$Files == null ? (Files.class$com$jaxfront$core$util$io$files$Files = Files.class$("com.jaxfront.core.util.io.files.Files")) : Files.class$com$jaxfront$core$util$io$files$Files, new StringBuffer().append("source does not exist:").append(from.toString()).toString());
        }
        return false;
    }

    public static int compare(File left, File right) throws IOException {
        long rl;
        long rm;
        long lm = left.lastModified() / 1000L;
        if (lm < (rm = right.lastModified() / 1000L)) {
            return -1;
        }
        if (lm > rm) {
            return 1;
        }
        long ll = left.length();
        if (ll < (rl = right.length())) {
            return -1;
        }
        if (ll > rl) {
            return 1;
        }
        BufferedInputStream is1 = new BufferedInputStream(new FileInputStream(left));
        BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(right));
        for (long i = 0L; i < ll; ++i) {
            int b1 = ((InputStream)is1).read();
            int b2 = ((InputStream)is2).read();
            if (b1 < 0) {
                return -1;
            }
            if (b2 < 0) {
                return 1;
            }
            if (b1 == b2) continue;
            return b1 < b2 ? -1 : 1;
        }
        return 0;
    }

    public static boolean synchronize(File left, File right, String what) {
        return Files.synchronize(new File(left, what), new File(right, what));
    }

    public static boolean synchronize(File left, File right) {
        if (left.isDirectory() || right.isDirectory()) {
            HashSet<String> contents = new HashSet<String>();
            String[] leftContents = left.list();
            for (int i = 0; leftContents != null && i < leftContents.length; ++i) {
                contents.add(leftContents[i]);
            }
            String[] rightContents = right.list();
            for (int i = 0; rightContents != null && i < rightContents.length; ++i) {
                contents.add(rightContents[i]);
            }
            Iterator i = contents.iterator();
            while (i.hasNext()) {
                if (Files.synchronize(left, right, (String)i.next())) continue;
                return false;
            }
        } else {
            long leftTime = left.lastModified();
            long rightTime = right.lastModified();
            if (left.exists() && (!right.exists() || leftTime < rightTime)) {
                return Files.copy(left, right, false);
            }
            if (right.exists() && (!left.exists() || leftTime > rightTime)) {
                return Files.copy(right, left, false);
            }
        }
        return true;
    }

    public static boolean unzip(ZipInputStream zis, File location) throws IOException {
        ZipEntry ze;
        if (!location.exists()) {
            location.mkdirs();
        }
        while ((ze = zis.getNextEntry()) != null) {
            File output = new File(location, ze.getName());
            if (ze.isDirectory()) {
                output.mkdirs();
                continue;
            }
            File dir = output.getParentFile();
            if (!dir.isDirectory()) {
                dir.delete();
            }
            dir.mkdirs();
            if (!dir.exists()) {
                System.err.println(new StringBuffer().append("Could not create directory ").append(dir.getCanonicalPath()).toString());
                return false;
            }
            FileOutputStream os = new FileOutputStream(output);
            Files.pipe(zis, os, true);
            ((OutputStream)os).close();
        }
        zis.close();
        return true;
    }

    public static boolean install(Class clazz, String resourceArchiveName, File location) throws IOException {
        ZipInputStream zis = new ZipInputStream(clazz.getResourceAsStream(resourceArchiveName));
        return Files.unzip(zis, location);
    }

    public static boolean install(Class clazz, String resourceArchiveName, String folderName) throws IOException {
        return Files.install(clazz, resourceArchiveName, new File(folderName));
    }

    public static void createZipFile(File srcDir, OutputStream out, boolean verbose) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(9);
        zout.setComment("Zipper v1.2");
        Files.createZipFile(srcDir, zout, verbose, null, null);
        zout.close();
    }

    public static void createZipFile(File srcDir, ZipOutputStream zout, boolean verbose, String includeFilter, String excludeFilter) throws IOException {
        Pattern includePattern = includeFilter != null ? Pattern.compile(includeFilter, 2) : null;
        Pattern excludePattern = excludeFilter != null ? Pattern.compile(excludeFilter, 2) : null;
        List<String> fileList = Files.listDirectory(srcDir);
        for (String fileName : fileList) {
            ZipEntry ze;
            boolean add;
            File file = new File(srcDir.getParent(), fileName);
            String zipName = fileName;
            if (File.separatorChar != '/') {
                zipName = fileName.replace(File.separatorChar, '/');
            }
            boolean bl = add = includeFilter == null;
            if (includePattern != null && includePattern.matcher(zipName).find()) {
                add = true;
            }
            if (excludePattern != null && excludePattern.matcher(zipName).find()) {
                add = false;
                System.out.println(new StringBuffer().append("skip:").append(zipName).toString());
            }
            if (!add) continue;
            if (verbose) {
                System.out.println(new StringBuffer().append("  adding: ").append(fileName).toString());
            }
            if (file.isFile()) {
                int n;
                ze = new ZipEntry(zipName);
                ze.setTime(file.lastModified());
                zout.putNextEntry(ze);
                FileInputStream fin = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                while ((n = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, n);
                }
                fin.close();
                continue;
            }
            ze = new ZipEntry(new StringBuffer().append(zipName).append('/').toString());
            ze.setTime(file.lastModified());
            zout.putNextEntry(ze);
        }
    }

    public static List<String> listDirectory(File directory) throws IOException {
        Stack<String> stack = new Stack<String>();
        ArrayList<String> list = new ArrayList<String>();
        if (directory.isFile()) {
            if (directory.canRead()) {
                list.add(directory.getName());
            }
            return list;
        }
        String root = directory.getParent();
        stack.push(directory.getName());
        while (!stack.empty()) {
            String current = (String)stack.pop();
            File curDir = new File(root, current);
            String[] fileList = curDir.list();
            if (fileList == null) continue;
            for (String entry : fileList) {
                File f = new File(curDir, entry);
                if (f.isFile()) {
                    if (f.canRead()) {
                        list.add(new StringBuffer().append(current).append(File.separator).append(entry).toString());
                        continue;
                    }
                    System.err.println(new StringBuffer().append("File ").append(f.getPath()).append(" is unreadable").toString());
                    throw new IOException(new StringBuffer().append("Can't read file: ").append(f.getPath()).toString());
                }
                if (f.isDirectory()) {
                    list.add(new StringBuffer().append(current).append(File.separator).append(entry).toString());
                    stack.push(new StringBuffer().append(current).append(File.separator).append(f.getName()).toString());
                    continue;
                }
                throw new IOException(new StringBuffer().append("Unknown entry: ").append(f.getPath()).toString());
            }
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public static interface BufferingFilter
    extends ByteFilter {
        public byte[] getBuffer();

        public void clear();
    }

    public static interface ByteFilter {
        public byte[] filter(byte[] var1, int var2);
    }
}

