/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEdit;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Element;

public class CompoundEditWrapper
extends CompoundEdit
implements JAXFrontUndoableEdit {
    private boolean _wasErrorControllerBlocked;
    protected Document _targetDOM = null;
    protected JAXFrontUndoManager _manager = null;

    public CompoundEditWrapper() {
    }

    public CompoundEditWrapper(JAXFrontUndoManager manager) {
        this._manager = manager;
        this._targetDOM = manager._dom;
    }

    public CompoundEditWrapper(JAXFrontUndoManager manager, Element serializedChilds) {
        this._manager = manager;
        this._targetDOM = manager._dom;
        List eventList = DOMHelper.getChildren(null, serializedChilds, "Event");
        for (int e = 0; e < eventList.size(); ++e) {
            Element event = (Element)eventList.get(e);
            this.edits.add(JAXFrontUndoManager.parseEventObject(manager, this, this._targetDOM, event, null));
        }
        this.end();
    }

    public void serialize(PrintWriter writer) {
        for (int i = 0; i < this.edits.size(); ++i) {
            Object aEdit = this.edits.get(i);
            writer.print("<Event eventClass=\"" + aEdit.getClass().getName() + "\">");
            if (aEdit instanceof JAXFrontUndoableEditWrapper) {
                ((JAXFrontUndoableEditWrapper)aEdit).serialize(writer);
            }
            writer.print("</Event>");
        }
    }

    public void undo() throws CannotUndoException {
        if (this._targetDOM != null) {
            this._wasErrorControllerBlocked = this._targetDOM.getController().getErrorController().isBlocked();
            this._targetDOM.getController().getErrorController().setBlocked(true);
        }
        super.undo();
        if (this._targetDOM != null && !this._wasErrorControllerBlocked) {
            this._targetDOM.getController().getErrorController().setBlocked(false);
        }
    }

    public void redo() {
        if (this._targetDOM != null) {
            this._wasErrorControllerBlocked = this._targetDOM.getController().getErrorController().isBlocked();
            this._targetDOM.getController().getErrorController().setBlocked(true);
        }
        super.redo();
        if (this._targetDOM != null && !this._wasErrorControllerBlocked) {
            this._targetDOM.getController().getErrorController().setBlocked(false);
        }
    }

    public void macroUndo() throws CannotUndoException {
        if (this._targetDOM != null) {
            this._wasErrorControllerBlocked = this._targetDOM.getController().getErrorController().isBlocked();
            this._targetDOM.getController().getErrorController().setBlocked(true);
        }
        int i = this.edits.size();
        while (i-- > 0) {
            UndoableEdit e = (UndoableEdit)this.edits.elementAt(i);
            e.undo();
        }
        if (this._targetDOM != null && !this._wasErrorControllerBlocked) {
            this._targetDOM.getController().getErrorController().setBlocked(false);
        }
    }

    public void macroRedo() {
        if (this._targetDOM != null) {
            this._wasErrorControllerBlocked = this._targetDOM.getController().getErrorController().isBlocked();
            this._targetDOM.getController().getErrorController().setBlocked(true);
        }
        Enumeration cursor = this.edits.elements();
        while (cursor.hasMoreElements()) {
            ((UndoableEdit)cursor.nextElement()).redo();
        }
        if (this._targetDOM != null && !this._wasErrorControllerBlocked) {
            this._targetDOM.getController().getErrorController().setBlocked(false);
        }
    }

    public void end() {
        Object last;
        if (this.edits != null && this.edits.size() > 0 && (last = this.edits.lastElement()) != null && last instanceof JAXFrontUndoableEdit) {
            ((JAXFrontUndoableEdit)last).setLast(true);
        }
        super.end();
    }

    public void setLast(boolean b) {
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (this.edits.size() == 0 && anEdit instanceof JAXFrontUndoableEdit) {
            ((JAXFrontUndoableEdit)anEdit).setFirst(true);
        }
        return super.addEdit(anEdit);
    }

    public void setFirst(boolean b) {
    }

    public String getInfo() {
        StringBuffer info = new StringBuffer();
        for (int i = 0; i < this.edits.size(); ++i) {
            UndoableEdit aEdit = (UndoableEdit)this.edits.get(i);
            if (aEdit instanceof JAXFrontUndoableEdit) {
                info.append(((JAXFrontUndoableEdit)aEdit).getInfo());
                continue;
            }
            info.append(aEdit.getClass().getName());
        }
        return "Compound edit:" + info.toString();
    }
}

