/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ListSortUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    private int _direction;
    private int _inverseDirection;

    public ListSortUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, ListType target, int direction, int inverseDirection, String action) {
        super(manager, target);
        this._sourceType = eventSource;
        this._action = action;
        this._direction = direction;
        this._inverseDirection = inverseDirection;
    }

    public ListSortUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, int direction, int inverseDirection, String action) {
        super(manager, target);
        this._sourceType = eventSource;
        this._action = action;
        this._direction = direction;
        this._inverseDirection = inverseDirection;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            ((AbstractListType)tt).sort(this._direction);
            this.visualizeRedo(tt);
            this.stopBlocking();
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            ((AbstractListType)tt).sort(this._inverseDirection);
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        writer.print("<direction>");
        writer.print(this._direction);
        writer.print("</direction>");
        writer.print("<inverseDirection>");
        writer.print(this._inverseDirection);
        writer.print("</inverseDirection>");
    }
}

