/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.lang.StringEscapeUtils;

public class PasteUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    String _oldValue;
    String _newValue;

    public PasteUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, Type target, String oldValue, String newValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldValue = oldValue;
        this._newValue = newValue;
    }

    public PasteUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, String oldValue, String newValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldValue = StringEscapeUtils.unescapeXml((String)oldValue);
        this._newValue = StringEscapeUtils.unescapeXml((String)newValue);
    }

    public String getPresentationName() {
        return "Paste";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            try {
                this.startBlocking();
                tt.getDOM().getClipBoard().doPaste(tt, this._newValue, this._oldValue, true);
                this.stopBlocking();
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            try {
                this.startBlocking();
                tt.getDOM().getClipBoard().doPaste(tt, this._oldValue, this._newValue, true);
                this.stopBlocking();
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        writer.print("<oldValue>");
        writer.print(StringEscapeUtils.escapeXml((String)this._oldValue));
        writer.print("</direction>");
        writer.print("<newValue>");
        writer.print(StringEscapeUtils.escapeXml((String)this._newValue));
        writer.print("</newValue>");
    }

    public void die() {
        super.die();
        this._oldValue = null;
        this._newValue = null;
    }
}

