/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TypeAttributeIterator
implements Iterator {
    private List types;
    int currentPos = 0;
    private boolean _onlySerializable = false;
    private Type node;

    public TypeAttributeIterator(Type contextType, boolean onlySearializable) {
        this._onlySerializable = onlySearializable;
        if (contextType != null) {
            this.initChilds(contextType);
            this.node = this.getFirstNode(contextType);
        }
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Type ret = this.node;
        this.node = this.getNextNode(this.node);
        return ret;
    }

    private void initChilds(Type aType) {
        List directChilds = aType.getDirectChildren();
        this.types = new Vector();
        for (int i = 0; i < directChilds.size(); ++i) {
            Type aChildType = (Type)directChilds.get(i);
            if (!aChildType.isAttribute()) continue;
            if (this._onlySerializable) {
                if (!aChildType.isSerializable()) continue;
                this.types.add(aChildType);
                continue;
            }
            this.types.add(aChildType);
        }
    }

    public void remove() {
        this.types.remove(this.currentPos);
        this.node = this.currentPos < this.types.size() ? (Type)this.types.get(this.currentPos) : null;
    }

    protected Type getFirstNode(Type contextNode) {
        if (this.types.size() > 0) {
            return (Type)this.types.get(this.currentPos++);
        }
        return null;
    }

    protected Type getNextNode(Type contextNode) {
        if (this.currentPos < this.types.size()) {
            return (Type)this.types.get(this.currentPos++);
        }
        return null;
    }
}

