/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath.schema;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.xpath.schema.DummySchemaRoot;
import com.jaxfront.core.xpath.schema.SchemaAttributeIterator;
import com.jaxfront.core.xpath.schema.SchemaIterator;
import com.jaxfront.core.xpath.schema.SchemaParentIterator;
import com.jaxfront.core.xpath.schema.SchemaXPath;
import com.jaxfront.core.xpath.schema.SelfAxisIterator;
import java.util.Hashtable;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;

public class SchemaDocumentNavigator
extends DefaultNavigator {
    private boolean _namespaceAware = true;
    private Hashtable _namespaceMapping;
    private Hashtable _recursions;
    private static final SchemaDocumentNavigator SINGLETON = new SchemaDocumentNavigator();

    public static Navigator getInstance() {
        return SINGLETON;
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof DummySchemaRoot) {
            return contextNode;
        }
        return contextNode instanceof SchemaNode ? ((SchemaNode)contextNode).getSchema().getRootElement() : null;
    }

    public void reset() {
        this._namespaceAware = true;
        this._recursions = null;
        this._namespaceMapping = null;
    }

    public Iterator getParentAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new SchemaParentIterator((SchemaNode)contextNode);
    }

    public Iterator getAttributeAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new SchemaAttributeIterator((SchemaNode)contextNode);
    }

    public Iterator getChildAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new SchemaIterator((SchemaNode)contextNode, this);
    }

    public String getElementNamespaceUri(Object element, boolean stepIsPrefixed) {
        if (this.isNamespaceAware()) {
            String tns = ((SchemaNode)element).getTargetNS();
            if (!stepIsPrefixed && tns == ((SchemaNode)element).getSchema().getTargetNamespace()) {
                return null;
            }
            return tns;
        }
        return null;
    }

    public String getElementName(Object element) {
        return ((SchemaNode)element).getName();
    }

    public String getElementQName(Object element) {
        return ((SchemaNode)element).getQName();
    }

    public String getAttributeNamespaceUri(Object attr) {
        return null;
    }

    public String getAttributeName(Object attr) {
        return ((SchemaNode)attr).getName();
    }

    public String getAttributeQName(Object attr) {
        return ((SchemaNode)attr).getQName();
    }

    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public boolean isElement(Object object) {
        if (object instanceof SchemaNode) {
            switch (((SchemaNode)object).getNode().getType()) {
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 7: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 8: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isAttribute(Object object) {
        if (object instanceof SchemaNode) {
            return ((SchemaNode)object).getNode().getType() == 1;
        }
        return false;
    }

    public boolean isNamespace(Object object) {
        return false;
    }

    public boolean isComment(Object object) {
        return false;
    }

    public boolean isText(Object object) {
        if (object instanceof SchemaSimpleType) {
            return ((SchemaSimpleType)object).isMixedContent();
        }
        return false;
    }

    public boolean isProcessingInstruction(Object object) {
        return false;
    }

    public String getCommentStringValue(Object comment) {
        return null;
    }

    public String getElementStringValue(Object element) {
        return "NULL";
    }

    public String getAttributeStringValue(Object attr) {
        return null;
    }

    public String getNamespaceStringValue(Object ns) {
        return null;
    }

    public String getTextStringValue(Object txt) {
        return null;
    }

    public String getNamespacePrefix(Object ns) {
        return ((SchemaNode)ns).getNamespacePrefix();
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new SchemaXPath(xpath);
    }

    public Iterator getSelfAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new SelfAxisIterator(contextNode);
    }

    public void setNamespaceAware(boolean aware) {
        this._namespaceAware = aware;
    }

    public boolean isNamespaceAware() {
        return this._namespaceAware;
    }

    public void setNamespaceMapping(Hashtable namespaceMapping) {
        this._namespaceMapping = namespaceMapping;
    }

    public Hashtable getNamespaceMapping() {
        return this._namespaceMapping;
    }

    public Object putRecursion(Object recObj, Object startContext) {
        if (this._recursions == null) {
            this._recursions = new Hashtable();
        }
        return this._recursions.put(recObj, startContext);
    }

    public Object getRecursionContext(Object recObj) {
        return this._recursions.get(recObj);
    }

    public boolean isRecursion(Object recObj, Object startContext) {
        if (this._recursions == null || recObj == null) {
            return false;
        }
        Object context = this.getRecursionContext(recObj);
        return startContext == context || context != null && ((SchemaNode)context).getQName().equals(((SchemaNode)startContext).getQName());
    }

    public String getElementNamespaceUri(Object element) {
        return this.getElementNamespaceUri(element, false);
    }
}

