/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath.schema;

import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.xpath.schema.SchemaDocumentNavigator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SchemaIterator
implements Iterator {
    private List types;
    int currentPos = 0;
    private SchemaNode node;
    private SchemaDocumentNavigator _nav;

    public SchemaIterator(SchemaNode contextType, SchemaDocumentNavigator nav) {
        this._nav = nav;
        this.initChilds(contextType);
        this.node = this.getFirstNode(contextType);
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        SchemaNode ret = this.node;
        this.node = this.getNextNode(this.node);
        return ret;
    }

    private void initChilds(SchemaNode aType) {
        SchemaNode[] elements;
        this.types = new Vector();
        if (!aType.isSimple() && (elements = aType.getElementSet()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                SchemaNode aChildType = elements[i];
                if (this._nav.isRecursion(aChildType, aType)) continue;
                Object alreadyRegistred = null;
                if (aChildType.getSchemaType().isRecursive()) {
                    alreadyRegistred = this._nav.putRecursion(aChildType, aType);
                }
                if (alreadyRegistred != null) continue;
                this.types.add(aChildType);
            }
        }
    }

    public void remove() {
        this.types.remove(this.currentPos);
        this.node = this.currentPos < this.types.size() ? (SchemaNode)this.types.get(this.currentPos) : null;
    }

    protected SchemaNode getFirstNode(SchemaNode contextNode) {
        if (this.types.size() > 0) {
            return (SchemaNode)this.types.get(this.currentPos++);
        }
        return null;
    }

    protected SchemaNode getNextNode(SchemaNode contextNode) {
        if (this.currentPos < this.types.size()) {
            return (SchemaNode)this.types.get(this.currentPos++);
        }
        return null;
    }
}

