/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import com.jaxfront.core.xui.CodeSet;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLResourceCodeSetCreator
implements CodeSet {
    private URL _locationURL = null;
    private String _keyXPath = null;
    private String _labelXPath = null;
    private String _descXPath = null;
    private String _codeSetName = null;
    private String _lang = null;
    private String _label = null;

    public XMLResourceCodeSetCreator(URL locationURL, String labelXPath, String keyXPath, String descXPath) {
        this._locationURL = locationURL;
        this._keyXPath = keyXPath;
        this._labelXPath = labelXPath;
        this._descXPath = descXPath;
    }

    public XMLResourceCodeSetCreator(URL targetURL, String locationURL, String labelXPath, String keyXPath, String descXPath) {
        this._locationURL = URLHelper.getUserURL(targetURL, locationURL);
        this._keyXPath = keyXPath;
        this._labelXPath = labelXPath;
        this._descXPath = descXPath;
    }

    private Map createCodeSetHASH() {
        LinkedHashMap<String, String> codeHash = new LinkedHashMap<String, String>();
        try {
            List labels;
            Document resourceDom = DOMHelper.createDocument(this._locationURL);
            if (this._labelXPath != null && (labels = W3CXPathExecuterImpl.getInstance().processXPath(resourceDom.getDocumentElement(), this._labelXPath)).size() > 0) {
                Element labelElement = (Element)labels.get(0);
                this._label = DOMHelper.getText(labelElement);
            }
            List keys = W3CXPathExecuterImpl.getInstance().processXPath(resourceDom.getDocumentElement(), this._keyXPath);
            for (int i = 0; i < keys.size(); ++i) {
                Element keyElement = (Element)keys.get(i);
                String key = DOMHelper.getText(keyElement);
                if (this._descXPath != null) {
                    List descs = W3CXPathExecuterImpl.getInstance().processXPath(keyElement, this._descXPath);
                    if (descs.size() > 0) {
                        Object desObject = descs.get(0);
                        if (desObject == null) {
                            codeHash.put(key, "");
                            continue;
                        }
                        if (desObject instanceof Element) {
                            codeHash.put(key, DOMHelper.getText((Element)desObject));
                            continue;
                        }
                        codeHash.put(key, desObject.toString());
                        continue;
                    }
                    codeHash.put(key, "");
                    continue;
                }
                codeHash.put(key, key);
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return codeHash;
    }

    public Reader getCodeSet(Type type, String codeSetName, String versionNo) {
        this._lang = type.getDOM().getLanguage();
        this._codeSetName = codeSetName;
        StringBuffer xmlRep = this.createCodeSetRepresentation(this.createCodeSetHASH());
        return new StringReader(xmlRep.toString());
    }

    private StringBuffer createCodeSetRepresentation(Map codes) {
        String langST = "<" + this._lang + ">";
        String langET = "</" + this._lang + ">";
        StringBuffer result = new StringBuffer("<codes>");
        result.append("<codeSet name=\"" + this._codeSetName + "\">");
        if (this._label != null) {
            result.append(langST);
            result.append(TextTools.replaceGlobalEntities(this._label));
            result.append(langET);
        }
        Iterator entries = codes.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = TextTools.replaceGlobalEntities((String)entry.getKey());
            String desc = (String)entry.getValue();
            result.append("<code id=\"" + key + "\">");
            result.append(langST);
            if (desc != null) {
                result.append(TextTools.replaceGlobalEntities(desc));
            } else {
                result.append(key);
            }
            result.append(langET);
            result.append("</code>");
        }
        result.append("</codeSet>");
        result.append("</codes>");
        return result;
    }
}

