/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.BehaviourDefinition;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.XUITypes;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class XUIDefinition
implements XUITypes,
Serializable {
    private boolean _hasBeenInitializedFromFile;
    private boolean _lateBuilt = false;
    protected boolean _isGlobal;
    private boolean _isInherited;
    private boolean _isTemplate;
    private String _xuiXPath;
    private Type _type;
    private Type _xuiType;
    private StyleDefinition _styleDefinition;
    private BehaviourDefinition _behaviourDefinition;
    private Properties _properties;
    private boolean _released = false;

    public XUIDefinition(Type type, Type xuiType) {
        this(type, xuiType, false, false);
    }

    public XUIDefinition(Type type, Type xuiType, boolean isInherited) {
        this(type, xuiType, isInherited, false);
    }

    public XUIDefinition(Type type, Type xuiType, boolean isInherited, boolean isTemplate) {
        this(type, xuiType, isInherited, isTemplate, false, false);
    }

    public XUIDefinition(Type type, Type xuiType, boolean isInherited, boolean isTemplate, boolean dontBuild, boolean isGlobal) {
        this._type = type;
        this._xuiType = xuiType;
        this._isInherited = isInherited;
        this._isTemplate = isTemplate;
        boolean bl = this._lateBuilt = !dontBuild;
        if (this._xuiType != null) {
            this._isGlobal = isGlobal;
            Type behaviour = this._xuiType.getDirectChild("behaviour");
            if (behaviour != null) {
                if (behaviour.getDirectChild("rule").getDirectChildrenSize() > 0) {
                    this._behaviourDefinition = new BehaviourDefinition(this, behaviour);
                } else if (BehaviourDefinition.definesLogging(behaviour)) {
                    this._behaviourDefinition = new BehaviourDefinition(this, behaviour);
                }
            }
            if (!dontBuild) {
                this.initializeProperties();
                type.setSerializable(this.getStyle().getSerializable());
            }
        }
        this._lateBuilt = !dontBuild;
    }

    public BehaviourDefinition getBehaviour() {
        return this._behaviourDefinition;
    }

    private Document getDOM() {
        return this._type.getDOM();
    }

    public StyleDefinition getStyle() {
        if (this._styleDefinition == null) {
            this._styleDefinition = new StyleDefinition(this, (Type)null);
        }
        return this._styleDefinition;
    }

    public Type getTargetType() {
        Type componentParent = null;
        componentParent = this.getType().getDOM().getRootType().getName().equals("XUI") ? this.getType().getParent("component") : this.getType();
        if (componentParent != null) {
            String xuiXPath;
            Document targetDom;
            Type userType = (Type)componentParent.getUserObject();
            if (userType == null) {
                userType = (Type)this.getUserObject(componentParent);
            }
            if (userType == null && this.getType().getDOM().getEditor() != null && (targetDom = this.getType().getDOM().getEditor().getTargetDOM()) != null && (xuiXPath = componentParent.getDirectChildValue("xpath")) != null) {
                if (xuiXPath.startsWith("global:")) {
                    xuiXPath = "/" + xuiXPath.substring(7);
                }
                userType = TypePathExecuter.getInstance().getTypeForXPath(targetDom.getRootType(), xuiXPath);
            }
            return userType;
        }
        return null;
    }

    public Type getType() {
        return this._type;
    }

    public Type getXUIType() {
        return this._xuiType;
    }

    public String getXUIXPath() {
        String xuiTypeXPath = null;
        if (this.getXUIType() != null && (xuiTypeXPath = this.getXUIType().getDirectChildValue("xpath")) != null) {
            this.setXUIXPath(xuiTypeXPath);
        }
        if (this._xuiXPath == null) {
            this.setXUIXPath(this.getType().getXPathLocation());
        }
        return this._xuiXPath;
    }

    public boolean hasUserModifiedXUIXPath() {
        return this.getXUIXPath() != null && !this.getXUIXPath().startsWith("global:") && !this.getType().getXPathLocation().equals(this.getXUIXPath()) && !this.isAddressedByEditingType();
    }

    public boolean hasModifiedChild() {
        if (this.hasBeenInitializedFromFile()) {
            return true;
        }
        Vector<Type> childsList = null;
        if (this.getType().isComposite()) {
            childsList = ((CompositeType)this.getType()).getComposites();
        }
        if (this.getType().isList()) {
            childsList = new Vector<Type>();
            childsList.addAll(((ListType)this.getType()).getList());
            childsList.add(((ListType)this.getType()).getEditingType());
        }
        if (childsList != null) {
            Iterator listIterator = childsList.iterator();
            while (listIterator.hasNext()) {
                Type child = (Type)listIterator.next();
                if (!child.getXUIDefinition().hasModifiedChild()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasBeenInitializedFromFile() {
        return this._hasBeenInitializedFromFile;
    }

    public void finishInitialization() {
        if (!this._lateBuilt) {
            this._lateBuilt = true;
            if (!this.getDOM().isReleased()) {
                this.initializeProperties();
            }
        }
    }

    public boolean isLateBuilt() {
        return this._lateBuilt;
    }

    private void initializeProperties() {
        ListType props;
        this._hasBeenInitializedFromFile = true;
        this.setXUIXPath(this._xuiType.getDirectChildValue("xpath"));
        String id = this._xuiType.getDirectChildValue("id");
        this._isGlobal = this._xuiXPath != null && this._xuiXPath.startsWith("global:");
        Type style = this._xuiType.getDirectChild("style");
        if (style != null) {
            this._styleDefinition = new StyleDefinition(this, style);
        }
        Type behaviour = null;
        if (this._behaviourDefinition == null && (behaviour = this._xuiType.getDirectChild("behaviour")) != null && behaviour.getDirectChild("rule").getDirectChildrenSize() > 0) {
            this._behaviourDefinition = new BehaviourDefinition(this, behaviour);
        }
        if ((props = (ListType)this._xuiType.getDirectChild("properties")) != null && props.size() > 0) {
            this.initUserProperties(props);
        }
    }

    private void initUserProperties(ListType props) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        Iterator iterator = props.iterator();
        while (iterator.hasNext()) {
            Type property = (Type)iterator.next();
            property = property.getDirectChild("property");
            this._properties.put(property.getDirectChildValue("key"), property.getDirectChildValue("value"));
        }
    }

    public void reinitialize(Type xuiType) {
        this._xuiType = xuiType;
        if (xuiType != null) {
            this.initializeProperties();
        } else {
            this._hasBeenInitializedFromFile = false;
        }
    }

    public void reinitialize(XUIDefinition xuiDefinition) {
        boolean isGlobal = xuiDefinition.isGlobal();
        if (this.getDOM().keepXUIDOMinMemory() && xuiDefinition.getXUIType() != null) {
            this.reinitialize(xuiDefinition.getXUIType());
        } else {
            this._hasBeenInitializedFromFile = true;
            this.setXUIXPath(xuiDefinition.getXUIXPath());
            this._isGlobal = isGlobal;
            this._styleDefinition = new StyleDefinition(this, xuiDefinition.getStyle());
            if (xuiDefinition.getBehaviour() != null) {
                this._behaviourDefinition = new BehaviourDefinition(this, xuiDefinition.getBehaviour());
            }
            if (xuiDefinition._properties != null) {
                this._properties = new Properties(xuiDefinition._properties);
            }
        }
    }

    public void update(XUIDefinition xuiDefinition) {
        this.getStyle().update(xuiDefinition.getStyle());
        if (xuiDefinition.getBehaviour() != null) {
            this.getBehaviour().update(xuiDefinition.getBehaviour());
        }
    }

    public void setXUIXPath(String path) {
        this._xuiXPath = path;
    }

    public void release() {
        if (this._xuiType != null) {
            if (!JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isUsingXUICache() && !this.getDOM().isRunningInXUIEditor() && this._xuiType.getDOM() != DOMBuilder.getInstance().getXUISchemaDOM(this.getDOM().getAppContext()).getXUIDocument()) {
                this._xuiType.release();
            }
            this._xuiType = null;
        }
        if (this._styleDefinition != null) {
            this._styleDefinition.release();
            this._styleDefinition = null;
        }
        if (this._behaviourDefinition != null) {
            this._behaviourDefinition.release();
            this._behaviourDefinition = null;
        }
        this._released = true;
        this._type = null;
    }

    public void setType(Type type) {
        this._type = type;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean isInherited() {
        if (this._isInherited) {
            String tempXPath;
            String origXPath;
            return !this.getType().isGlobal() || (origXPath = this.getType().getXUIDefinition().getXUIXPath()) == null || !origXPath.startsWith("global:") || !(tempXPath = "/" + origXPath.substring(origXPath.indexOf(":") + 1, origXPath.length())).equals(this.getType().getXPathLocation());
        }
        return false;
    }

    public boolean isAddressedByEditingType() {
        return TypePathExecuter.isAddressingIndexedComponent(this.getType().getXPathLocation()) && !this.getType().getXPathLocation().equals(this.getXUIXPath());
    }

    public boolean isTemplate() {
        return this._isTemplate;
    }

    private Object getUserObject(Type type) {
        if (type.getUserObject() != null) {
            return type.getUserObject();
        }
        if (type.getParent() != null) {
            return this.getUserObject(type.getParent());
        }
        return null;
    }

    public void setIsInherited(boolean isInherited) {
        this._isInherited = isInherited;
    }

    public void setXUIType(Type xuiType) {
        this._xuiType = xuiType;
    }

    public boolean isReleased() {
        return this._released;
    }

    public String getProperty(String key) {
        if (this._properties != null) {
            return this._properties.getProperty(key);
        }
        return null;
    }
}

