/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.FunctionViewerFactory;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.FastFailable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class EvaluatorVisitor
implements ParserVisitor {
    protected Stack stack = new Stack();
    private Vector errorList = null;
    protected SymbolTable symTab = null;
    private boolean errorFlag;
    private boolean fastFail = true;
    boolean debug = false;
    private Object communicator;

    public Object getCommunicator() {
        return this.communicator;
    }

    public void setCommunicator(Object aCommunicator) {
        this.communicator = aCommunicator;
    }

    protected void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws Exception {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        topNode.jjtAccept(this, null);
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    public void setFastFail(boolean isFastFail) {
        this.fastFail = isFastFail;
    }

    public Object visit(ASTStart node, Object data) {
        return data;
    }

    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        PostfixMathCommandI pfmc = node.getPFMC();
        data = this.fastFail && pfmc.isFastFailable() ? ((FastFailable)((Object)pfmc)).childrenFastFailAccept(node.children, this.getStack(), this, data) : node.childrenAccept(this, data);
        if (pfmc == null) {
            this.addToErrorList("No function class associated with " + node.getName());
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            if (this.debug) {
                FunctionViewerFactory.getFunctionViewer().viewFunctionStart(pfmc, this.stack);
                pfmc.run(this, this.stack);
                FunctionViewerFactory.getFunctionViewer().viewFunctionEnd(this.stack);
            } else {
                pfmc.run(this, this.stack);
            }
        }
        catch (ParseException e) {
            this.addToErrorList(e.getMessage());
            this.errorFlag = true;
        }
        return data;
    }

    public Object visit(ASTVarNode node, Object data) {
        if (this.symTab == null) {
            String message = "Could not evaluate " + node.getName() + ": the symbol table is null";
            this.addToErrorList(message);
            return data;
        }
        Object temp = this.symTab.get(node.getName());
        if (temp == null) {
            String message = "Could not evaluate " + node.getName() + ": the variable was not found in the symbol table";
            this.addToErrorList(message);
        } else {
            this.stack.push(temp);
        }
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }

    public void clearStack() {
        this.stack.clear();
    }

    public Stack getStack() {
        return this.stack;
    }
}

