/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Add
extends PostfixMathCommand {
    public Add() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object sum = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            if (sum instanceof TypeObject) {
                sum = ((TypeObject)sum).getMathValueTyped();
            }
            sum = this.add(param, sum);
        }
        stack.push(sum);
    }

    public Object add(Object param1, Object sum) throws ParseException {
        if (param1 == NULL._null && sum == NULL._null) {
            return NULL._null;
        }
        if (param1 == null && sum == null) {
            return NULL._null;
        }
        if (param1 == NULL._null || param1 == null) {
            return sum;
        }
        if (sum == NULL._null || sum == null) {
            return param1;
        }
        if (param1 instanceof Number) {
            if (sum instanceof Number) {
                return this.add((Number)param1, (Number)sum);
            }
            if (sum instanceof Complex) {
                return this.add((Complex)sum, (Number)param1);
            }
        } else {
            if (param1 instanceof String && sum instanceof String) {
                return (String)param1 + (String)sum;
            }
            if (param1 instanceof TypeObject) {
                return this.add(((TypeObject)param1).getMathValueTyped(), sum);
            }
            if (param1 instanceof Complex) {
                if (sum instanceof Number) {
                    return this.add((Complex)param1, (Number)sum);
                }
                if (sum instanceof Complex) {
                    return this.add((Complex)param1, (Complex)sum);
                }
            } else if (param1 instanceof List) {
                if (sum instanceof List) {
                    ArrayList paramAdded = new ArrayList((List)param1);
                    for (int p2 = 0; p2 < ((List)sum).size(); ++p2) {
                        paramAdded.add(((List)sum).get(p2));
                    }
                    return paramAdded;
                }
                return param1;
            }
        }
        if (param1 != null && sum != null) {
            return param1.toString() + sum.toString();
        }
        throw new ParseException("Invalid parameter type: " + param1 + " Add " + sum);
    }

    public Object add(Number d1, Number d2) {
        if (d1 instanceof Integer && d2 instanceof Integer) {
            return new Integer(d1.intValue() + d2.intValue());
        }
        return new Double(d1.doubleValue() + d2.doubleValue());
    }

    public Complex add(Complex c1, Complex c2) {
        return new Complex(c1.re() + c2.re(), c1.im() + c2.im());
    }

    public Complex add(Complex c, Number d) {
        return new Complex(c.re() + d.doubleValue(), c.im());
    }
}

