/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object product = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            product = this.mul(product, param);
        }
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 == NULL._null) {
            param1 = new Integer(0);
        }
        if (param2 == NULL._null) {
            param2 = new Integer(0);
        }
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.mul((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Complex)param2, (Number)param1);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Number)param1);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.mul((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Complex)param1);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Number) {
                return this.mul((Vector)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Vector)param1, (Complex)param2);
            }
        } else if (param1 instanceof TypeObject && param2 instanceof TypeObject) {
            return this.mul(((TypeObject)param1).getMathValueTyped(), ((TypeObject)param2).getMathValueTyped());
        }
        throw new ParseException("Invalid parameter type:" + param1 + " Multiply " + param2);
    }

    public Double mul(Number d1, Number d2) {
        return new Double(d1.doubleValue() * d2.doubleValue());
    }

    public Complex mul(Complex c1, Complex c2) {
        return c1.mul(c2);
    }

    public Complex mul(Complex c, Number d) {
        return c.mul(d.doubleValue());
    }

    public Vector mul(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.mul((Number)v.elementAt(i), d));
        }
        return result;
    }

    public Vector mul(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.mul(c, (Number)v.elementAt(i)));
        }
        return result;
    }
}

