/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.misc;

import org.antlr.works.ate.syntax.misc.ATEScope;

public class ATEToken
implements Comparable {
    public int type;
    public int startLineNumber;
    public int endLineNumber;
    public int startLineIndex;
    public int endLineIndex;
    protected String text;
    public int start;
    public int end;
    protected String attribute;
    public int index;
    public boolean modified;
    public ATEScope scope;

    public ATEToken(int type, int start, int end, int startLineNumber, int endLineNumber, int startLineIndex, int endLineIndex, String text) {
        this.type = type;
        this.start = start;
        this.end = end;
        this.startLineNumber = startLineNumber;
        this.endLineNumber = endLineNumber;
        this.startLineIndex = startLineIndex;
        this.endLineIndex = endLineIndex;
        this.text = text;
        this.attribute = text.substring(start, end);
    }

    public String getText() {
        return this.text;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public int getStartLineIndex() {
        return this.startLineIndex;
    }

    public int getStartIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public boolean containsIndex(int index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject instanceof ATEToken) {
            ATEToken otherToken = (ATEToken)otherObject;
            return this.type == otherToken.type && this.start == otherToken.start && this.end == otherToken.end;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof ATEToken) {
            ATEToken otherToken = (ATEToken)o;
            return this.getAttribute().compareTo(otherToken.getAttribute());
        }
        return 1;
    }

    public String toString() {
        return this.getAttribute() + " <type=" + this.type + ", start=" + this.start + ", end=" + this.end + ">";
    }

    public static boolean isLexerName(String name) {
        if (name == null || name.length() < 1) {
            return false;
        }
        return name.charAt(0) == name.toUpperCase().charAt(0);
    }
}

