/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.idea;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.antlr.works.editor.idea.IdeaAction;
import org.antlr.works.editor.idea.IdeaManagerDelegate;
import org.antlr.works.editor.idea.IdeaOverlay;
import org.antlr.works.editor.idea.IdeaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaManager {
    protected List<IdeaProvider> providers = new ArrayList<IdeaProvider>();
    protected Timer timer = new Timer(1000, new TimerActionListener());
    protected IdeaOverlay overlay;
    protected IdeaManagerDelegate delegate;
    protected boolean enabled = true;
    protected int lastPosition;

    public IdeaManager() {
        this.timer.setRepeats(false);
    }

    public void setDelegate(IdeaManagerDelegate delegate) {
        this.delegate = delegate;
    }

    public void setOverlay(IdeaOverlay overlay) {
        this.overlay = overlay;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!this.enabled) {
            this.hide();
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void addProvider(IdeaProvider provider) {
        this.providers.add(provider);
    }

    public void close() {
        this.overlay.close();
        this.timer.stop();
    }

    public void hide() {
        this.timer.stop();
        this.overlay.hide();
    }

    public void displayAnyIdeasAvailable(int position) {
        if (!this.enabled) {
            return;
        }
        List<IdeaAction> ideas = this.generateIdeaActions(position);
        if (ideas == null || ideas.isEmpty()) {
            this.overlay.hide();
        } else {
            this.lastPosition = position;
            this.overlay.setIdeas(ideas);
            this.timer.restart();
        }
    }

    public List<IdeaAction> generateIdeaActions(int position) {
        ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
        for (IdeaProvider provider : this.providers) {
            List<IdeaAction> pactions = provider.ideaProviderGetActions(position);
            if (pactions == null || pactions.isEmpty()) continue;
            actions.addAll(pactions);
        }
        return actions;
    }

    protected class TimerActionListener
    implements ActionListener {
        protected TimerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            List<IdeaAction> ideas = IdeaManager.this.generateIdeaActions(IdeaManager.this.lastPosition);
            if (ideas.size() == 0) {
                return;
            }
            IdeaManager.this.overlay.setIdeas(ideas);
            if (IdeaManager.this.delegate != null && !IdeaManager.this.delegate.ideaManagerWillDisplayIdea()) {
                return;
            }
            IdeaManager.this.overlay.display();
        }
    }
}

