/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.tool.Grammar;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementGrammarName;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.engine.GrammarProperties;
import org.antlr.works.grammar.syntax.GrammarSyntaxEngine;
import org.antlr.works.grammar.syntax.GrammarSyntaxLexer;
import org.antlr.works.grammar.syntax.GrammarSyntaxParser;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarPropertiesImpl
implements GrammarProperties {
    private ElementGrammarName name;
    private final List<ElementRule> rules = new ArrayList<ElementRule>();
    private final List<ElementGroup> groups = new ArrayList<ElementGroup>();
    private final List<ElementBlock> blocks = new ArrayList<ElementBlock>();
    private final List<ElementAction> actions = new ArrayList<ElementAction>();
    private final List<ElementReference> references = new ArrayList<ElementReference>();
    private final List<ElementImport> imports = new ArrayList<ElementImport>();
    private final List<ATEToken> decls = new ArrayList<ATEToken>();
    private final List<ElementRule> duplicateRules = new ArrayList<ElementRule>();
    private final List<ElementReference> undefinedReferences = new ArrayList<ElementReference>();
    private final Set<String> tokenVocabNames = new HashSet<String>();
    private String tokenVocabName;
    private GrammarEngine engine;
    private GrammarSyntaxEngine syntaxEngine;
    private ANTLRGrammarEngine antlrEngine;

    @Override
    public void setGrammarEngine(GrammarEngine engine) {
        this.engine = engine;
    }

    @Override
    public void setSyntaxEngine(GrammarSyntaxEngine syntaxEngine) {
        this.syntaxEngine = syntaxEngine;
    }

    @Override
    public void setAntlrEngine(ANTLRGrammarEngine antlrEngine) {
        this.antlrEngine = antlrEngine;
    }

    @Override
    public List<ElementRule> getRules() {
        return this.rules;
    }

    @Override
    public ElementRule getRuleWithName(String name) {
        List<ElementRule> rules = this.getRules();
        for (ElementRule r : rules) {
            if (!r.name.equals(name)) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<ElementGroup> getGroups() {
        return this.groups;
    }

    @Override
    public List<ElementBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public List<ElementAction> getActions() {
        return this.actions;
    }

    @Override
    public List<ElementReference> getReferences() {
        return this.references;
    }

    @Override
    public List<ElementImport> getImports() {
        return this.imports;
    }

    @Override
    public List<ATEToken> getDecls() {
        return this.decls;
    }

    @Override
    public ElementGrammarName getElementName() {
        return this.name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getName();
    }

    @Override
    public int getType() {
        if (this.name == null) {
            return -1;
        }
        return this.name.getType();
    }

    @Override
    public boolean isParserGrammar() {
        return this.getType() == 1;
    }

    @Override
    public boolean isLexerGrammar() {
        return this.getType() == 2;
    }

    @Override
    public boolean isCombinedGrammar() {
        return this.getType() == 0;
    }

    @Override
    public boolean isTreeParserGrammar() {
        return this.getType() == 3;
    }

    private List<String> getDeclaredTokenNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.blocks != null) {
            for (ElementBlock block : this.blocks) {
                if (!block.isTokenBlock) continue;
                names.addAll(block.getDeclaredTokensAsString());
            }
        }
        return names;
    }

    private List<String> getPredefinedReferences() {
        return GrammarSyntaxParser.predefinedReferences;
    }

    @Override
    public synchronized String getTokenVocab() {
        if (this.blocks == null) {
            return null;
        }
        for (ElementBlock block : this.blocks) {
            if (!block.isOptionsBlock) continue;
            return block.getTokenVocab();
        }
        return null;
    }

    @Override
    public synchronized List<String> getRuleNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.rules != null) {
            for (ElementRule rule : this.rules) {
                names.add(rule.name);
            }
        }
        return names;
    }

    @Override
    public synchronized ElementRule getRuleAtIndex(int index) {
        if (index < 0 || index >= this.rules.size()) {
            return null;
        }
        return this.rules.get(index);
    }

    @Override
    public int getNumberOfRulesWithErrors() {
        int count = 0;
        if (this.getRules() != null) {
            for (ElementRule rule : this.getRules()) {
                if (!rule.hasErrors()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int getNumberOfErrors() {
        int count = 0;
        if (this.getRules() != null) {
            for (ElementRule rule : this.getRules()) {
                if (!rule.hasErrors()) continue;
                count += rule.getErrors().size();
            }
        }
        return count;
    }

    @Override
    public List<ElementRule> getDuplicateRules() {
        return new ArrayList<ElementRule>(this.duplicateRules);
    }

    @Override
    public List<ElementReference> getUndefinedReferences() {
        return new ArrayList<ElementReference>(this.undefinedReferences);
    }

    @Override
    public void reset() {
        this.resetTokenVocab();
    }

    private void resetTokenVocab() {
        this.tokenVocabName = null;
        this.tokenVocabNames.clear();
    }

    private Set<String> getTokenVocabNames() {
        String tokenVocab = this.getTokenVocab();
        if (tokenVocab == null) {
            this.tokenVocabName = null;
            this.tokenVocabNames.clear();
            return this.tokenVocabNames;
        }
        if (this.tokenVocabName != null && this.tokenVocabName.equals(tokenVocab)) {
            return this.tokenVocabNames;
        }
        this.tokenVocabName = tokenVocab;
        this.tokenVocabNames.clear();
        try {
            String file = this.engine.getTokenVocabFile(this.tokenVocabName + ".tokens");
            if (file != null) {
                GrammarPropertiesImpl.readTokenVocabFromFile(file, this.tokenVocabNames);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.tokenVocabNames;
    }

    public static boolean readTokenVocabFromFile(String filePath, Set<String> tokenNames) throws IOException {
        List<ATEToken> tokens = GrammarPropertiesImpl.parsePropertiesString(XJUtils.getStringFromFile(filePath));
        for (ATEToken t : tokens) {
            tokenNames.add(t.getAttribute());
        }
        return true;
    }

    private static List<ATEToken> parsePropertiesString(String content) {
        GrammarSyntaxLexer lexer = new GrammarSyntaxLexer();
        lexer.tokenize(content);
        class ParseProperties
        extends ATESyntaxParser {
            public List<ATEToken> propertiesTokens;

            ParseProperties() {
            }

            public void parseTokens() {
                this.propertiesTokens = new ArrayList<ATEToken>();
                while (this.nextToken()) {
                    if (this.T((int)0).type != 5 || !this.isChar(1, "=") && !this.isChar(1, "\n")) continue;
                    this.propertiesTokens.add(this.T(0));
                }
            }
        }
        ParseProperties parser = new ParseProperties();
        parser.parse(lexer.getTokens());
        return parser.propertiesTokens;
    }

    private void rebuildHasLeftRecursionRulesList() {
        if (this.getRules() == null) {
            return;
        }
        for (ElementRule r : this.getRules()) {
            r.hasLeftRecursion();
        }
    }

    private void rebuildDuplicateRulesList() {
        List<ElementRule> rules = this.getRules();
        if (rules == null) {
            return;
        }
        ArrayList<ElementRule> sortedRules = Collections.list(Collections.enumeration(rules));
        Collections.sort(sortedRules);
        Iterator iter = sortedRules.iterator();
        ElementRule currentRule = null;
        this.duplicateRules.clear();
        while (iter.hasNext()) {
            ElementRule nextRule = (ElementRule)iter.next();
            if (currentRule != null && currentRule.name.equals(nextRule.name) && !this.duplicateRules.contains(currentRule)) {
                this.duplicateRules.add(currentRule);
                this.duplicateRules.add(nextRule);
            }
            currentRule = nextRule;
        }
    }

    private void rebuildUndefinedReferencesList() {
        List<String> existingReferences = this.getRuleNames();
        existingReferences.addAll(this.getDeclaredTokenNames());
        existingReferences.addAll(this.getPredefinedReferences());
        Set<String> tokenVocabNames = this.getTokenVocabNames();
        existingReferences.addAll(tokenVocabNames);
        this.syntaxEngine.resolveReferencesWithExternalNames(tokenVocabNames);
        this.undefinedReferences.clear();
        List<ElementReference> references = this.getReferences();
        if (references == null) {
            return;
        }
        for (ElementReference ref : references) {
            if (existingReferences.contains(ref.token.getAttribute()) || !this.engine.getGrammarsOverriddenByRule(ref.token.getAttribute()).isEmpty() || !this.engine.getRootEngine().getGrammarsOverriddenByRule(ref.token.getAttribute()).isEmpty()) continue;
            this.undefinedReferences.add(ref);
        }
    }

    @Override
    public void updateAll() {
        this.rebuildDuplicateRulesList();
        this.rebuildUndefinedReferencesList();
        this.rebuildHasLeftRecursionRulesList();
    }

    @Override
    public void parserCompleted() {
        this.update((GrammarSyntaxParser)this.syntaxEngine.getParser());
        this.resetTokenVocab();
    }

    private void update(GrammarSyntaxParser parser) {
        this.rules.clear();
        this.rules.addAll(parser.rules);
        this.groups.clear();
        this.groups.addAll(parser.groups);
        this.blocks.clear();
        this.blocks.addAll(parser.blocks);
        this.actions.clear();
        this.actions.addAll(parser.actions);
        this.references.clear();
        this.references.addAll(parser.references);
        this.imports.clear();
        this.imports.addAll(parser.imports);
        this.decls.clear();
        this.decls.addAll(parser.decls);
        this.name = parser.getName();
        for (ElementRule r : this.rules) {
            r.setEngine(this.engine);
        }
    }

    @Override
    public List<String> getAllGeneratedNames() throws Exception {
        Grammar lexer;
        ArrayList<String> names = new ArrayList<String>();
        Grammar g = this.antlrEngine.getDefaultGrammar();
        if (g != null) {
            names.add(g.getRecognizerName());
            for (Grammar gd : g.getDelegates()) {
                names.add(gd.getRecognizerName());
            }
        }
        if ((lexer = this.antlrEngine.getLexerGrammar()) != null) {
            names.add(lexer.getRecognizerName());
            for (Grammar gd : lexer.getDelegates()) {
                names.add(gd.getRecognizerName());
            }
        }
        return names;
    }

    @Override
    public int getFirstDeclarationPosition(String name) {
        ATEToken token = this.getFirstDeclaration(name);
        if (token != null) {
            return token.start;
        }
        return -1;
    }

    private ATEToken getFirstDeclaration(String name) {
        for (ATEToken decl : this.getDecls()) {
            if (!decl.getAttribute().equals(name)) continue;
            return decl;
        }
        return null;
    }
}

