/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Stack;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.skin.Skin;

public class GContext {
    public static final String EPSILON_WIDTH = "w";
    public static final String EPSILON_UP = "u";
    public static final String EPSILON_DOWN = "d";
    public static final String BOX_WIDTH = "W";
    public static final String BOX_UP = "U";
    public static final String BOX_DOWN = "D";
    public static final String NODE_WIDTH = "m";
    public static final String NODE_UP = "y";
    public static final String NODE_DOWN = "z";
    public static final String CHAR_WIDTH = "c";
    public static final String LINE_SPACE = "L";
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_CENTER_UP = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_LEFT = 3;
    public Container container;
    public GContextProvider provider;
    public GEngine engine;
    public Skin skin;
    protected float value_factor = 3.2f;
    public int offsetX = 0;
    public int offsetY = 0;
    public boolean drawnode = false;
    public boolean drawdimension = false;
    private boolean showRuleName = true;
    public final Stack<Color> colorStack = new Stack();
    public Color nodeColor = Color.black;
    public Color linkColor = Color.black;
    public Font boxFont = null;
    public Font titleFont = null;
    public Graphics2D g2d = null;

    public void setProvider(GContextProvider provider) {
        this.provider = provider;
    }

    public void clearCache() {
        this.boxFont = null;
        this.titleFont = null;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setEngine(GEngine engine) {
        this.engine = engine;
        this.engine.setContext(this);
    }

    public void setGraphics2D(Graphics2D g2d) {
        this.g2d = g2d;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public float getStartOffset() {
        return this.skin.getStartOffset(this);
    }

    public float getEndOffset() {
        return this.skin.getEndOffset(this);
    }

    public void setFactor(float factor) {
        this.value_factor = factor;
        this.clearCache();
    }

    public float getFactor() {
        return this.value_factor;
    }

    public boolean isShowRuleName() {
        return this.showRuleName;
    }

    public void setShowRuleName(boolean showRuleName) {
        this.showRuleName = showRuleName;
    }

    public float getPixelEpsilonUp() {
        return this.getPixelValue(EPSILON_UP);
    }

    public float getPixelEpsilonDown() {
        return this.getPixelValue(EPSILON_DOWN);
    }

    public float getPixelBoxWidth() {
        return this.getPixelValue(BOX_WIDTH);
    }

    public float getPixelBoxUp() {
        return this.getPixelValue(BOX_UP);
    }

    public float getPixelBoxDown() {
        return this.getPixelValue(BOX_DOWN);
    }

    public float getPixelBoxEdge() {
        return this.getPixelBoxWidth() / 6.0f;
    }

    public float getPixelLineSpace() {
        return this.getPixelValue(LINE_SPACE);
    }

    public float getPixelNodeWidth() {
        return this.getPixelValue(NODE_WIDTH);
    }

    public float getPixelArrowWidth() {
        return this.getPixelBoxWidth() / 8.0f;
    }

    public float getPixelArrowHeight() {
        return (this.getPixelBoxUp() + this.getPixelBoxDown()) / 10.0f;
    }

    public Font getBoxFont() {
        if (this.boxFont == null) {
            this.boxFont = new Font("Monospaced", 1, (int)(4.0f * this.value_factor));
        }
        return this.boxFont;
    }

    public Font getRuleFont() {
        if (this.titleFont == null) {
            this.titleFont = new Font("Monospaced", 1, (int)(4.0f * this.value_factor));
        }
        return this.titleFont;
    }

    public static String getStringWidth(String label) {
        StringBuilder w = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            w.append(CHAR_WIDTH);
        }
        return GLiteral.max(w.toString(), BOX_WIDTH);
    }

    public static String getBoxWidth(String label) {
        StringBuilder w = new StringBuilder();
        for (int i = 0; i < label.length() + 2; ++i) {
            w.append(CHAR_WIDTH);
        }
        return GLiteral.max(w.toString(), BOX_WIDTH);
    }

    public float getPixelValue(String s) {
        if (s == null || s.length() == 0) {
            return 0.0f;
        }
        return GLiteral.evaluate(s, this.skin.getValuesMap()) * this.value_factor;
    }

    public void setColor(Color color) {
        this.engine.setColor(color);
    }

    public void pushColor(Color color) {
        this.colorStack.push(this.engine.getColor());
        this.setColor(color);
    }

    public void popColor() {
        this.setColor(this.colorStack.pop());
    }

    public Color getColorForLabel(String label) {
        if (this.provider == null) {
            return Color.black;
        }
        return this.provider.contextGetColorForLabel(label);
    }

    public void setLineWidth(float width) {
        this.engine.setLineWidth(width);
    }

    public void repaint() {
        this.container.repaint();
    }

    public void drawLine(float x0, float y0, float x1, float y1) {
        this.engine.drawLine(x0 + (float)this.offsetX, y0 + (float)this.offsetY, x1 + (float)this.offsetX, y1 + (float)this.offsetY);
    }

    public void drawArc(float x, float y, float w, float h, int a0, int a1) {
        this.engine.drawArc(x + (float)this.offsetX, y + (float)this.offsetY, w, h, a0, a1);
    }

    public void drawCircle(float x, float y, float r, boolean erase) {
        if (erase) {
            this.pushColor(Color.white);
            this.fillCircle(x, y, r);
            this.popColor();
        }
        this.engine.drawCircle(x + (float)this.offsetX, y + (float)this.offsetY, r);
    }

    public void drawRect(float x, float y, float dx, float dy, boolean erase) {
        if (erase) {
            this.pushColor(Color.white);
            this.fillRect(x, y, dx, dy);
            this.popColor();
        }
        this.engine.drawRect(x + (float)this.offsetX, y + (float)this.offsetY, dx, dy);
    }

    public void drawRoundRect(float x, float y, float dx, float dy, float arc_dx, float arc_dy, boolean erase) {
        if (erase) {
            this.pushColor(Color.white);
            this.fillRect(x, y, dx, dy);
            this.popColor();
        }
        this.engine.drawRoundRect(x + (float)this.offsetX, y + (float)this.offsetY, dx, dy, arc_dx, arc_dy);
    }

    public void drawOval(float x, float y, float dx, float dy, boolean erase) {
        if (erase) {
            this.pushColor(Color.white);
            this.fillOval(x, y, dx, dy);
            this.popColor();
        }
        this.engine.drawOval(x + (float)this.offsetX, y + (float)this.offsetY, dx, dy);
    }

    public void fillRect(float x, float y, float dx, float dy) {
        this.engine.fillRect(x + (float)this.offsetX, y + (float)this.offsetY, dx, dy);
    }

    public void fillOval(float x, float y, float dx, float dy) {
        this.engine.fillOval(x + (float)this.offsetX, y + (float)this.offsetY, dx, dy);
    }

    public void fillCircle(float x, float y, float r) {
        this.engine.fillCircle(x + (float)this.offsetX, y + (float)this.offsetY, r);
    }

    public void drawRightArrow(float ox, float oy, float w, float h) {
        this.engine.drawRightArrow(ox + (float)this.offsetX, oy + (float)this.offsetY, w, h);
    }

    public void drawUpArrow(float ox, float oy, float w, float h) {
        this.engine.drawUpArrow(ox + (float)this.offsetX, oy + (float)this.offsetY, w, h);
    }

    public void drawDownArrow(float ox, float oy, float w, float h) {
        this.engine.drawDownArrow(ox + (float)this.offsetX, oy + (float)this.offsetY, w, h);
    }

    public void drawString(Font font, String s, float x, float y, int align) {
        this.engine.drawString(font, s, x + (float)this.offsetX, y + (float)this.offsetY, align);
    }

    public void drawSpline(float x0, float y0, float x1, float y1, float startOffset, float endOffset, float flateness, boolean arrow) {
        this.engine.drawSpline(x0 + (float)this.offsetX, y0 + (float)this.offsetY, x1 + (float)this.offsetX, y1 + (float)this.offsetY, startOffset, endOffset, flateness, arrow);
    }

    public void drawArcConnector(float x0, float y0, float x1, float y1, float start_offset, float end_offset, float ctrl_offset, float arc_offset, boolean arrow) {
        this.engine.drawArcConnector(x0 + (float)this.offsetX, y0 + (float)this.offsetY, x1 + (float)this.offsetX, y1 + (float)this.offsetY, start_offset, end_offset, ctrl_offset, arc_offset, arrow);
    }

    public void drawNode(GNode node) {
        this.skin.drawNode(node);
    }

    public void drawLink(GLink link) {
        this.skin.drawLink(link);
    }

    public boolean isObjectVisible(GObject object) {
        if (object instanceof GNode) {
            return this.skin.isNodeVisible();
        }
        if (object instanceof GLink) {
            return this.skin.isLinkVisible();
        }
        return false;
    }

    public boolean objectContainsPoint(GObject object, Point p) {
        if (!this.isObjectVisible(object)) {
            return false;
        }
        return this.skin.objectContainsPoint(object, new Point(p.x - this.offsetX, p.y - this.offsetY));
    }
}

