/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPathElement
extends GObject {
    public GObject nodeOrLink;
    public GObject source;
    public GNode target;
    public boolean isRuleLink = false;

    public static GPathElement createLink(GNode node, GNode nextNode) {
        GPathElement element = new GPathElement(node, nextNode);
        element.setRuleLink(true);
        return element;
    }

    public static GPathElement createElement(GObject object) {
        return new GPathElement(object);
    }

    public GPathElement(GObject object) {
        this.nodeOrLink = object;
    }

    public GPathElement(GObject source, GNode target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void setContext(GContext context) {
        super.setContext(context);
        if (this.nodeOrLink != null) {
            this.nodeOrLink.setContext(context);
        }
        if (this.source != null) {
            this.source.setContext(context);
        }
        if (this.target != null) {
            this.target.setContext(context);
        }
    }

    @Override
    public boolean containsPoint(Point p) {
        if (this.nodeOrLink != null) {
            return this.nodeOrLink.containsPoint(p);
        }
        return false;
    }

    public void setRuleLink(boolean flag) {
        this.isRuleLink = flag;
    }

    public boolean isVisible() {
        if (this.nodeOrLink != null) {
            return this.context.isObjectVisible(this.nodeOrLink);
        }
        return true;
    }

    public Set<GObject> getObjects() {
        HashSet<GObject> objects = new HashSet<GObject>();
        if (this.nodeOrLink != null) {
            objects.add(this.nodeOrLink);
        }
        if (this.source != null) {
            objects.add(this.source);
        }
        if (this.target != null) {
            objects.add(this.target);
        }
        return objects;
    }

    protected Point2D getBeginPoint() {
        float y0;
        float x0;
        if (this.source instanceof GNode) {
            GNode node = (GNode)this.source;
            x0 = node.getCenterX();
            y0 = node.getCenterY();
        } else {
            GLink link = (GLink)this.source;
            x0 = link.target.getBeginX();
            y0 = link.target.getBeginY();
        }
        return new Point2D.Float(x0, y0);
    }

    @Override
    public Rectangle getBounds() {
        if (this.nodeOrLink != null) {
            return this.nodeOrLink.getBounds();
        }
        Point2D a = this.getBeginPoint();
        int x1 = (int)a.getX();
        int y1 = (int)a.getY();
        int x2 = (int)this.target.getCenterX();
        int y2 = (int)this.target.getCenterY();
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void draw() {
        if (this.nodeOrLink != null) {
            this.nodeOrLink.draw();
        }
        if (this.source != null && this.target != null) {
            Point2D p = this.getBeginPoint();
            this.context.setColor(this.context.linkColor);
            this.context.drawSpline((float)p.getX(), (float)p.getY(), this.target.getCenterX(), this.target.getCenterY(), 0.0f, this.context.getEndOffset(), 0.0f, true);
        }
    }
}

