/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.primitive;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLiteral {
    public static final String OP_SUB = "-";
    public static final String OP_MAX = "#";
    public static final String OP_LPAREN = "(";
    public static final String OP_RPAREN = ")";
    public static final String OP_COMA = ",";
    public static final String OP_NULL = "!";

    public static String substract(String a, String b) {
        return a + OP_SUB + OP_LPAREN + b + OP_RPAREN;
    }

    public static String add(String a, String b) {
        return a + b;
    }

    public static String max(String a, String b) {
        boolean bnull;
        boolean anull = a == null || a.length() == 0;
        boolean bl = bnull = b == null || b.length() == 0;
        if (anull && bnull) {
            return "";
        }
        if (anull) {
            return b;
        }
        if (bnull) {
            return a;
        }
        return "#(" + a + OP_COMA + b + OP_RPAREN;
    }

    public static float evaluate(String s, Map<String, Float> values) {
        if (s == null) {
            return 0.0f;
        }
        return new Evaluator(s, values).evaluate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Evaluator {
        public String s;
        public Map<String, Float> values;
        public int position;

        public Evaluator(String s, Map<String, Float> values) {
            this.s = s;
            this.values = values;
        }

        public float evaluate() {
            this.position = 0;
            return this.eval();
        }

        private float eval() {
            float _value = 0.0f;
            do {
                Float v;
                if ((v = this.values.get(this.c())) != null) {
                    _value += v.floatValue();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_SUB)) {
                    _value -= this.evaluate_sub();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_MAX)) {
                    _value += this.evaluate_max();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_RPAREN) || this.c().equals(GLiteral.OP_COMA)) break;
                System.err.println("** Evaluator: unexpected token \"" + this.c() + "\"");
            } while (this.nextChar());
            return _value;
        }

        private float evaluate_sub() {
            this.match(GLiteral.OP_SUB);
            this.match(GLiteral.OP_LPAREN);
            return this.eval();
        }

        private float evaluate_max() {
            this.match(GLiteral.OP_MAX);
            this.match(GLiteral.OP_LPAREN);
            float a = this.eval();
            this.match(GLiteral.OP_COMA);
            float b = this.eval();
            return Math.max(a, b);
        }

        private boolean nextChar() {
            ++this.position;
            return this.position < this.s.length();
        }

        private void match(String token) {
            if (this.c().equals(token)) {
                this.nextChar();
            } else {
                System.err.println("** Evaluator: unexpected token \"" + this.c() + "\"");
            }
        }

        private String c() {
            return this.s.substring(this.position, this.position + 1);
        }
    }
}

