/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class Vector2D
implements XJXMLSerializable {
    public double x = 0.0;
    public double y = 0.0;

    public static Vector2D vector(Point p) {
        return new Vector2D(p.x, p.y);
    }

    public static Vector2D vector(Point2D p) {
        return new Vector2D(p.getX(), p.getY());
    }

    public Vector2D() {
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D setLength(double l) {
        double ol = this.length();
        if (ol == 0.0) {
            this.x = 0.0;
            this.y = 0.0;
        } else {
            this.x = this.x / ol * l;
            this.y = this.y / ol * l;
        }
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D stretch(double f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2D shift(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Vector2D vectorLength(double l) {
        Vector2D v = this.copy();
        v.setLength(l);
        return v;
    }

    public Vector2D rotate(double degree) {
        if (Math.abs(degree) == 90.0) {
            double temp = this.x;
            this.x = this.y;
            this.y = temp;
            if (degree < 0.0) {
                this.y = -this.y;
            } else {
                this.x = -this.x;
            }
        } else {
            double angle = Math.toRadians(degree);
            double rx = Math.cos(angle) * this.x - Math.sin(angle) * this.y;
            double ry = Math.sin(angle) * this.x + Math.cos(angle) * this.y;
            this.x = rx;
            this.y = ry;
        }
        return this;
    }

    public Vector2D normalize() {
        double r = this.length();
        if (r == 0.0) {
            return new Vector2D();
        }
        return new Vector2D(this.x / r, this.y / r);
    }

    public Vector2D append(Vector2D v2) {
        this.setX(this.x + v2.x);
        this.setY(this.y + v2.y);
        return this;
    }

    public Vector2D add(Vector2D v2) {
        return new Vector2D(this.x + v2.x, this.y + v2.y);
    }

    public Vector2D sub(Vector2D v2) {
        return new Vector2D(this.x - v2.x, this.y - v2.y);
    }

    public double dot(Vector2D v2) {
        return this.x * v2.x + this.y * v2.y;
    }

    public double cross(Vector2D v2) {
        return this.x * v2.y - this.y * v2.x;
    }

    public int crossSign(Vector2D v2) {
        double cross = this.cross(v2);
        if (cross == 0.0) {
            return 0;
        }
        return cross < 0.0 ? -1 : 1;
    }

    public Point toPoint() {
        return new Point((int)this.x, (int)this.y);
    }

    public boolean equals(Object other) {
        if (other instanceof Vector2D) {
            Vector2D otherVector = (Vector2D)other;
            return otherVector.x == this.x && otherVector.y == this.y;
        }
        return false;
    }

    public String toString() {
        return "<Vector2D: " + this.x + ", " + this.y + " >";
    }

    public Vector2D copy() {
        return new Vector2D(this.x, this.y);
    }
}

