/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.foundation.XJSystem;

public class XJAlert {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static Icon icon;
    private boolean displayDoNotShowAgainButton = false;
    private JCheckBox doNotShowAgainButton;

    public static void disableEscapeKey() {
        Object[] mapping = new Object[]{"ESCAPE", "cancel"};
        UIManager.put("OptionPane.windowBindings", mapping);
    }

    public static void enableEscapeKey() {
        Object[] mapping = new Object[]{"ESCAPE", "close"};
        UIManager.put("OptionPane.windowBindings", mapping);
    }

    public static Component getParent(Component parent) {
        return parent == null ? XJApplication.getActiveContainer() : parent;
    }

    public static XJAlert createInstance() {
        return new XJAlert();
    }

    public static void display(Component parent, String title, String message) {
        XJAlert.createInstance().displayAlert(parent, title, message, 1, -1);
    }

    public static int displayAlertYESNO(Component parent, String title, String message) {
        return XJAlert.createInstance().displayAlert(parent, title, message, 3, 0);
    }

    public static int displayAlertYESNOCANCEL(Component parent, String title, String message) {
        return XJAlert.createInstance().displayAlert(parent, title, message, 3, 1);
    }

    public static int displayAlert(Component parent, String title, String message, String b1, String b2, int def, int cancel) {
        return XJAlert.createInstance().displayCustomAlert(parent, title, message, new String[]{b1, b2}, def, cancel);
    }

    public static int displayAlert(Component parent, String title, String message, String b1, String b2, String b3, int def, int cancel) {
        return XJAlert.createInstance().displayCustomAlert(parent, title, message, new String[]{b1, b2, b3}, def, cancel);
    }

    public void showSimple(Component parent, String title, String message) {
        this.displayAlert(parent, title, message, 1, -1);
    }

    public int showCustom(Component parent, String title, String message, String b1, String b2, int def, int cancel) {
        return this.displayCustomAlert(parent, title, message, new String[]{b1, b2}, def, cancel);
    }

    public static void setDefaultAlertIcon(Icon icon) {
        XJAlert.icon = icon;
    }

    public void setDisplayDoNotShowAgainButton(boolean displayDoNotShowAgainButton) {
        this.displayDoNotShowAgainButton = displayDoNotShowAgainButton;
    }

    public boolean isDoNotShowAgain() {
        return this.doNotShowAgainButton.isSelected();
    }

    public int displayCustomAlert(Component parent, String title, String message, String[] buttons, int def, int cancel) {
        if (XJSystem.isMacOS()) {
            String[] reverse = new String[buttons.length];
            for (int i = 0; i < buttons.length; ++i) {
                reverse[i] = buttons[buttons.length - i - 1];
            }
            buttons = reverse;
            def = buttons.length - def - 1;
            cancel = buttons.length - cancel - 1;
        }
        int result = this.displayAlert(parent, title, message, -1, 1, buttons, buttons[def], buttons[cancel]);
        if (XJSystem.isMacOS()) {
            return buttons.length - result - 1;
        }
        return result;
    }

    private int displayAlert(Component parent, String title, String message, int messageType, int optionType) {
        return this.displayAlert(parent, title, message, messageType, optionType, null, null, null);
    }

    private int displayAlert(Component parent, String title, String message, int messageType, int optionType, Object[] options, Object defaultValue, Object escapeValue) {
        AlertOptionPane pane = new AlertOptionPane(message, messageType, optionType);
        if (options != null) {
            pane.setOptions(options);
            pane.setInitialValue(defaultValue);
        }
        if (icon != null) {
            pane.setIcon(icon);
        }
        JDialog dialog = pane.createDialog(XJAlert.getParent(parent), title);
        if (this.displayDoNotShowAgainButton) {
            this.doNotShowAgainButton = new JCheckBox("Do not show this alert again");
            dialog.getContentPane().add((Component)this.doNotShowAgainButton, "South");
        }
        dialog.pack();
        dialog.setVisible(true);
        Object value = pane.getValue();
        if (value == null) {
            return 2;
        }
        if (options != null) {
            if (value instanceof Integer && (Integer)value == -1) {
                return Arrays.asList(options).indexOf(escapeValue);
            }
            return Arrays.asList(options).indexOf(value);
        }
        return (Integer)value;
    }

    private static class AlertOptionPane
    extends JOptionPane {
        public AlertOptionPane(Object o, int i, int i1) {
            super(o, i, i1);
        }

        public int getMaxCharactersPerLineCount() {
            return 100;
        }
    }
}

