/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.equiv;

import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.grammar.host.HostElement;
import groove.util.Fixable;
import java.util.Map;

public class EquivRelation<T extends HostElement>
extends MyHashSet<EquivClass<T>>
implements Fixable {
    private int hashCode = 0;
    private final Map<T, EquivClass<T>> elemMap = new MyHashMap<T, EquivClass<T>>();

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof EquivRelation)) {
            result = false;
        } else {
            EquivRelation other = (EquivRelation)o;
            if (this.size() != other.size()) {
                result = false;
            } else {
                boolean bl = result = this.containsAll(other) && other.containsAll(this);
            }
        }
        assert (!result || this.hashCode() == o.hashCode());
        return result;
    }

    @Override
    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            if (this.hashCode == 0) {
                this.hashCode = -1;
            }
        }
        return this.hashCode;
    }

    @Override
    public EquivRelation<T> clone() {
        EquivRelation result = new EquivRelation();
        for (EquivClass ec : this) {
            result.add(ec.clone());
        }
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.hashCode();
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.hashCode != 0;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean add(EquivClass<T> ec) {
        assert (!this.isFixed());
        ec.setFixed();
        for (HostElement elem : ec) {
            this.elemMap.put(elem, ec);
        }
        return super.add(ec);
    }

    @Override
    public boolean remove(Object obj) {
        assert (!this.isFixed());
        boolean contained = super.remove(obj);
        if (contained) {
            EquivClass ec = (EquivClass)obj;
            for (HostElement elem : ec) {
                this.elemMap.remove(elem);
            }
        }
        return contained;
    }

    private int computeHashCode() {
        int result = 0;
        for (EquivClass elem : this) {
            result += elem.hashCode();
        }
        return result * 31;
    }

    public EquivClass<T> getEquivClassOf(T elem) {
        return this.elemMap.get(elem);
    }

    public boolean areEquivalent(T elem0, T elem1) {
        EquivClass<T> ec1;
        EquivClass<T> ec0 = this.getEquivClassOf(elem0);
        return ec0 == (ec1 = this.getEquivClassOf(elem1));
    }
}

