/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.equiv;

import groove.abstraction.neigh.equiv.EquivClass;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public final class NodeEquivClass<T extends HostNode>
extends BitSet
implements EquivClass<T> {
    private boolean fixed;
    private int elemCount;
    private final HostFactory factory;

    public NodeEquivClass(HostFactory factory) {
        this.factory = factory;
        this.elemCount = 0;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.fixed = true;
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    @Override
    public NodeEquivClass<T> clone() {
        NodeEquivClass clone = (NodeEquivClass)super.clone();
        clone.fixed = false;
        return clone;
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        if (o instanceof HostElement) {
            int idx = ((HostElement)o).getNumber();
            result = this.get(idx);
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.elemCount];
        int i = 0;
        for (T obj : this) {
            result[i] = obj;
            ++i;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.elemCount) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.elemCount);
        }
        int i = 0;
        for (T obj : this) {
            a[i] = obj;
            ++i;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        for (Object obj : c) {
            if (!(result &= this.contains(obj))) break;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        assert (!this.isFixed());
        boolean changed = false;
        for (HostNode obj : c) {
            changed |= this.add((T)obj);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        assert (!this.isFixed());
        boolean changed = false;
        for (Object obj : c) {
            changed |= this.remove(obj);
        }
        return changed;
    }

    @Override
    public boolean add(T obj) {
        assert (!this.isFixed());
        int idx = obj.getNumber();
        if (!this.get(idx)) {
            this.set(idx);
            ++this.elemCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object obj) {
        assert (!this.isFixed());
        assert (obj instanceof HostElement);
        int idx = ((HostElement)obj).getNumber();
        if (this.get(idx)) {
            this.clear(idx);
            --this.elemCount;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elemCount;
    }

    @Override
    public boolean isSingleton() {
        return this.elemCount == 1;
    }

    private class MyIterator
    implements Iterator<T> {
        private int curr;

        private MyIterator() {
            this.curr = NodeEquivClass.this.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.curr >= 0;
        }

        @Override
        public T next() {
            HostNode elem = (HostNode)NodeEquivClass.this.factory.getNode(this.curr);
            this.curr = NodeEquivClass.this.nextSetBit(this.curr + 1);
            return elem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

