/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.explore;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.NeighAbstraction;
import groove.abstraction.neigh.lts.AGTS;
import groove.explore.AcceptorEnumerator;
import groove.explore.Exploration;
import groove.explore.GenerateProgressMonitor;
import groove.explore.Generator;
import groove.explore.StrategyEnumerator;
import groove.explore.StrategyValue;
import groove.explore.encode.Serialized;
import groove.explore.result.Acceptor;
import groove.explore.strategy.Strategy;
import groove.explore.util.ExplorationStatistics;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.graph.Graph;
import groove.graph.Node;
import groove.graph.plain.PlainGraph;
import groove.util.CommandLineOption;
import groove.util.CommandLineTool;
import groove.util.Groove;
import java.io.IOException;
import java.util.List;

public final class ShapeGenerator
extends CommandLineTool {
    private static final String USAGE_MESSAGE = "Usage: ShapeGenerator [options] <grammar> <start-graph-name>";
    private static AGTS gts;
    private String grammarLocation;
    private String startGraphName;
    private Grammar grammar;
    private Exploration exploration;
    private ExplorationStatistics explorationStats;
    private boolean isPrintStats;
    private boolean isReachability;
    private final Generator.TemplatedOption<Strategy> strategyOption = new Generator.TemplatedOption<Strategy>("s", "str", StrategyEnumerator.newInstance(StrategyValue.ABSTRACT_STRATEGIES));
    private final Generator.TemplatedOption<Acceptor> acceptorOption = new Generator.TemplatedOption<Acceptor>("a", "acc", AcceptorEnumerator.newInstance());
    private final Generator.ResultOption resultOption = new Generator.ResultOption();
    private AGTS reducedGTS;

    public ShapeGenerator(String ... args) {
        super(args);
        this.addOption(this.strategyOption);
        this.addOption(this.acceptorOption);
        this.addOption(this.resultOption);
        this.addOption(new MultiplicityBoundOption(Multiplicity.MultKind.NODE_MULT));
        this.addOption(new MultiplicityBoundOption(Multiplicity.MultKind.EDGE_MULT));
        this.addOption(new StatsOption());
        this.addOption(new ThreeMultValOption());
        this.addOption(new ReachabilityOption());
    }

    @Override
    protected String getUsageMessage() {
        return USAGE_MESSAGE;
    }

    @Override
    public void processArguments() {
        super.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            this.setGrammarLocation(argsList.remove(0));
        }
        if (argsList.size() > 0) {
            this.setStartGraph(argsList.remove(0));
        }
        if (this.grammarLocation == null) {
            this.printError("No grammar location specified", true);
        }
        Serialized strategy = this.isOptionActive(this.strategyOption) ? (Serialized)this.strategyOption.getValue() : new Serialized("shapedfs");
        Serialized acceptor = null;
        acceptor = this.isOptionActive(this.acceptorOption) ? (Serialized)this.acceptorOption.getValue() : new Serialized("final");
        int nrResults = this.isOptionActive(this.resultOption) ? (Integer)this.resultOption.getValue() : 0;
        this.exploration = new Exploration(strategy, acceptor, nrResults);
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    private void setGrammarLocation(String grammarLocation) {
        this.grammarLocation = grammarLocation;
    }

    private void setStartGraph(String startGraphName) {
        this.startGraphName = startGraphName;
    }

    private void reset() {
        NeighAbstraction.initialise();
        gts = null;
        this.reducedGTS = null;
        this.explorationStats = new ExplorationStatistics(this.getGTS());
        this.explorationStats.configureForGenerator(this.getVerbosity());
    }

    public AGTS getGTS() {
        if (gts == null) {
            gts = new AGTS(this.getGrammar(), this.isReachability);
        }
        return gts;
    }

    public void start() {
        this.processArguments();
        this.explore();
        this.report();
    }

    public void explore() {
        this.reset();
        if (this.getVerbosity() > 0) {
            this.println("\n======================================================\n");
            this.println("Grammar:\t" + this.grammarLocation);
            this.println("Start graph:\t" + (this.startGraphName == null ? "default" : this.startGraphName));
            this.println("Exploration:\t" + this.exploration.getIdentifier());
            NeighAbsParam params = NeighAbsParam.getInstance();
            this.print("Node bound:\t" + params.getNodeMultBound() + "\tEdge bound:\t" + params.getEdgeMultBound());
            if (params.isUseThreeValues()) {
                this.println("\tLIMITING MULTIPLICITIES TO 0, 1 and 0+");
            } else {
                this.println();
            }
            if (this.isReachability) {
                this.println("Reachability mode ON.");
            }
            this.println("Timestamp:\t" + this.invocationTime);
            this.print("\nProgress:\n\n");
            this.getGTS().addLTSListener(new GenerateProgressMonitor());
        }
        this.explorationStats.start();
        try {
            this.exploration.play(this.getGTS(), null);
            if (this.exploration.isInterrupted()) {
                new Exception().printStackTrace();
            }
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        this.explorationStats.stop();
    }

    private Grammar getGrammar() {
        if (this.grammar == null) {
            this.loadGrammar(this.grammarLocation, this.startGraphName);
        }
        return this.grammar;
    }

    private void loadGrammar(String grammarFile, String startGraph) {
        try {
            GrammarModel model = Groove.loadGrammar(grammarFile);
            model.setLocalActiveNames(ResourceKind.HOST, startGraph);
            this.grammar = model.toGrammar();
            this.grammar.setFixed();
        }
        catch (FormatException exc) {
            this.printError("Grammar format error: " + exc.getMessage(), false);
        }
        catch (IOException exc) {
            this.printError("I/O error while loading grammar: " + exc.getMessage(), false);
        }
        this.checkGrammarForAbstraction();
    }

    private void checkGrammarForAbstraction() {
        if (!this.grammar.getProperties().isInjective()) {
            this.printError("Grammar is not injective! Abstraction can only work with injective rules...", false);
        }
        for (Node node : this.grammar.getStartGraph().nodeSet()) {
            if (!(node instanceof ValueNode)) continue;
            this.printError("Grammar start graph has attributes! Abstraction cannot handle attributes...", false);
        }
        for (Rule rule : this.grammar.getAllRules()) {
            for (RuleNode node : rule.lhs().nodeSet()) {
                if (!(node instanceof OperatorNode) && !(node instanceof VariableNode)) continue;
                this.printError("Grammar rules operate on attributes! Abstraction cannot handle attributes...", false);
            }
            for (RuleEdge edge : rule.lhs().edgeSet()) {
                if (((RuleLabel)edge.label()).isAtom()) continue;
                this.printError("Grammar rules have regular expressions that the abstraction cannot handle!", false);
            }
        }
    }

    private void setPrintStats() {
        this.isPrintStats = true;
    }

    private void setReachability() {
        this.isReachability = true;
    }

    public void report() {
        String report;
        this.reportGTS(this.getGTS(), "Original GTS");
        AGTS reducedGTS = this.getReducedGTS();
        this.reportGTS(reducedGTS, "Reduced GTS");
        this.printfMedium("\nResult count: " + this.exploration.getLastResult().getValue().size(), new Object[0]);
        if (this.getOutputFileName() != null) {
            PlainGraph gtsGraph = this.reducedGTS.toPlainGraph(true, true, true, false);
            try {
                Groove.saveGraph((Graph)gtsGraph, this.getOutputFileName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.isPrintStats && (report = this.explorationStats.getReport()).length() > 0) {
            this.println();
            this.println(report);
        }
    }

    private void reportGTS(AGTS gts, String header) {
        this.printfMedium("\n" + header + ": States: %d (%d final) -- %d subsumed (%d discarded) / Transitions: %d (%d subsumed)\n", gts.getStateCount(), gts.getFinalStates().size(), gts.getSubsumedStatesCount(), gts.openStateCount(), gts.getTransitionCount(), gts.getSubsumedTransitionsCount());
    }

    public AGTS getReducedGTS() {
        if (this.reducedGTS == null) {
            this.reducedGTS = this.getGTS().reduceGTS();
        }
        return this.reducedGTS;
    }

    public static void main(String[] args) {
        new ShapeGenerator(args).start();
    }

    private static class MultiplicityBoundOption
    implements CommandLineOption {
        final Multiplicity.MultKind kind;

        MultiplicityBoundOption(Multiplicity.MultKind kind) {
            this.kind = kind;
        }

        @Override
        public String getName() {
            String name = null;
            switch (this.kind) {
                case NODE_MULT: {
                    name = "n";
                    break;
                }
                case EDGE_MULT: {
                    name = "m";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return name;
        }

        @Override
        public String[] getDescription() {
            String type = null;
            switch (this.kind) {
                case NODE_MULT: {
                    type = "node";
                    break;
                }
                case EDGE_MULT: {
                    type = "edge";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new String[]{"Set the " + type + " multiplicity bound to " + "the given value.", "Argument '" + this.getParameterName() + "' must be greater than zero (default value is 1)."};
        }

        @Override
        public String getParameterName() {
            return "val";
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) throws IllegalArgumentException {
            int bound = 0;
            try {
                bound = Integer.parseInt(parameter);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("verbosity value '" + parameter + "' must be numeric");
            }
            if (bound < 1) {
                throw new IllegalArgumentException("'" + parameter + "' bound must be >= 1.");
            }
            switch (this.kind) {
                case NODE_MULT: {
                    NeighAbsParam.getInstance().setNodeMultBound(bound);
                    break;
                }
                case EDGE_MULT: {
                    NeighAbsParam.getInstance().setEdgeMultBound(bound);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private class ReachabilityOption
    implements CommandLineOption {
        private ReachabilityOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Reachability exploration, disables model checking afterwards."};
        }

        @Override
        public String getParameterName() {
            return null;
        }

        @Override
        public String getName() {
            return "c";
        }

        @Override
        public boolean hasParameter() {
            return false;
        }

        @Override
        public void parse(String parameter) {
            ShapeGenerator.this.setReachability();
        }
    }

    private class StatsOption
    implements CommandLineOption {
        private StatsOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Print the exploration statistics to stdout."};
        }

        @Override
        public String getParameterName() {
            return null;
        }

        @Override
        public String getName() {
            return "p";
        }

        @Override
        public boolean hasParameter() {
            return false;
        }

        @Override
        public void parse(String parameter) {
            ShapeGenerator.this.setPrintStats();
        }
    }

    private class ThreeMultValOption
    implements CommandLineOption {
        private ThreeMultValOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Limit the possible multiplicity values to three: 0, 1, or 0+."};
        }

        @Override
        public String getParameterName() {
            return null;
        }

        @Override
        public String getName() {
            return "t";
        }

        @Override
        public boolean hasParameter() {
            return false;
        }

        @Override
        public void parse(String parameter) {
            NeighAbsParam.getInstance().setUseThreeValues(true);
        }
    }
}

