/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.lts;

import groove.abstraction.neigh.lts.AGTS;
import groove.abstraction.neigh.lts.ShapeNextState;
import groove.abstraction.neigh.lts.ShapeState;
import groove.abstraction.neigh.lts.ShapeTransition;
import groove.abstraction.neigh.match.PreMatch;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.trans.Materialisation;
import groove.lts.GraphState;
import groove.lts.MatchApplier;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.transform.RuleEvent;
import groove.util.Pair;
import groove.util.Visitor;

public final class ShapeMatchApplier
extends MatchApplier {
    private static boolean DEBUG = false;
    private static final boolean USE_GUI = false;

    public ShapeMatchApplier(AGTS gts) {
        super(gts);
    }

    @Override
    public AGTS getGTS() {
        return (AGTS)super.getGTS();
    }

    @Override
    public RuleTransition apply(GraphState sourceGS, final MatchResult match) {
        assert (sourceGS instanceof ShapeState);
        addTransitionReporter.start();
        final ShapeState source = (ShapeState)sourceGS;
        RuleTransition result = null;
        RuleEvent origEvent = match.getEvent();
        Shape host = source.getGraph();
        AGTS agts = this.getGTS();
        if (host == null) {
            assert (agts.isReachability() && source.isDisconnected());
            return result;
        }
        assert (PreMatch.isValidPreMatch(host, origEvent));
        Visitor<Materialisation, RuleTransition> visitor = new Visitor<Materialisation, RuleTransition>(){

            @Override
            protected boolean process(Materialisation mat) {
                RuleTransition trans = ShapeMatchApplier.this.applyMaterialisation(source, match, mat);
                if (trans != null) {
                    this.setResult(trans);
                }
                return true;
            }
        };
        Materialisation.visitMaterialisations(host, origEvent.getMatch(host), visitor);
        result = (RuleTransition)visitor.getResult();
        addTransitionReporter.stop();
        return result;
    }

    private RuleTransition applyMaterialisation(ShapeState source, MatchResult match, Materialisation mat) {
        AGTS agts = this.getGTS();
        Pair<Shape, RuleEvent> pair = mat.applyMatch(agts.getRecord());
        Shape transformedShape = pair.one();
        RuleEvent realEvent = pair.two();
        MatchResult realMatch = new MatchResult(realEvent, match.getCtrlTransition());
        Shape target = transformedShape.normalise();
        RuleTransition trans = null;
        ShapeNextState newState = new ShapeNextState(agts.getNextStateNr(), target, source, realMatch);
        addStateReporter.start();
        ShapeState oldState = agts.addState(newState);
        addStateReporter.stop();
        if (oldState != null) {
            if (!agts.isReachability()) {
                trans = new ShapeTransition(source, realMatch, oldState);
                this.println("New transition: " + trans);
            }
        } else {
            trans = newState;
            this.println("New state: " + source + "--" + match + "-->" + newState);
        }
        if (trans != null) {
            agts.addTransition(trans);
        }
        return trans;
    }

    private void println(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

