/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.match;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.RuleToShapeMap;
import groove.grammar.Rule;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Graph;
import groove.graph.Label;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import groove.transform.Proof;
import groove.transform.RuleEvent;
import groove.util.Property;
import groove.util.Visitor;
import java.util.Map;
import java.util.Set;

public final class PreMatch {
    private PreMatch() {
    }

    public static Set<Proof> getPreMatches(final Shape shape, Rule rule) {
        assert (shape.getTypeGraph() == rule.getTypeGraph());
        MatcherFactory.instance().setEngine(SearchEngine.SearchMode.MINIMAL);
        MyHashSet<Proof> preMatches = new MyHashSet<Proof>();
        rule.traverseMatches(shape, null, Visitor.newCollector(preMatches, new Property<Proof>(){

            @Override
            public boolean isSatisfied(Proof value) {
                return PreMatch.isValidPreMatch(shape, value);
            }
        }));
        return preMatches;
    }

    public static boolean isValidPreMatch(Shape host, RuleEvent event) {
        return PreMatch.isValidPreMatch(host, event.getMatch(host));
    }

    public static boolean isValidPreMatch(Shape shape, Proof match) {
        RuleToShapeMap map = (RuleToShapeMap)match.getPatternMap();
        boolean complyToNodeMult = true;
        Map<ShapeNode, Multiplicity> nodeMultMap = shape.getNodeMultMap();
        for (ShapeNode nodeS : map.nodeMapValueSet()) {
            Multiplicity nSMult = nodeMultMap.get(nodeS);
            Set<RuleNode> nodesG = map.getPreImages(nodeS);
            if (Multiplicity.getNodeSetMult(nodesG).le(nSMult)) continue;
            complyToNodeMult = false;
            break;
        }
        boolean complyToEdgeMult = true;
        if (complyToNodeMult) {
            RuleGraph lhs = match.getRule().lhs();
            MyHashSet intersectEdges = new MyHashSet();
            EdgeSignatureStore shapeStore = shape.getEdgeSigStore();
            block5: for (Map.Entry<RuleNode, ShapeNode> entry : map.nodeMap().entrySet()) {
                RuleNode v = entry.getKey();
                ShapeNode pV = entry.getValue();
                EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
                int n = edgeMultDirArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EdgeMultDir dir = edgeMultDirArray[n2];
                    Set<EdgeSignature> ess = shapeStore.getSigs(pV, dir);
                    if (ess != null) {
                        for (EdgeSignature es : ess) {
                            Multiplicity rightMult = shapeStore.getMult(es);
                            for (ShapeEdge e : shapeStore.getEdges(es)) {
                                ShapeNode w = dir.opposite(e);
                                Set<RuleNode> pInvW = map.getPreImages(w);
                                RuleLabel ruleLabel = new RuleLabel((TypeLabel)e.label());
                                switch (dir) {
                                    case OUTGOING: {
                                        Util.getIntersectEdges((Graph)lhs, v, pInvW, (Label)ruleLabel, intersectEdges);
                                        break;
                                    }
                                    case INCOMING: {
                                        Util.getIntersectEdges((Graph)lhs, pInvW, v, (Label)ruleLabel, intersectEdges);
                                    }
                                }
                                Multiplicity leftMult = Multiplicity.getEdgeSetMult(intersectEdges);
                                if (leftMult.le(rightMult)) continue;
                                complyToEdgeMult = false;
                                break block5;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        return complyToNodeMult && complyToEdgeMult;
    }
}

