/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.NeighAbstraction;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.gui.dialog.ShapePreviewDialog;
import groove.abstraction.neigh.match.PreMatch;
import groove.abstraction.neigh.match.ReverseMatcherStore;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeMorphism;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.EdgeBundle;
import groove.abstraction.neigh.trans.Materialiser;
import groove.abstraction.neigh.trans.PowerSetIterator;
import groove.abstraction.neigh.trans.RuleToShapeMap;
import groove.abstraction.neigh.trans.ShapeRuleApplication;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Label;
import groove.io.graph.GxlIO;
import groove.match.Matcher;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import groove.match.TreeMatch;
import groove.transform.BasicEvent;
import groove.transform.Proof;
import groove.transform.Record;
import groove.transform.RuleEvent;
import groove.util.Pair;
import groove.util.Property;
import groove.util.Visitor;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class Materialisation {
    private int stage;
    private final Shape shape;
    private final Shape originalShape;
    private final ShapeMorphism morph;
    private final Proof preMatch;
    private final Rule matchedRule;
    private final RuleToShapeMap originalMatch;
    private final RuleToShapeMap match;
    private Set<ShapeNode> matNodes;
    private Set<ShapeEdge> matEdges;
    private Set<ShapeEdge> possibleEdges;
    private Map<ShapeNode, Set<EdgeBundle>> bundleMap;
    private Set<EdgeBundle> allBundles;
    private Map<ShapeNode, Set<ShapeNode>> nodeSplitMap;
    private Map<ShapeNode, Multiplicity> nodeSplitMultMap;

    private Materialisation(Shape shape, Proof preMatch) {
        this.stage = 1;
        this.originalShape = shape;
        this.preMatch = preMatch;
        this.originalMatch = (RuleToShapeMap)preMatch.getPatternMap();
        this.originalMatch.setFixed();
        this.matchedRule = preMatch.getRule();
        if (this.isRuleModifying()) {
            this.shape = this.originalShape.clone();
            this.morph = ShapeMorphism.createIdentityMorphism(this.shape, this.originalShape);
            this.match = this.originalMatch.clone();
            this.matNodes = new MyHashSet<ShapeNode>();
            this.matEdges = new MyHashSet<ShapeEdge>();
            this.possibleEdges = new MyHashSet<ShapeEdge>();
            this.bundleMap = new MyHashMap<ShapeNode, Set<EdgeBundle>>();
            this.allBundles = new MyHashSet<EdgeBundle>();
        } else {
            this.shape = null;
            this.morph = null;
            this.match = null;
        }
    }

    private Materialisation(Materialisation mat) {
        this.stage = mat.stage;
        this.originalShape = mat.originalShape;
        this.preMatch = mat.preMatch;
        this.originalMatch = mat.originalMatch;
        this.matchedRule = mat.matchedRule;
        assert (mat.match.isFixed());
        this.match = mat.match;
        this.shape = mat.shape.clone();
        this.morph = mat.morph.clone();
        if (this.stage == 1) {
            this.bundleMap = new MyHashMap<ShapeNode, Set<EdgeBundle>>();
            this.allBundles = new MyHashSet<EdgeBundle>();
            for (Map.Entry<ShapeNode, Set<EdgeBundle>> entry : mat.bundleMap.entrySet()) {
                ShapeNode node = entry.getKey();
                MyHashSet bundles = new MyHashSet();
                this.bundleMap.put(node, bundles);
                for (EdgeBundle matBundle : entry.getValue()) {
                    EdgeBundle bundle = matBundle.clone();
                    bundles.add(bundle);
                    this.allBundles.add(bundle);
                }
            }
        } else if (this.stage == 3) {
            this.nodeSplitMap = mat.nodeSplitMap;
            this.nodeSplitMultMap = mat.nodeSplitMultMap;
        } else assert (false);
    }

    public static Set<Materialisation> getMaterialisations(Shape shape, Proof preMatch) {
        MyHashSet<Materialisation> result = new MyHashSet<Materialisation>();
        Materialisation initialMat = new Materialisation(shape, preMatch);
        if (initialMat.isRuleModifying()) {
            Visitor.Collector collector = Visitor.newCollector(result);
            initialMat.visitSolutions(collector);
            collector.dispose();
        } else {
            result.add(initialMat);
        }
        return result;
    }

    public static void visitMaterialisations(Shape shape, Proof preMatch, Visitor<Materialisation, ?> visitor) {
        Materialisation initialMat = new Materialisation(shape, preMatch);
        if (initialMat.isRuleModifying()) {
            initialMat.visitSolutions(visitor);
        } else if (initialMat.postProcess()) {
            visitor.visit(initialMat);
        }
    }

    public String toString() {
        return "Materialisation:\nShape:\n" + this.shape + "Match: " + this.match + "\n";
    }

    public Materialisation clone() {
        return new Materialisation(this);
    }

    private boolean isRuleModifying() {
        return this.matchedRule.isModifying();
    }

    private boolean hasNACs() {
        return !this.matchedRule.getCondition().getSubConditions().isEmpty();
    }

    public int getStage() {
        return this.stage;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getOriginalShape() {
        return this.originalShape;
    }

    public RuleToShapeMap getMatch() {
        return this.match;
    }

    public RuleToShapeMap getOriginalMatch() {
        return this.originalMatch;
    }

    ShapeMorphism getShapeMorphism() {
        return this.morph;
    }

    private Set<RuleNode> getSingularRuleNodes() {
        return this.matchedRule.getAnchor().nodeSet();
    }

    Set<EdgeBundle> getBundles() {
        return this.allBundles;
    }

    Set<EdgeBundle> getBundles(ShapeNode node) {
        Set<EdgeBundle> result = this.bundleMap.get(node);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private EdgeBundle getBundle(ShapeNode node, EdgeSignature origEs) {
        EdgeBundle result = null;
        for (EdgeBundle bundle : this.getBundles(node)) {
            if (!bundle.isEqual(node, origEs)) continue;
            result = bundle;
            break;
        }
        return result;
    }

    private EdgeBundle createBundle(ShapeNode node, EdgeSignature origEs) {
        EdgeBundle result = this.getBundle(node, origEs);
        if (result == null) {
            result = this.createBundleWithoutStoring(node, origEs);
            this.addBundle(result);
        }
        return result;
    }

    private EdgeBundle getBundle(ShapeEdge edge, EdgeMultDir direction) {
        return this.createBundle(edge, direction);
    }

    private EdgeBundle createBundleWithoutStoring(ShapeNode node, EdgeSignature origEs) {
        Multiplicity origEsMult = this.getOrigEsMult(origEs);
        return new EdgeBundle(origEs, origEsMult, node);
    }

    private EdgeBundle createBundle(ShapeEdge edge, EdgeMultDir direction) {
        ShapeNode node = direction.incident(edge);
        EdgeSignature origEs = this.getOrigEs(edge, direction);
        return this.createBundle(node, origEs);
    }

    private void addBundle(EdgeBundle bundle) {
        Set<EdgeBundle> bundles = this.bundleMap.get(bundle.node);
        if (bundles == null) {
            bundles = new MyHashSet<EdgeBundle>();
            this.bundleMap.put(bundle.node, bundles);
        }
        bundles.add(bundle);
        this.allBundles.add(bundle);
    }

    private void removeNodeFromBundleMap(ShapeNode node) {
        this.allBundles.removeAll(this.getBundles(node));
        this.bundleMap.remove(node);
    }

    private EdgeSignature getOrigEs(ShapeEdge edge, EdgeMultDir direction) {
        return this.getShapeMorphism().getEdgeSignature(this.getOriginalShape(), this.getShape().getEdgeSignature(edge, direction));
    }

    private Multiplicity getOrigEsMult(EdgeSignature origEs) {
        return this.getOriginalShape().getEdgeSigMult(origEs);
    }

    boolean isFixed(ShapeEdge edge) {
        return !this.match.getPreImages(edge).isEmpty();
    }

    void updateShapeMorphism() {
        MyHashSet nodesToRemove = new MyHashSet();
        Set<ShapeNode> shapeNodes = this.shape.nodeSet();
        Set<ShapeNode> originalNodes = this.originalShape.nodeSet();
        for (Map.Entry entry : this.morph.nodeMap().entrySet()) {
            HostNode key = (HostNode)entry.getKey();
            HostNode value = (HostNode)entry.getValue();
            if (shapeNodes.contains(key) && originalNodes.contains(value)) continue;
            nodesToRemove.add(key);
        }
        for (HostNode nodeToRemove : nodesToRemove) {
            this.morph.removeNode(nodeToRemove);
        }
        MyHashSet edgesToRemove = new MyHashSet();
        Set<ShapeEdge> shapeEdges = this.shape.edgeSet();
        Set<ShapeEdge> originalEdges = this.originalShape.edgeSet();
        for (Map.Entry entry : this.morph.edgeMap().entrySet()) {
            HostEdge key = (HostEdge)entry.getKey();
            HostEdge value = (HostEdge)entry.getValue();
            if (shapeEdges.contains(key) && originalEdges.contains(value)) continue;
            edgesToRemove.add(key);
        }
        for (HostEdge edgeToRemove : edgesToRemove) {
            this.morph.removeEdge(edgeToRemove);
        }
    }

    boolean violatesNACs() {
        Matcher matcher;
        TreeMatch nacMatch;
        boolean result = false;
        if (this.hasNACs() && (nacMatch = (matcher = ReverseMatcherStore.getMatcher(this.matchedRule)).find(this.shape, this.match)) != null && !nacMatch.getSubMatches().isEmpty()) {
            final Shape shape = this.shape;
            Visitor.Finder<Proof> finder = Visitor.newFinder(new Property<Proof>(){

                @Override
                public boolean isSatisfied(Proof value) {
                    return Materialisation.hasConcreteMatch(shape, value);
                }
            });
            nacMatch.traverseProofs(finder);
            result = finder.found();
        }
        MatcherFactory.instance().setEngine(SearchEngine.SearchMode.MINIMAL);
        return result;
    }

    boolean isShapeMorphConsistent() {
        return this.morph.isValid(this.shape, this.originalShape) && this.morph.isConsistent(this.shape, this.originalShape);
    }

    public Pair<Shape, RuleEvent> applyMatch(Record record) {
        Shape result;
        RuleEvent event;
        if (this.isRuleModifying()) {
            assert (this.hasConcreteMatch());
            event = new BasicEvent(this.matchedRule, this.match, RuleEvent.Reuse.AGGRESSIVE);
            ShapeRuleApplication app = new ShapeRuleApplication(event, this.shape);
            result = app.getTarget();
        } else {
            assert (record != null);
            event = record.getEvent(this.preMatch);
            result = this.originalShape;
        }
        return new Pair<Shape, RuleEvent>(result, event);
    }

    static boolean hasConcreteMatch(Shape shape, Proof proof) {
        boolean result = false;
        for (Proof subProof : proof.getSubProofs()) {
            result = Materialisation.hasConcreteMatch(shape, (RuleToShapeMap)subProof.getPatternMap());
            if (result) break;
        }
        return result;
    }

    static boolean hasConcreteMatch(Shape shape, RuleToShapeMap map) {
        for (ShapeNode nodeS : map.nodeMap().values()) {
            if (shape.getNodeMult(nodeS).equals(Multiplicity.ONE_NODE_MULT)) continue;
            return false;
        }
        for (ShapeEdge edgeS : map.edgeMap().values()) {
            if (edgeS.getRole() != EdgeRole.BINARY || shape.isEdgeConcrete(edgeS)) continue;
            return false;
        }
        return true;
    }

    private boolean hasConcreteMatch() {
        assert (this.match.isConsistent());
        boolean complyToNodeMult = true;
        boolean complyToEquivClass = true;
        for (ShapeNode nodeS : this.match.nodeMapValueSet()) {
            if (!this.shape.getNodeMult(nodeS).equals(Multiplicity.ONE_NODE_MULT)) {
                complyToNodeMult = false;
                break;
            }
            if (this.shape.getEquivClassOf(nodeS).isSingleton()) continue;
            RuleNode nodeR = this.match.getPreImages(nodeS).iterator().next();
            if (!this.getSingularRuleNodes().contains(nodeR)) continue;
            complyToEquivClass = false;
            break;
        }
        boolean complyToEdgeMult = true;
        if (complyToNodeMult && complyToEquivClass) {
            MyHashSet intersectEdges = new MyHashSet();
            for (TypeLabel label : Util.getBinaryLabels(this.shape)) {
                block2: for (ShapeNode v : this.match.nodeMapValueSet()) {
                    for (ShapeNode w : this.match.nodeMapValueSet()) {
                        EquivClass<ShapeNode> ecW = this.shape.getEquivClassOf(w);
                        EdgeSignature outEs = this.shape.getEdgeSignature(EdgeMultDir.OUTGOING, v, label, ecW);
                        Multiplicity outMult = this.shape.getEdgeSigMult(outEs);
                        EdgeSignature inEs = this.shape.getEdgeSignature(EdgeMultDir.INCOMING, v, label, ecW);
                        Multiplicity inMult = this.shape.getEdgeSigMult(inEs);
                        Util.getIntersectEdges((Graph)this.shape, v, w, (Label)label, intersectEdges);
                        Multiplicity vInterWMult = Multiplicity.getEdgeSetMult(intersectEdges);
                        Util.getIntersectEdges((Graph)this.shape, w, v, (Label)label, intersectEdges);
                        Multiplicity wInterVMult = Multiplicity.getEdgeSetMult(intersectEdges);
                        if (outMult.equals(vInterWMult) && inMult.equals(wInterVMult)) continue;
                        complyToEdgeMult = false;
                        continue block2;
                    }
                }
            }
        }
        return complyToNodeMult && complyToEquivClass && complyToEdgeMult;
    }

    private Set<ShapeEdge> getAffectedEdges() {
        assert (this.stage == 1);
        MyHashSet<ShapeEdge> result = new MyHashSet<ShapeEdge>();
        result.addAll(this.matEdges);
        result.addAll(this.possibleEdges);
        return result;
    }

    public void addMatNode(ShapeNode newNode, ShapeNode collectorNode, RuleNode nodeR) {
        assert (this.stage == 1);
        assert (this.shape.containsNode(newNode));
        this.match.putNode(nodeR, newNode);
        this.morph.putNode(newNode, collectorNode);
        this.matNodes.add(newNode);
    }

    public void addMatEdge(ShapeEdge newEdge, ShapeEdge inconsistentEdge, RuleEdge edgeR) {
        assert (this.stage == 1);
        assert (this.shape.containsEdge(newEdge));
        this.match.putEdge(edgeR, newEdge);
        this.morph.putEdge(newEdge, inconsistentEdge);
        this.matEdges.add(newEdge);
    }

    public void handleCollectorNode(ShapeNode collectorNode) {
        assert (this.stage == 1);
        assert (this.shape.containsNode(collectorNode));
        this.matNodes.add(collectorNode);
    }

    public void handleInconsistentEdge(ShapeEdge inconsistentEdge) {
        assert (this.stage == 1);
        if (!this.shape.containsEdge(inconsistentEdge)) {
            this.morph.removeEdge(inconsistentEdge);
        } else {
            this.matEdges.add(inconsistentEdge);
        }
    }

    public void addPossibleEdge(ShapeEdge possibleEdge, ShapeEdge origEdge) {
        assert (this.stage == 1 || this.stage == 2);
        assert (!this.shape.containsEdge(possibleEdge));
        this.possibleEdges.add(possibleEdge);
        this.morph.putEdge(possibleEdge, origEdge);
    }

    private void visitSolutions(Visitor<Materialisation, ?> visitor) {
        this.prepareSolutions();
        if (this.getBundles().isEmpty()) {
            if (this.postProcess()) {
                visitor.visit(this);
            }
        } else {
            Materialiser.newInstance(this).visitSolutions(visitor);
        }
    }

    private void prepareSolutions() {
        assert (this.stage == 1);
        Map<ShapeNode, Multiplicity> originalMultMap = this.originalShape.getNodeMultMap();
        for (ShapeNode nodeS : this.originalMatch.nodeMapValueSet()) {
            if (!originalMultMap.get(nodeS).isCollector()) continue;
            this.shape.materialiseNode(this, nodeS);
        }
        for (ShapeEdge edgeS : this.match.getInconsistentEdges()) {
            this.shape.materialiseEdge(this, edgeS);
        }
        assert (this.match.isConsistent());
        this.match.setFixed();
        this.createPossibleEdges(this.morph.clone(), this.shape, this.originalShape, this.matNodes);
        for (RuleNode singularNodeR : this.getSingularRuleNodes()) {
            ShapeNode nodeS = this.match.getNode(singularNodeR);
            if (this.shape.getEquivClassOf(nodeS).isSingleton()) continue;
            this.shape.singulariseNode(this, nodeS);
        }
        this.computeBundles(this.getAffectedEdges());
    }

    private void createPossibleEdges(ShapeMorphism morph, Shape from, Shape to, Set<ShapeNode> nodes) {
        assert (this.stage == 1 || this.stage == 2);
        if (nodes.isEmpty()) {
            return;
        }
        morph.setFixed();
        for (ShapeNode node : nodes) {
            ShapeNode origNode = morph.getNode(node);
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                for (ShapeEdge origEdge : to.binaryEdgeSet(origNode, direction)) {
                    ShapeNode origOppNode = direction.opposite(origEdge);
                    for (ShapeNode oppNode : morph.getPreImages(origOppNode)) {
                        ShapeEdge possibleEdge = from.createEdge(node, oppNode, (Label)origEdge.label(), direction);
                        if (from.containsEdge(possibleEdge)) continue;
                        this.addPossibleEdge(possibleEdge, origEdge);
                    }
                }
                ++n2;
            }
        }
    }

    private void computeBundles(Set<ShapeEdge> toProcess) {
        assert (this.stage == 1);
        MyHashSet handledEdges = new MyHashSet();
        MyHashSet handledBundles = new MyHashSet();
        while (!toProcess.isEmpty()) {
            for (ShapeEdge edge : toProcess) {
                EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
                int n = edgeMultDirArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EdgeMultDir direction = edgeMultDirArray[n2];
                    EdgeBundle bundle = this.getBundle(edge, direction);
                    bundle.addEdge(this.shape, edge);
                    ++n2;
                }
                handledEdges.add(edge);
            }
            toProcess.clear();
            for (EdgeBundle bundle : this.getBundles()) {
                if (handledBundles.contains(bundle)) continue;
                bundle.computeAdditionalEdges(this);
                for (ShapeEdge edge : bundle.getEdges()) {
                    if (handledEdges.contains(edge)) continue;
                    toProcess.add(edge);
                }
                handledBundles.add(bundle);
                if (!this.shape.getNodeMult(bundle.node).isZeroPlus()) continue;
                for (ShapeEdge edge : this.shape.edgeSet(bundle.node)) {
                    if (edge.getRole() != EdgeRole.BINARY || handledEdges.contains(edge)) continue;
                    toProcess.add(edge);
                }
            }
        }
    }

    void removeUnconnectedNode(ShapeNode nodeToRemove) {
        assert (this.stage == 1);
        this.removeNodeFromBundleMap(nodeToRemove);
    }

    void moveToSecondStage(Set<EdgeBundle> nonSingBundles) {
        assert (this.stage == 1);
        ++this.stage;
        this.matEdges = null;
        if (nonSingBundles.isEmpty()) {
            return;
        }
        this.matNodes = new MyHashSet<ShapeNode>();
        this.possibleEdges = new MyHashSet<ShapeEdge>();
        this.nodeSplitMap = new MyHashMap<ShapeNode, Set<ShapeNode>>();
        this.nodeSplitMultMap = new MyHashMap<ShapeNode, Multiplicity>();
        MyHashSet origNodesToSplit = new MyHashSet();
        MyHashMap auxBundleMap = new MyHashMap();
        for (EdgeBundle nonSingBundle : nonSingBundles) {
            Set bundles;
            ShapeNode node = nonSingBundle.node;
            if (origNodesToSplit.add(node)) {
                bundles = new MyHashSet();
                auxBundleMap.put(node, bundles);
            } else {
                bundles = (Set)auxBundleMap.get(node);
            }
            bundles.add(nonSingBundle);
        }
        Shape shape = this.getShape();
        ShapeMorphism auxMorph = ShapeMorphism.createIdentityMorphism(shape, shape);
        MyHashMap<ShapeNode, PowerSetIterator> iterMap = new MyHashMap<ShapeNode, PowerSetIterator>();
        for (ShapeNode origNode : origNodesToSplit) {
            this.nodeSplitMap.put(origNode, new MyHashSet());
            this.nodeSplitMultMap.put(origNode, shape.getNodeMult(origNode));
            Set bundles = (Set)auxBundleMap.get(origNode);
            PowerSetIterator iter = new PowerSetIterator(bundles, true);
            shape.splitNode(this, origNode, iter.resultCount());
            iterMap.put(origNode, iter);
        }
        for (ShapeNode origNode : origNodesToSplit) {
            PowerSetIterator iter = (PowerSetIterator)iterMap.get(origNode);
            for (ShapeNode splitNode : this.nodeSplitMap.get(origNode)) {
                auxMorph.putNode(splitNode, origNode);
                this.addNewEdges(origNode, (Map<EdgeBundle, Set<ShapeEdge>>)iter.next(), splitNode);
            }
            assert (!iter.hasNext());
        }
        this.createPossibleEdges(auxMorph, shape, shape, this.matNodes);
        for (ShapeEdge edgeToAdd : this.possibleEdges) {
            shape.addEdge(edgeToAdd);
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                EdgeBundle bundle = this.getBundle(edgeToAdd, direction);
                bundle.addEdge(this.shape, edgeToAdd);
                ++n2;
            }
        }
        for (EdgeBundle bundle : this.getBundles()) {
            bundle.update(this);
        }
    }

    public void addSplitNode(ShapeNode newNode, ShapeNode origNode) {
        assert (this.stage == 2);
        assert (this.shape.containsNode(origNode));
        assert (this.shape.containsNode(newNode));
        this.morph.putNode(newNode, origNode);
        Set<ShapeNode> copies = this.nodeSplitMap.get(origNode);
        assert (copies != null);
        copies.add(newNode);
        this.matNodes.add(newNode);
    }

    private void addNewEdges(ShapeNode origNode, Map<EdgeBundle, Set<ShapeEdge>> origMap, ShapeNode newNode) {
        assert (this.stage == 2);
        MyHashSet<ShapeEdge> newEdges = new MyHashSet<ShapeEdge>();
        for (Map.Entry<EdgeBundle, Set<ShapeEdge>> entry : origMap.entrySet()) {
            EdgeBundle origBundle = entry.getKey();
            EdgeMultDir direction = origBundle.direction;
            EdgeMultDir reverse = direction.reverse();
            EdgeBundle newBundle = this.createBundle(newNode, origBundle.origEs);
            for (ShapeEdge origEdge : entry.getValue()) {
                this.routeNewEdges(origNode, origEdge, newNode, direction, newEdges);
                for (ShapeEdge newEdge : newEdges) {
                    newBundle.addEdge(this.shape, newEdge);
                    newBundle.setEdgeAsFixed(newEdge);
                    this.shape.addEdge(newEdge);
                    this.morph.putEdge(newEdge, this.morph.getEdge(origEdge));
                    EdgeBundle oppBundle = this.getBundle(newEdge, reverse);
                    oppBundle.addEdge(this.shape, newEdge);
                    oppBundle.setEdgeAsFixed(newEdge);
                }
                newEdges.clear();
            }
            this.addBundle(newBundle);
        }
    }

    private void routeNewEdges(ShapeNode origNode, ShapeEdge origEdge, ShapeNode newNode, EdgeMultDir direction, Set<ShapeEdge> result) {
        assert (this.stage == 2);
        TypeLabel label = (TypeLabel)origEdge.label();
        ShapeNode incident = newNode;
        ShapeNode opposite = direction.opposite(origEdge);
        ShapeEdge newEdge = this.shape.createEdge(incident, opposite, label, direction);
        result.add(newEdge);
        Set<ShapeNode> splitNodes = this.nodeSplitMap.get(opposite);
        if (splitNodes != null) {
            for (ShapeNode newOpposite : splitNodes) {
                newEdge = this.shape.createEdge(incident, newOpposite, label, direction);
                result.add(newEdge);
            }
        }
    }

    Set<ShapeNode> getAffectedNodes() {
        assert (this.stage == 2);
        return this.bundleMap.keySet();
    }

    boolean requiresThirdStage() {
        return this.nodeSplitMap != null && !this.nodeSplitMap.isEmpty();
    }

    private void markGarbageNodes(Set<ShapeNode> garbageNodes) {
        assert (this.stage == 2 || this.stage == 3);
        assert (garbageNodes != null);
        garbageNodes.clear();
        Shape shape = this.shape;
        Map<EdgeSignature, Multiplicity> origEdgeMultMap = this.originalShape.getEdgeMultMap();
        this.updateShapeMorphism();
        ShapeMorphism morph = this.morph.clone();
        for (Map.Entry<EdgeSignature, Multiplicity> origEsEntry : origEdgeMultMap.entrySet()) {
            if (origEsEntry.getValue().isZeroPlus()) continue;
            EdgeSignature origEs = origEsEntry.getKey();
            for (ShapeNode node : morph.getPreImages(origEs.getNode())) {
                Multiplicity mult = morph.getPreImagesMult(shape, node, origEs);
                if (!mult.isZero()) continue;
                garbageNodes.add(node);
            }
        }
    }

    void recursiveGarbageCollectNodes() {
        if (this.stage == 2 || this.stage == 3) {
            MyHashSet<ShapeNode> garbageNodes = new MyHashSet<ShapeNode>();
            this.markGarbageNodes(garbageNodes);
            while (!garbageNodes.isEmpty()) {
                for (ShapeNode garbageNode : garbageNodes) {
                    this.shape.removeNodeContext(garbageNode);
                }
                this.markGarbageNodes(garbageNodes);
            }
        }
    }

    void moveToThirdStage() {
        assert (this.stage == 2);
        ++this.stage;
    }

    Map<ShapeNode, Set<ShapeNode>> getNodeSplitMap() {
        assert (this.stage == 3);
        return this.nodeSplitMap;
    }

    Multiplicity getOrigNodeMult(ShapeNode origNode) {
        assert (this.stage == 3);
        return this.nodeSplitMultMap.get(origNode);
    }

    boolean postProcess() {
        this.recursiveGarbageCollectNodes();
        this.updateShapeMorphism();
        assert (this.isShapeMorphConsistent());
        assert (this.getShape().isInvariantOK());
        return !this.violatesNACs();
    }

    public static void main(String[] args) {
        String DIRECTORY = "junit/abstraction/temp.gps/";
        NeighAbsParam.getInstance().setNodeMultBound(1);
        NeighAbsParam.getInstance().setEdgeMultBound(1);
        NeighAbsParam.getInstance().setUseThreeValues(true);
        NeighAbstraction.initialise();
        File file = new File(String.valueOf(DIRECTORY) + "error.gxl");
        File grammarFile = new File(DIRECTORY);
        try {
            GrammarModel view = GrammarModel.newInstance(grammarFile, false);
            Grammar grammar = view.toGrammar();
            Rule rule = grammar.getRule("rule");
            Shape shape = GxlIO.getInstance().loadGraph(file).toShape(view.getTypeGraph());
            Set<Proof> preMatches = PreMatch.getPreMatches(shape, rule);
            for (Proof preMatch : preMatches) {
                Set<Materialisation> mats = Materialisation.getMaterialisations(shape, preMatch);
                for (Materialisation mat : mats) {
                    ShapePreviewDialog.showShape(mat.shape);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
    }
}

