/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore;

import groove.abstraction.pattern.PatternAbstraction;
import groove.abstraction.pattern.explore.strategy.PatternDFSStrategy;
import groove.abstraction.pattern.explore.util.TransSystemChecker;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PGTSAdapter;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.lts.PatternTransition;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeGraphFactory;
import groove.abstraction.pattern.trans.PatternGraphGrammar;
import groove.explore.strategy.DFSStrategy;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.lts.GTS;
import groove.util.CommandLineTool;
import groove.util.Groove;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class PatternGraphGenerator
extends CommandLineTool {
    private static final String USAGE_MESSAGE = "Usage: PatternGraphGenerator [options] <grammar> <start-graph-name> <type-graph-name>";
    protected static PGTS pgts;
    protected String grammarLocation;
    protected String startGraphName;
    protected String typeGraphName;
    private PatternGraphGrammar grammar;

    public PatternGraphGenerator(String ... args) {
        super(args);
    }

    @Override
    protected String getUsageMessage() {
        return USAGE_MESSAGE;
    }

    @Override
    public void processArguments() {
        super.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            this.setGrammarLocation(argsList.remove(0));
        }
        if (argsList.size() > 0) {
            this.setStartGraph(argsList.remove(0));
        }
        if (argsList.size() > 0) {
            this.setTypeGraph(argsList.remove(0));
        }
        if (this.grammarLocation == null) {
            this.printError("No grammar location specified", true);
        }
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    private void setGrammarLocation(String grammarLocation) {
        this.grammarLocation = grammarLocation;
    }

    private void setStartGraph(String startGraphName) {
        this.startGraphName = startGraphName;
    }

    private void setTypeGraph(String typeGraphName) {
        this.typeGraphName = typeGraphName;
    }

    protected void reset() {
        PatternAbstraction.initialise();
        pgts = null;
    }

    public PGTS getPGTS() {
        if (pgts == null) {
            pgts = new PGTS(this.getGrammar());
        }
        return pgts;
    }

    public void start() {
        this.processArguments();
        this.explore();
        this.report();
    }

    public void explore() {
        this.reset();
        this.prelude();
        PatternDFSStrategy strategy = new PatternDFSStrategy();
        strategy.prepare(this.getPGTS());
        while (strategy.next()) {
        }
    }

    protected void prelude() {
        if (this.getVerbosity() > 0) {
            this.println("\n======================================================\n");
            this.println("Grammar:\t" + this.grammarLocation);
            this.println("Start graph:\t" + (this.startGraphName == null ? "default" : this.startGraphName));
            this.println("Type graph:\t" + this.typeGraphName);
            this.print("\nProgress:\n\n");
            this.addProgressMonitor();
        }
    }

    protected void addProgressMonitor() {
        this.getPGTS().addLTSListener(new GenerateProgressMonitor());
    }

    public void report() {
        GTS SGTS = this.exploreSimpleGrammar();
        TransSystemChecker checker = new TransSystemChecker(this.getPGTS(), SGTS);
        checker.report();
    }

    public boolean compareGTSs() {
        GTS SGTS = this.exploreSimpleGrammar();
        TransSystemChecker checker = new TransSystemChecker(this.getPGTS(), SGTS);
        return checker.compare();
    }

    protected PatternGraphGrammar getGrammar() {
        if (this.grammar == null) {
            this.loadGrammar(this.grammarLocation, this.startGraphName, this.typeGraphName);
        }
        return this.grammar;
    }

    private void loadGrammar(String grammarFile, String startGraph, String typeGraph) {
        try {
            GrammarModel model = Groove.loadGrammar(grammarFile);
            model.setLocalActiveNames(ResourceKind.HOST, startGraph);
            Grammar sGrammar = model.toGrammar();
            sGrammar.setFixed();
            File typeGraphFile = new File(String.valueOf(grammarFile) + ".gps/" + typeGraph);
            TypeGraph type = TypeGraphFactory.unmarshalTypeGraph(typeGraphFile);
            this.grammar = new PatternGraphGrammar(sGrammar, type);
        }
        catch (FormatException exc) {
            this.printError("Grammar format error: " + exc.getMessage(), false);
        }
        catch (IOException exc) {
            this.printError("I/O error while loading grammar: " + exc.getMessage(), false);
        }
    }

    private GTS exploreSimpleGrammar() {
        Grammar sGrammar = this.getGrammar().getSimpleGrammar();
        GTS result = new GTS(sGrammar);
        DFSStrategy strategy = new DFSStrategy();
        strategy.setGTS(result);
        strategy.play();
        return result;
    }

    public static void main(String[] args) {
        new PatternGraphGenerator(args).start();
    }

    private class GenerateProgressMonitor
    extends PGTSAdapter {
        private int printed = 0;
        private static final int UNIT = 100;
        private static final int WIDTH = 100;

        @Override
        public void addUpdate(PGTS gts, PatternState state) {
            if (gts.nodeCount() % 100 == 0) {
                System.out.print("s");
                ++this.printed;
            }
            this.endLine(gts);
        }

        @Override
        public void addUpdate(PGTS gts, PatternTransition transition) {
            if (gts.edgeCount() % 100 == 0) {
                System.out.print("t");
                ++this.printed;
            }
            this.endLine(gts);
        }

        private void endLine(PGTS gts) {
            if (this.printed == 100) {
                int nodeCount = gts.nodeCount();
                int edgeCount = gts.edgeCount();
                int explorableCount = gts.openStateCount();
                System.out.println(" " + nodeCount + "s (" + explorableCount + "x) " + edgeCount + "t ");
                this.printed = 0;
            }
        }
    }
}

