/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore.strategy;

import groove.abstraction.pattern.explore.strategy.PatternStrategy;
import groove.abstraction.pattern.explore.util.PatternGraphMatchSetCollector;
import groove.abstraction.pattern.explore.util.PatternRuleEventApplier;
import groove.abstraction.pattern.lts.MatchResult;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PatternState;

public abstract class AbstractPatternStrategy
implements PatternStrategy {
    private PatternRuleEventApplier applier;
    private PGTS pgts;
    private PatternState atState;

    @Override
    public void prepare(PGTS pgts) {
        this.pgts = pgts;
        this.atState = pgts.startState();
    }

    @Override
    public boolean next() {
        if (this.getState() == null) {
            return false;
        }
        for (MatchResult next : this.createMatchCollector().getMatchSet()) {
            this.getMatchApplier().apply(this.getState(), next);
        }
        this.getState().setClosed(true);
        return this.updateAtState();
    }

    private PatternState getState() {
        return this.atState;
    }

    protected abstract PatternState getNextState();

    protected PGTS getPGTS() {
        return this.pgts;
    }

    private boolean updateAtState() {
        this.atState = this.getNextState();
        return this.atState != null;
    }

    private PatternGraphMatchSetCollector createMatchCollector() {
        return this.getPGTS().createMatchCollector(this.getState());
    }

    private PatternRuleEventApplier getMatchApplier() {
        if (this.applier == null) {
            this.applier = this.getPGTS().createMatchApplier();
        }
        return this.applier;
    }
}

