/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore.util;

import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PatternState;
import groove.grammar.host.HostGraph;
import groove.graph.iso.IsoChecker;
import groove.graph.plain.PlainGraph;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.StartGraphState;
import java.io.OutputStream;
import java.io.PrintStream;

public final class TransSystemChecker {
    private final PGTS pgts;
    private final GTS sgts;

    public TransSystemChecker(PGTS pgts, GTS sgts) {
        this.pgts = pgts;
        this.sgts = sgts;
    }

    public void report() {
        PrintStream out = System.out;
        out.println(String.format("PGTS: states = %s / transitions = %s", this.pgts.getStateCount(), this.pgts.getTransitionCount()));
        out.println(String.format("SGTS: states = %s / transitions = %s", this.sgts.nodeCount(), this.sgts.getTransitionCount()));
        this.compare(out);
    }

    public boolean compare() {
        OutputStream nullStream = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        return this.compare(new PrintStream(nullStream));
    }

    private boolean compare(PrintStream out) {
        PlainGraph plainSGTS = this.sgts.toPlainGraph(false, false, false, false);
        PlainGraph plainPGTS = this.pgts.toPlainGraph();
        IsoChecker gtsChecker = IsoChecker.getInstance(true);
        if (gtsChecker.areIsomorphic(plainSGTS, plainPGTS)) {
            out.print("Transision systems are isomorphic. Checking states... ");
            for (PatternState patternState : this.pgts.nodeSet()) {
                HostGraph pGraph = patternState.getGraph().flatten();
                StartGraphState newSState = new StartGraphState(this.sgts, pGraph);
                newSState.setCtrlState(patternState.getCtrlState());
                GraphState oldSState = this.sgts.addState(newSState);
                if (oldSState != null) continue;
                out.println("FAILED!");
                return false;
            }
            out.println("PASSED.");
            return true;
        }
        out.println("Transition systems are NOT isomorphic.");
        return false;
    }
}

