/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.gui.jgraph;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.gui.jgraph.PatternJCell;
import groove.abstraction.pattern.gui.jgraph.PatternJGraph;
import groove.abstraction.pattern.gui.jgraph.PatternJVertex;
import groove.abstraction.pattern.shape.AbstractPatternGraph;
import groove.abstraction.pattern.shape.AbstractPatternNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.graph.Label;
import groove.graph.Node;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.ParentMap;

public class PatternJModel
extends JModel<AbstractPatternGraph<?, ?>> {
    private Map<Node, PatternJVertex> pNodeJCellMap = new HashMap<Node, PatternJVertex>();
    private ParentMap parentMap;
    private Map<PatternJVertex, List<PatternJCell>> reverseParentMap;
    private HostFactory hostFactory;

    PatternJModel(PatternJGraph jGraph) {
        super(jGraph);
    }

    @Override
    public AbstractPatternGraph<?, ?> getGraph() {
        return (AbstractPatternGraph)super.getGraph();
    }

    @Override
    protected void prepareLoad(AbstractPatternGraph<?, ?> graph) {
        super.prepareLoad(graph);
        this.pNodeJCellMap.clear();
        this.hostFactory = HostFactory.newInstance();
    }

    @Override
    public JVertex<AbstractPatternGraph<?, ?>> getJCellForNode(Node node) {
        if (this.isPatternTyped(node)) {
            return this.pNodeJCellMap.get(node);
        }
        return super.getJCellForNode(node);
    }

    protected PatternJVertex addNode(Node node) {
        PatternJVertex result = (PatternJVertex)super.addNode(node);
        if (this.isPatternTyped(node)) {
            this.pNodeJCellMap.put(node, result);
        }
        return result;
    }

    @Override
    protected void prepareInsert() {
        super.prepareInsert();
        this.parentMap = new ParentMap();
        this.reverseParentMap = new MyHashMap<PatternJVertex, List<PatternJCell>>();
    }

    @Override
    protected ParentMap getParentMap() {
        return this.parentMap;
    }

    protected PatternJVertex computeJVertex(Node node) {
        PatternJVertex result = (PatternJVertex)super.computeJVertex(node);
        if (this.isPatternTyped(node)) {
            this.createPattern((AbstractPatternNode)node, result);
        }
        return result;
    }

    public List<JCell<AbstractPatternGraph<?, ?>>> getPatternRoots() {
        ArrayList result = new ArrayList();
        for (Node pNode : ((AbstractPatternGraph)this.getGraph()).getLayerNodes(0)) {
            result.add(this.pNodeJCellMap.get(pNode));
        }
        return result;
    }

    public Map<PatternJVertex, List<PatternJCell>> getReverseParentMap() {
        return this.reverseParentMap;
    }

    private boolean isPatternTyped(Node node) {
        return node instanceof AbstractPatternNode;
    }

    private void createPattern(AbstractPatternNode pNode, PatternJVertex pJVertex) {
        HostGraph pattern = pNode.getPattern();
        MyHashMap<HostNode, HostNode> nodeMap = new MyHashMap<HostNode, HostNode>();
        for (HostNode sNode : pattern.nodeSet()) {
            HostNode newSNode = (HostNode)this.hostFactory.createNode();
            nodeMap.put(sNode, newSNode);
            PatternJVertex sJVertex = this.addNode(newSNode);
            this.parentMap.addEntry((Object)sJVertex, (Object)pJVertex);
            this.addToReverseMap(pJVertex, sJVertex);
        }
        for (HostEdge sEdge : pattern.edgeSet()) {
            HostNode source = (HostNode)nodeMap.get(sEdge.source());
            HostNode target = (HostNode)nodeMap.get(sEdge.target());
            HostEdge newSEdge = this.hostFactory.createEdge(source, (Label)sEdge.label(), target);
            PatternJCell sJEdge = (PatternJCell)this.addEdge(newSEdge);
            this.parentMap.addEntry((Object)sJEdge, (Object)pJVertex);
            this.addToReverseMap(pJVertex, sJEdge);
        }
    }

    private void addToReverseMap(PatternJVertex pJVertex, PatternJCell jCell) {
        List<PatternJCell> cells = this.reverseParentMap.get(pJVertex);
        if (cells == null) {
            cells = new ArrayList<PatternJCell>();
            this.reverseParentMap.put(pJVertex, cells);
        }
        cells.add(jCell);
    }
}

