/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.gui.look;

import groove.abstraction.pattern.gui.jgraph.PatternJEdge;
import groove.abstraction.pattern.gui.jgraph.PatternJGraph;
import groove.abstraction.pattern.gui.jgraph.PatternJVertex;
import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternShape;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JVertex;
import groove.gui.look.LabelValue;
import groove.gui.look.Line;
import groove.gui.look.MultiLabel;

public class PatternLabelValue
extends LabelValue {
    public PatternLabelValue(PatternJGraph jGraph) {
        super(jGraph);
    }

    @Override
    protected MultiLabel getJVertexLabel(JVertex<?> jVertex) {
        if (((PatternJVertex)jVertex).isOuter()) {
            return new MultiLabel();
        }
        return super.getJVertexLabel(jVertex);
    }

    @Override
    protected MultiLabel getJEdgeLabel(JEdge<?> jEdge) {
        PatternJEdge myJEdge = (PatternJEdge)jEdge;
        if (myJEdge.isOuter()) {
            return this.getPatternJEdgeLabel(myJEdge);
        }
        return super.getJEdgeLabel(jEdge);
    }

    private MultiLabel getPatternJEdgeLabel(PatternJEdge jEdge) {
        MultiLabel result = new MultiLabel();
        for (Edge edge : jEdge.getEdges()) {
            StringBuilder sb = new StringBuilder();
            sb.append(((AbstractPatternEdge)edge).getPrintableLabel());
            Graph graph = this.getJGraph().getModel().getGraph();
            if (graph instanceof PatternShape) {
                PatternShape pShape = (PatternShape)graph;
                sb.append("(" + pShape.getMult((PatternEdge)edge) + ")");
            }
            result.add(Line.atom(sb.toString()), jEdge.getDirect(edge));
        }
        return result;
    }
}

