/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.lts;

import groove.abstraction.pattern.lts.AbstractPatternState;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternShape;
import groove.control.CtrlState;
import java.util.ArrayList;
import java.util.List;

public class PatternGraphState
extends AbstractPatternState {
    private PatternGraph graph;
    private final PGTS pgts;
    private PatternState subsumptor;
    private List<PatternState> subsumedStates;

    public PatternGraphState(PatternGraph graph, CtrlState ctrlState, int number, PGTS pgts) {
        super(number);
        this.graph = graph;
        this.graph.setName(this.toString());
        this.graph.setFixed();
        this.pgts = pgts;
        this.setCtrlState(ctrlState);
    }

    @Override
    public PGTS getPGTS() {
        return this.pgts;
    }

    @Override
    public PatternGraph getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasPatternShape() {
        return this.graph instanceof PatternShape;
    }

    @Override
    public PatternShape getShape() {
        return (PatternShape)this.graph;
    }

    @Override
    public boolean isSubsumed() {
        return this.subsumptor != null;
    }

    @Override
    public void addSubsumedState(PatternState subsumed) {
        this.getSubsumedStates().add(subsumed);
    }

    @Override
    public boolean setSubsumptor(PatternState subsumptor) {
        if (this.subsumptor != null) {
            return false;
        }
        this.subsumptor = subsumptor;
        return true;
    }

    @Override
    public int markSubsumedStates() {
        int markCount = 0;
        for (PatternState subsumed : this.getSubsumedStates()) {
            if (!subsumed.setSubsumptor(this)) continue;
            ++markCount;
        }
        this.subsumedStates = null;
        return markCount;
    }

    private List<PatternState> getSubsumedStates() {
        if (this.subsumedStates == null) {
            this.subsumedStates = new ArrayList<PatternState>();
        }
        return this.subsumedStates;
    }
}

