/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.match.SearchItem;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.plain.PlainLabel;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class PatternEdgeSearchItem
extends SearchItem {
    private final RuleEdge edge;
    private final TypeEdge type;
    private final RuleNode source;
    private final TypeNode sourceType;
    private final RuleNode target;
    private final TypeNode targetType;
    private final Set<RuleNode> boundNodes;
    private int edgeIx;
    private int sourceIx;
    private int targetIx;
    private boolean sourceFound;
    private boolean targetFound;

    public PatternEdgeSearchItem(RuleEdge edge) {
        this.edge = edge;
        this.type = edge.getType();
        this.source = (RuleNode)edge.source();
        this.sourceType = this.source.getType();
        this.target = (RuleNode)edge.target();
        this.targetType = this.target.getType();
        this.boundNodes = new MyHashSet<RuleNode>();
        this.boundNodes.add(this.source);
        this.boundNodes.add(this.target);
    }

    @Override
    public Collection<RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public Collection<RuleEdge> bindsEdges() {
        return Collections.singleton(this.edge);
    }

    public String toString() {
        return String.format("Find %s", this.getEdge());
    }

    @Override
    public int compareTo(SearchItem other) {
        int result = 0;
        if (other instanceof PatternEdgeSearchItem) {
            RuleEdge otherEdge = ((PatternEdgeSearchItem)other).getEdge();
            result = ((PlainLabel)this.getEdge().label()).compareTo((Label)otherEdge.label());
            if (result == 0) {
                result = ((RuleNode)this.edge.source()).compareTo((Node)otherEdge.source());
            }
            if (result == 0) {
                result = ((RuleNode)this.edge.target()).compareTo((Node)otherEdge.target());
            }
        }
        if (result == 0) {
            return super.compareTo(other);
        }
        return result;
    }

    @Override
    SearchItem.Record createRecord(Matcher.Search search) {
        if (this.sourceFound && this.targetFound) {
            return this.createSingularRecord(search);
        }
        return this.createMultipleRecord(search);
    }

    @Override
    int getRating() {
        return this.type.hashCode();
    }

    @Override
    void activate(Matcher matcher) {
        assert (!matcher.isEdgeFound(this.edge));
        this.edgeIx = matcher.getEdgeIx(this.edge);
        this.sourceFound = matcher.isNodeFound(this.source);
        this.sourceIx = matcher.getNodeIx(this.source);
        this.targetFound = matcher.isNodeFound(this.target);
        this.targetIx = matcher.getNodeIx(this.target);
    }

    public RuleEdge getEdge() {
        return this.edge;
    }

    SearchItem.SingularRecord createSingularRecord(Matcher.Search search) {
        return new PatternEdgeSingularRecord(search, this.edgeIx, this.sourceIx, this.targetIx);
    }

    SearchItem.MultipleRecord<PatternEdge> createMultipleRecord(Matcher.Search search) {
        return new PatternEdgeMultipleRecord(search, this.edgeIx, this.sourceIx, this.targetIx, this.sourceFound, this.targetFound);
    }

    boolean checkEdgeType(PatternEdge image) {
        return this.type == image.getType();
    }

    boolean checkSourceType(PatternNode imageSource) {
        return this.sourceType == imageSource.getType();
    }

    boolean checkTargetType(PatternNode imageTarget) {
        return this.targetType == imageTarget.getType();
    }

    static /* synthetic */ RuleEdge access$0(PatternEdgeSearchItem patternEdgeSearchItem) {
        return patternEdgeSearchItem.edge;
    }

    private final class PatternEdgeMultipleRecord
    extends SearchItem.MultipleRecord<PatternEdge> {
        private final int edgeIx;
        private final int sourceIx;
        private final int targetIx;
        private final boolean sourceFound;
        private final boolean targetFound;
        private PatternNode sourceFind;
        private PatternNode targetFind;
        private PatternEdge selected;

        PatternEdgeMultipleRecord(Matcher.Search search, int edgeIx, int sourceIx, int targetIx, boolean sourceFound, boolean targetFound) {
            super(PatternEdgeSearchItem.this, search);
            this.edgeIx = edgeIx;
            this.sourceIx = sourceIx;
            this.targetIx = targetIx;
            this.sourceFound = sourceFound;
            this.targetFound = targetFound;
            assert (search.getEdge(edgeIx) == null) : String.format("Edge %s already in %s", PatternEdgeSearchItem.access$0(patternEdgeSearchItem), search);
        }

        @Override
        void init() {
            if (this.sourceFound) {
                this.sourceFind = this.search.getNode(this.sourceIx);
                assert (this.sourceFind != null) : String.format("Source node of %s not found", PatternEdgeSearchItem.access$0(PatternEdgeSearchItem.this));
            }
            if (this.targetFound) {
                this.targetFind = this.search.getNode(this.targetIx);
                assert (this.targetFind != null) : String.format("Target node of %s not found", PatternEdgeSearchItem.access$0(PatternEdgeSearchItem.this));
            }
            this.initImages();
        }

        void initImages() {
            Set<Object> result = null;
            Set labelEdgeSet = this.host.edgeSet((Label)PatternEdgeSearchItem.this.type.label());
            if (this.sourceFind != null) {
                Set nodeEdgeSet = this.host.edgeSet(this.sourceFind);
                if (nodeEdgeSet.size() < labelEdgeSet.size()) {
                    result = nodeEdgeSet;
                }
            } else if (this.targetFind != null) {
                Set nodeEdgeSet = this.host.edgeSet(this.targetFind);
                if (nodeEdgeSet == null) {
                    result = Collections.emptySet();
                } else if (nodeEdgeSet.size() < labelEdgeSet.size()) {
                    result = nodeEdgeSet;
                }
            }
            if (result == null) {
                result = labelEdgeSet;
            }
            this.imageIter = result.iterator();
        }

        @Override
        boolean write(PatternEdge image) {
            if (!PatternEdgeSearchItem.this.checkEdgeType(image)) {
                return false;
            }
            if (!this.writeSourceImage(image)) {
                return false;
            }
            if (!this.writeTargetImage(image)) {
                this.eraseSourceImage();
                return false;
            }
            if (!this.search.putEdge(this.edgeIx, image)) {
                this.eraseSourceImage();
                this.eraseTargetImage();
                return false;
            }
            this.selected = image;
            return true;
        }

        private boolean writeSourceImage(PatternEdge image) {
            PatternNode imageSource = (PatternNode)image.source();
            if (this.sourceFind == null) {
                this.eraseTargetImage();
                if (!PatternEdgeSearchItem.this.checkSourceType(imageSource)) {
                    return false;
                }
                if (!this.search.putNode(this.sourceIx, imageSource)) {
                    return false;
                }
            } else if (imageSource != this.sourceFind) {
                return false;
            }
            return true;
        }

        private boolean writeTargetImage(PatternEdge image) {
            PatternNode imageTarget = (PatternNode)image.target();
            if (this.targetFind == null) {
                if (!PatternEdgeSearchItem.this.checkTargetType(imageTarget)) {
                    return false;
                }
                if (!this.search.putNode(this.targetIx, imageTarget)) {
                    return false;
                }
            } else if (imageTarget != this.targetFind) {
                return false;
            }
            return true;
        }

        @Override
        void erase() {
            this.search.putEdge(this.edgeIx, null);
            this.eraseSourceImage();
            this.eraseTargetImage();
            this.selected = null;
        }

        private void eraseSourceImage() {
            if (this.sourceFind == null) {
                this.search.putNode(this.sourceIx, null);
            }
        }

        private void eraseTargetImage() {
            if (this.targetFind == null) {
                this.search.putNode(this.targetIx, null);
            }
        }

        public String toString() {
            return String.valueOf(PatternEdgeSearchItem.this.toString()) + " = " + this.selected;
        }
    }

    private final class PatternEdgeSingularRecord
    extends SearchItem.SingularRecord {
        private final int edgeIx;
        private final int sourceIx;
        private final int targetIx;
        private PatternEdge image;

        public PatternEdgeSingularRecord(Matcher.Search search, int edgeIx, int sourceIx, int targetIx) {
            super(PatternEdgeSearchItem.this, search);
            this.edgeIx = edgeIx;
            this.sourceIx = sourceIx;
            this.targetIx = targetIx;
        }

        @Override
        boolean find() {
            PatternEdge image = this.getEdgeImage();
            assert (image != null);
            boolean result = this.isImageCorrect(image);
            if (result) {
                this.image = image;
                this.write();
            }
            return result;
        }

        @Override
        final boolean write() {
            return this.search.putEdge(this.edgeIx, this.image);
        }

        @Override
        void erase() {
            this.search.putEdge(this.edgeIx, null);
        }

        boolean isImageCorrect(PatternEdge image) {
            return this.host.containsEdge(image);
        }

        private PatternEdge getEdgeImage() {
            PatternNode sourceFind = this.search.getNode(this.sourceIx);
            assert (sourceFind != null) : String.format("Source node of %s has not been found", PatternEdgeSearchItem.access$0(PatternEdgeSearchItem.this));
            PatternNode targetFind = this.search.getNode(this.targetIx);
            assert (targetFind != null) : String.format("Target node of %s has not been found", PatternEdgeSearchItem.access$0(PatternEdgeSearchItem.this));
            return this.host.getFactory().createEdge(sourceFind, this.getType(), targetFind);
        }

        TypeEdge getType() {
            return PatternEdgeSearchItem.this.type;
        }

        @Override
        public String toString() {
            return String.valueOf(PatternEdgeSearchItem.this.toString()) + " = " + this.getEdgeImage();
        }
    }
}

