/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.match.SearchItem;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.RuleNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class PatternNodeSearchItem
extends SearchItem {
    private final RuleNode node;
    private final TypeNode type;
    private final Set<RuleNode> boundNodes;
    private int nodeIx;

    public PatternNodeSearchItem(RuleNode node) {
        this.node = node;
        this.type = node.getType();
        this.boundNodes = Collections.singleton(node);
    }

    @Override
    public Collection<RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    public String toString() {
        return String.format("Find node %s", this.node);
    }

    @Override
    public int compareTo(SearchItem other) {
        int result = 0;
        if (other instanceof PatternNodeSearchItem) {
            result = this.type.compareTo(((PatternNodeSearchItem)other).type);
        }
        if (result == 0) {
            return super.compareTo(other);
        }
        return result;
    }

    @Override
    public SearchItem.Record createRecord(Matcher.Search search) {
        return this.createMultipleRecord(search);
    }

    SearchItem.MultipleRecord<PatternNode> createMultipleRecord(Matcher.Search search) {
        return new PatternNodeMultipleRecord(search, this.nodeIx);
    }

    @Override
    int getRating() {
        return this.type.hashCode();
    }

    @Override
    void activate(Matcher matcher) {
        this.nodeIx = matcher.getNodeIx(this.node);
    }

    public RuleNode getNode() {
        return this.node;
    }

    private TypeNode getType() {
        return this.type;
    }

    private class PatternNodeMultipleRecord
    extends SearchItem.MultipleRecord<PatternNode> {
        final int sourceIx;
        PatternNode selected;

        PatternNodeMultipleRecord(Matcher.Search search, int sourceIx) {
            super(PatternNodeSearchItem.this, search);
            this.sourceIx = sourceIx;
        }

        @Override
        void init() {
            this.imageIter = this.host.nodeSet().iterator();
        }

        @Override
        boolean write(PatternNode image) {
            if (PatternNodeSearchItem.this.getType() != image.getType()) {
                return false;
            }
            boolean result = this.search.putNode(this.sourceIx, image);
            if (result) {
                this.selected = image;
            }
            return result;
        }

        @Override
        void erase() {
            this.search.putNode(this.sourceIx, null);
            this.selected = null;
        }

        public String toString() {
            return String.valueOf(PatternNodeSearchItem.this.toString()) + " = " + this.selected;
        }
    }
}

