/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.Multiplicity;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.PatternRuleGraph;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import java.util.Map;
import java.util.Set;

public final class PreMatch
extends Match {
    public PreMatch(PatternRule pRule, PatternShape pShape) {
        super(pRule, pShape);
    }

    @Override
    public PatternShape getGraph() {
        return (PatternShape)super.getGraph();
    }

    @Override
    public boolean isValid() {
        PatternShape pShape = this.getGraph();
        PatternRuleGraph lhs = this.getRule().lhs();
        for (Map.Entry entry : this.getInverseNodeMap().entrySet()) {
            PatternNode pNode = (PatternNode)entry.getKey();
            Multiplicity nMult = pShape.getMult(pNode);
            Set rNodes = entry.getValue();
            if (Multiplicity.getNodeSetMult(rNodes).le(nMult)) continue;
            return false;
        }
        for (Map.Entry<Object, Set<Object>> entry : this.getInverseEdgeMap().entrySet()) {
            Multiplicity eMult = pShape.getMult((PatternEdge)entry.getKey());
            for (RuleNode rNode : lhs.nodeSet()) {
                int rEdgeCount = 0;
                for (RuleEdge ruleEdge : entry.getValue()) {
                    if (!lhs.outEdgeSet(rNode).contains(ruleEdge)) continue;
                    ++rEdgeCount;
                }
                Multiplicity multiplicity = Multiplicity.approx(rEdgeCount, rEdgeCount, Multiplicity.MultKind.EDGE_MULT);
                if (multiplicity.le(eMult)) continue;
                return false;
            }
        }
        return true;
    }
}

