/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SearchItem
implements Comparable<SearchItem> {
    private boolean relevant = true;

    abstract Record createRecord(Matcher.Search var1);

    abstract int getRating();

    abstract void activate(Matcher var1);

    public Collection<RuleNode> needsNodes() {
        return Collections.emptySet();
    }

    public Collection<RuleNode> bindsNodes() {
        return Collections.emptySet();
    }

    public Collection<RuleEdge> bindsEdges() {
        return Collections.emptySet();
    }

    public final boolean isRelevant() {
        return this.relevant;
    }

    final void setRelevant(boolean relevant) {
        this.relevant = relevant;
    }

    @Override
    public int compareTo(SearchItem other) {
        int result = this.getClass().getName().compareTo(other.getClass().getName());
        if (result == 0) {
            result = this.getRating() - other.getRating();
        }
        return result;
    }

    abstract class BasicRecord
    implements Record {
        final Matcher.Search search;
        PatternGraph host;

        BasicRecord(Matcher.Search search) {
            this.search = search;
        }

        @Override
        public void initialise(PatternGraph host) {
            this.reset();
            this.host = host;
        }

        @Override
        public final boolean isRelevant() {
            return SearchItem.this.isRelevant();
        }
    }

    abstract class MultipleRecord<E>
    extends BasicRecord {
        Iterator<? extends E> imageIter;
        List<E> oldImages;
        int oldImageIndex;
        private State state;

        MultipleRecord(Matcher.Search search) {
            super(search);
            this.oldImages = new ArrayList();
            this.oldImageIndex = 0;
            this.state = State.START;
        }

        @Override
        public final boolean isSingular() {
            return false;
        }

        @Override
        public void initialise(PatternGraph host) {
            this.reset();
            this.host = host;
        }

        @Override
        public final boolean isEmpty() {
            return this.state == State.EMPTY;
        }

        @Override
        public final boolean next() {
            State nextState;
            switch (this.state) {
                case EMPTY: {
                    nextState = State.EMPTY;
                    break;
                }
                case FULL_REPEAT: {
                    int index = this.oldImageIndex;
                    if (index == this.oldImages.size()) {
                        this.erase();
                        nextState = State.FULL_START;
                        break;
                    }
                    this.write(this.oldImages.get(index));
                    this.oldImageIndex = index + 1;
                    nextState = State.FULL_REPEAT;
                    break;
                }
                case FULL_START: {
                    this.write(this.oldImages.get(0));
                    this.oldImageIndex = 1;
                    nextState = State.FULL_REPEAT;
                    break;
                }
                case PART: {
                    E image = this.find();
                    if (image == null) {
                        this.erase();
                        nextState = State.FULL_START;
                        break;
                    }
                    this.oldImages.add(image);
                    nextState = State.PART;
                    break;
                }
                case PART_REPEAT: {
                    int index = this.oldImageIndex;
                    this.write(this.oldImages.get(index));
                    if (index == this.oldImages.size() - 1) {
                        nextState = State.PART;
                        break;
                    }
                    this.oldImageIndex = index + 1;
                    nextState = State.PART_REPEAT;
                    break;
                }
                case PART_START: {
                    this.write(this.oldImages.get(0));
                    if (this.oldImages.size() == 1) {
                        nextState = State.PART;
                        break;
                    }
                    this.oldImageIndex = 1;
                    nextState = State.PART_REPEAT;
                    break;
                }
                case START: {
                    E image = this.find();
                    if (image == null) {
                        nextState = State.EMPTY;
                        break;
                    }
                    this.oldImages.clear();
                    this.oldImages.add(image);
                    nextState = State.PART;
                    break;
                }
                default: {
                    assert (false);
                    nextState = null;
                }
            }
            assert (this.state.getNext().contains((Object)nextState)) : String.format("Illegal transition %s -next-> %s", new Object[]{this.state, nextState});
            this.state = nextState;
            return nextState.isWritten();
        }

        @Override
        public final void repeat() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getRepeat();
        }

        @Override
        public final void reset() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.imageIter = null;
            this.state = this.state.getReset();
        }

        final E find() {
            Object result = null;
            if (this.imageIter == null) {
                this.init();
            }
            while (result == null && this.imageIter.hasNext()) {
                result = this.imageIter.next();
                if (this.write(result)) continue;
                result = null;
            }
            return result;
        }

        abstract void init();

        abstract boolean write(E var1);

        abstract void erase();
    }

    static interface Record {
        public void initialise(PatternGraph var1);

        public boolean isRelevant();

        public boolean isSingular();

        public boolean isEmpty();

        public boolean next();

        public void repeat();

        public void reset();
    }

    abstract class SingularRecord
    extends BasicRecord {
        private State state;

        SingularRecord(Matcher.Search search) {
            super(search);
            this.state = State.START;
        }

        @Override
        public final boolean isSingular() {
            return true;
        }

        @Override
        public final boolean isEmpty() {
            return this.state == State.EMPTY;
        }

        @Override
        public final boolean next() {
            State nextState = null;
            switch (this.state) {
                case START: {
                    nextState = this.find() ? State.FOUND : State.EMPTY;
                    break;
                }
                case FOUND: {
                    this.erase();
                    nextState = State.FULL;
                    break;
                }
                case EMPTY: {
                    nextState = State.EMPTY;
                    break;
                }
                case FULL: {
                    boolean result = this.write();
                    assert (result);
                    nextState = State.FOUND;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (this.state.getNext().contains((Object)nextState)) : String.format("Illegal transition %s -next-> %s", new Object[]{this.state, nextState});
            this.state = nextState;
            return nextState.isWritten();
        }

        @Override
        public final void repeat() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getRepeat();
        }

        @Override
        public final void reset() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getReset();
        }

        abstract boolean find();

        abstract boolean write();

        abstract void erase();

        public String toString() {
            return String.format("%s: %b", SearchItem.this.toString(), this.state.isWritten());
        }
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State START = new State(false);
        public static final /* enum */ State EMPTY = new State(false);
        public static final /* enum */ State FOUND = new State(true);
        public static final /* enum */ State FULL = new State(false);
        public static final /* enum */ State PART = new State(true);
        public static final /* enum */ State PART_START = new State(false);
        public static final /* enum */ State PART_REPEAT = new State(true);
        public static final /* enum */ State FULL_START = new State(false);
        public static final /* enum */ State FULL_REPEAT = new State(true);
        private final boolean written;
        private static final /* synthetic */ State[] ENUM$VALUES;

        static {
            ENUM$VALUES = new State[]{START, EMPTY, FOUND, FULL, PART, PART_START, PART_REPEAT, FULL_START, FULL_REPEAT};
        }

        private State(boolean written) {
            this.written = written;
        }

        public final Set<State> getNext() {
            switch (this) {
                case EMPTY: {
                    return EnumSet.of(EMPTY);
                }
                case FOUND: {
                    return EnumSet.of(FULL);
                }
                case FULL: {
                    return EnumSet.of(FOUND);
                }
                case FULL_REPEAT: {
                    return EnumSet.of(FULL_REPEAT, FULL_START);
                }
                case FULL_START: {
                    return EnumSet.of(FULL_REPEAT);
                }
                case PART: {
                    return EnumSet.of(PART, FULL_START);
                }
                case PART_REPEAT: {
                    return EnumSet.of(PART_REPEAT, PART);
                }
                case PART_START: {
                    return EnumSet.of(PART_REPEAT, PART);
                }
                case START: {
                    return EnumSet.of(EMPTY, FOUND, PART);
                }
            }
            assert (false);
            return null;
        }

        public final State getRepeat() {
            switch (this) {
                case EMPTY: {
                    return EMPTY;
                }
                case FOUND: {
                    return FULL;
                }
                case FULL: {
                    return FULL;
                }
                case FULL_REPEAT: {
                    return FULL_START;
                }
                case FULL_START: {
                    return FULL_START;
                }
                case PART: {
                    return PART_START;
                }
                case PART_REPEAT: {
                    return PART_START;
                }
                case PART_START: {
                    return PART_START;
                }
                case START: {
                    return START;
                }
            }
            assert (false);
            return null;
        }

        public final State getReset() {
            return START;
        }

        public final boolean isWritten() {
            return this.written;
        }

        public static State[] values() {
            State[] stateArray = ENUM$VALUES;
            int n = stateArray.length;
            State[] stateArray2 = new State[n];
            System.arraycopy(ENUM$VALUES, 0, stateArray2, 0, n);
            return stateArray2;
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

