/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.Util;
import groove.abstraction.pattern.lts.MatchResult;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.match.MatcherFactory;
import groove.abstraction.pattern.shape.AbstractPatternGraph;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternFactory;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.SimpleMorphism;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.PatternGraphRuleApplication;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.RuleFactory;
import groove.abstraction.pattern.trans.RuleNode;
import groove.grammar.Rule;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.EdgeComparator;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.NodeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeGraph
extends AbstractPatternGraph<TypeNode, TypeEdge> {
    private static final HostGraph protSimpleGraph = new DefaultHostGraph("protSGraph");
    private final PatternFactory patternFactory = new PatternFactory(this);
    private final RuleFactory ruleFactory = new RuleFactory();
    private final Map<TypeNode, PatternRule> closureRules = new MyHashMap<TypeNode, PatternRule>();
    private boolean fixed = false;

    public TypeGraph(String name) {
        super(name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pattern type graph: " + this.getName() + "\n");
        sb.append("Nodes: " + this.nodeSet() + "\n");
        sb.append("Edges: " + this.edgeSet() + "\n");
        sb.append("\nPatterns (depth = " + this.depth() + "):\n");
        for (TypeNode node : this.nodeSet()) {
            sb.append("  " + node.getPattern().getName() + ": " + node.getPattern().toString() + "\n");
        }
        sb.append("\nMorphisms:\n");
        for (TypeEdge edge : this.edgeSet()) {
            sb.append("  " + edge.getMorphism().toString() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            for (TypeNode node : this.nodeSet()) {
                node.setFixed();
            }
            for (TypeEdge edge : this.edgeSet()) {
                edge.setFixed();
            }
            this.computeLayers();
            assert (this.isWellDefined());
            this.createClosureRules();
            this.getInfo().setFixed();
            this.fixed = true;
        }
        return result;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    @Override
    public TypeNode addNode(int nr) {
        HostGraph pattern = this.newSimpleGraph("t" + nr);
        TypeNode node = new TypeNode(nr, pattern);
        this.addNode(node);
        return node;
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.TYPE;
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof TypeNode;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof TypeEdge;
    }

    @Override
    public boolean addNode(TypeNode node) {
        assert (!this.isFixed()) : "Trying to add " + node + " to unmodifiable graph";
        boolean result = this.graphNodeSet.add(node);
        return result;
    }

    @Override
    public boolean isWellDefined() {
        if (!super.isWellDefined()) {
            return false;
        }
        int layer = 2;
        while (layer <= this.depth()) {
            for (TypeNode node : this.getLayerNodes(layer)) {
                if (this.inEdgeSet(node).size() == 2) continue;
                return false;
            }
            ++layer;
        }
        return true;
    }

    private HostGraph newSimpleGraph(String name) {
        DefaultHostGraph result = new DefaultHostGraph((Graph)protSimpleGraph);
        result.setName(name);
        return result;
    }

    private SimpleMorphism newSimpleMorphism(String name, TypeNode source, TypeNode target) {
        return new SimpleMorphism(name, source, target);
    }

    public TypeEdge addEdge(int nr, TypeNode source, TypeNode target) {
        SimpleMorphism morph = this.newSimpleMorphism("m" + nr, source, target);
        TypeEdge edge = new TypeEdge(nr, source, target, morph);
        this.addEdgeContext(edge);
        return edge;
    }

    private void computeLayers() {
        for (TypeNode node : this.nodeSet()) {
            this.addToLayer(node);
        }
    }

    private PatternNode createPatternNode(PatternGraph pGraph, TypeNode type) {
        return pGraph.getFactory().createNode(type);
    }

    private PatternNode createPatternNode(PatternGraph pGraph, TypeNode type, Collection<PatternNode> used) {
        return pGraph.getFactory().createNode(type, used);
    }

    private PatternEdge createPatternEdge(PatternGraph pGraph, PatternNode source, TypeEdge type, PatternNode target) {
        return pGraph.getFactory().createEdge(source, type, target);
    }

    public PatternGraph lift(Graph graph) {
        PatternGraph result = this.getPatternFactory().newPatternGraph();
        MyHashMap<Node, PatternNode> nodeMap = new MyHashMap<Node, PatternNode>();
        this.lift(graph, result, nodeMap, null);
        this.close(result);
        assert (result.isWellDefined());
        assert (result.isCommuting());
        return result;
    }

    private void lift(Graph graph, PatternGraph result, Map<Node, PatternNode> nodeMap, Map<Edge, PatternNode> edgeMap) {
        for (TypeNode tNode : this.getLayerNodes(0)) {
            Set<TypeLabel> nodeLabels = tNode.getNodeLabels();
            for (Node sNode : this.match(graph, nodeLabels)) {
                PatternNode pNode = nodeMap.get(sNode);
                if (pNode == null) {
                    pNode = this.createPatternNode(result, tNode, nodeMap.values());
                    nodeMap.put(sNode, pNode);
                }
                result.addNode(pNode);
            }
        }
        for (TypeNode tTgt : this.getLayerNodes(1)) {
            HostGraph pattern = tTgt.getPattern();
            HostEdge edge = tTgt.getSimpleEdge();
            Set<TypeLabel> srcLabels = Util.getNodeLabels(pattern, edge.source());
            Set<TypeLabel> tgtLabels = Util.getNodeLabels(pattern, edge.target());
            TypeLabel edgeLabel = edge.label();
            for (Edge sEdge : this.match(graph, srcLabels, edgeLabel, tgtLabels)) {
                PatternNode pTgt;
                if (edgeMap != null) {
                    pTgt = edgeMap.get(sEdge);
                    if (pTgt == null) {
                        pTgt = this.createPatternNode(result, tTgt, edgeMap.values());
                        edgeMap.put(sEdge, pTgt);
                    }
                } else {
                    pTgt = this.createPatternNode(result, tTgt);
                }
                result.addNode(pTgt);
                PatternNode pSrc = nodeMap.get(sEdge.source());
                TypeEdge tEdge = (TypeEdge)this.getCoveringEdge(tTgt, pTgt.getSource());
                PatternEdge pEdge = this.createPatternEdge(result, pSrc, tEdge, pTgt);
                result.addEdgeContext(pEdge);
                if (sEdge.source().equals(sEdge.target())) continue;
                pSrc = nodeMap.get(sEdge.target());
                tEdge = (TypeEdge)this.getCoveringEdge(tTgt, pTgt.getTarget());
                pEdge = this.createPatternEdge(result, pSrc, tEdge, pTgt);
                result.addEdgeContext(pEdge);
            }
        }
    }

    public PatternRule lift(Rule sRule) {
        RuleNode rTgt;
        RuleNode rSrc;
        PatternFactory liftingFactory = new PatternFactory(this);
        PatternGraph liftedLhs = liftingFactory.newPatternGraph();
        PatternGraph liftedRhs = liftingFactory.newPatternGraph();
        MyHashMap<Node, PatternNode> nodeMap = new MyHashMap<Node, PatternNode>();
        MyHashMap<Edge, PatternNode> edgeMap = new MyHashMap<Edge, PatternNode>();
        this.lift(sRule.lhs(), liftedLhs, nodeMap, edgeMap);
        this.close(liftedLhs);
        this.lift(sRule.rhs(), liftedRhs, nodeMap, edgeMap);
        this.close(liftedRhs);
        PatternRule pRule = new PatternRule(sRule, this);
        MyHashMap<PatternNode, Object> ruleMap = new MyHashMap<PatternNode, Object>();
        MyHashMap<PatternNode, RuleNode> auxMap = new MyHashMap<PatternNode, RuleNode>();
        int layer = 0;
        while (layer <= 1) {
            Object rNode;
            for (PatternNode pNode : liftedLhs.getLayerNodes(layer)) {
                rNode = liftedRhs.nodeSet().contains(pNode) ? pRule.addReaderNode(pNode.getType()) : pRule.addEraserNode(pNode.getType());
                ruleMap.put(pNode, rNode);
            }
            for (PatternNode pNode : liftedRhs.getLayerNodes(layer)) {
                if (liftedLhs.nodeSet().contains(pNode)) continue;
                rNode = pRule.addCreatorNode(pNode.getType());
                ruleMap.put(pNode, rNode);
            }
            ++layer;
        }
        int maxLayer = Math.max(liftedLhs.depth(), liftedRhs.depth());
        int layer2 = 2;
        while (layer2 <= maxLayer) {
            RuleNode rNode;
            for (PatternNode lhsNode : liftedLhs.getLayerNodes(layer2)) {
                Set<PatternNode> lhsAncestors = liftedLhs.getEdgeLayerAncestors(lhsNode);
                boolean isEraser = true;
                for (PatternNode rhsNode : liftedRhs.getLayerNodes(layer2)) {
                    Set<PatternNode> rhsAncestors = liftedRhs.getEdgeLayerAncestors(rhsNode);
                    if (!rhsAncestors.containsAll(lhsAncestors) || !lhsAncestors.containsAll(rhsAncestors)) continue;
                    isEraser = false;
                    break;
                }
                rNode = isEraser ? pRule.addEraserNode(lhsNode.getType()) : pRule.addReaderNode(lhsNode.getType());
                ruleMap.put(lhsNode, rNode);
            }
            for (PatternNode rhsNode : liftedRhs.getLayerNodes(layer2)) {
                Set<PatternNode> rhsAncestors = liftedRhs.getEdgeLayerAncestors(rhsNode);
                boolean isCreator = true;
                for (PatternNode lhsNode : liftedLhs.getLayerNodes(layer2)) {
                    Set<PatternNode> lhsAncestors = liftedLhs.getEdgeLayerAncestors(lhsNode);
                    if (!lhsAncestors.containsAll(rhsAncestors) || !rhsAncestors.containsAll(lhsAncestors)) continue;
                    isCreator = false;
                    break;
                }
                if (!isCreator) continue;
                rNode = pRule.addCreatorNode(rhsNode.getType());
                auxMap.put(rhsNode, rNode);
            }
            ++layer2;
        }
        for (PatternEdge pEdge : liftedLhs.edgeSet()) {
            rSrc = (RuleNode)ruleMap.get(pEdge.source());
            rTgt = (RuleNode)ruleMap.get(pEdge.target());
            if (pRule.isEraser(rSrc) || pRule.isEraser(rTgt)) {
                pRule.addEraserEdge(rSrc, pEdge.getType(), rTgt);
                continue;
            }
            pRule.addReaderEdge(rSrc, pEdge.getType(), rTgt);
        }
        for (PatternEdge pEdge : liftedRhs.edgeSet()) {
            rSrc = (RuleNode)auxMap.get(pEdge.source());
            if (rSrc == null) {
                rSrc = (RuleNode)ruleMap.get(pEdge.source());
            }
            if ((rTgt = (RuleNode)auxMap.get(pEdge.target())) == null) {
                rTgt = (RuleNode)ruleMap.get(pEdge.target());
            }
            if (!pRule.isCreator(rSrc) && !pRule.isCreator(rTgt)) continue;
            pRule.addCreatorEdge(rSrc, pEdge.getType(), rTgt);
        }
        return pRule;
    }

    public void close(PatternGraph pGraph) {
        int layer = 2;
        while (layer <= this.depth()) {
            for (TypeNode tNode : this.getLayerNodes(layer)) {
                PatternRule pRule = this.getClosureRule(tNode);
                Matcher matcher = MatcherFactory.instance().getMatcher(pRule, true);
                for (MatchResult matchRes : matcher.findMatches(pGraph, null)) {
                    Match match = matchRes.getMatch();
                    pGraph.prepareClosure(match);
                    PatternGraphRuleApplication app = new PatternGraphRuleApplication(pGraph, match);
                    app.transformWithClosureRule();
                }
            }
            ++layer;
        }
    }

    public PatternFactory getPatternFactory() {
        return this.patternFactory;
    }

    public RuleFactory getRuleFactory() {
        return this.ruleFactory;
    }

    private List<Node> match(Graph graph, Set<TypeLabel> nodeLabels) {
        ArrayList<Node> result = new ArrayList<Node>(graph.nodeSet().size());
        for (Node node : graph.nodeSet()) {
            if (!this.match(graph, node, nodeLabels)) continue;
            result.add(node);
        }
        Collections.sort(result, NodeComparator.instance());
        return result;
    }

    private List<Edge> match(Graph graph, Set<TypeLabel> srcLabels, TypeLabel edgeLabel, Set<TypeLabel> tgtLabels) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge edge : graph.edgeSet(edgeLabel)) {
            if (!srcLabels.isEmpty() && !this.match(graph, edge.source(), srcLabels) || !tgtLabels.isEmpty() && !this.match(graph, edge.target(), tgtLabels)) continue;
            result.add(edge);
        }
        Collections.sort(result, EdgeComparator.instance());
        return result;
    }

    private boolean match(Graph graph, Node node, Set<TypeLabel> nodeLabels) {
        Set<TypeLabel> other = Util.getNodeLabels(graph, node);
        return nodeLabels.containsAll(other) && other.containsAll(nodeLabels);
    }

    private void createClosureRules() {
        int layer = 0;
        while (layer <= this.depth()) {
            for (TypeNode tNode : this.getLayerNodes(layer)) {
                HostGraph pattern = tNode.getPattern();
                PatternRule pRule = new PatternRule(pattern.getName(), this);
                RuleNode rTgt = pRule.addCreatorNode(tNode);
                for (TypeEdge tEdge : this.inEdgeSet(tNode)) {
                    RuleNode rSrc = pRule.addRhsAsReader(this.getClosureRule((TypeNode)tEdge.source()));
                    pRule.addCreatorEdge(rSrc, tEdge, rTgt);
                }
                pRule.fixCommutativity();
                this.closureRules.put(tNode, pRule);
            }
            ++layer;
        }
    }

    private PatternRule getClosureRule(TypeNode tNode) {
        PatternRule result = this.closureRules.get(tNode);
        assert (result != null);
        return result;
    }

    public TypeNode getTypeNodeByNumber(int typeNr) {
        for (TypeNode tNode : this.nodeSet()) {
            if (tNode.getNumber() != typeNr) continue;
            return tNode;
        }
        return null;
    }

    public TypeEdge getTypeEdgeByNumber(int typeNr) {
        for (TypeEdge tEdge : this.edgeSet()) {
            if (tEdge.getNumber() != typeNr) continue;
            return tEdge;
        }
        return null;
    }

    @Override
    public boolean removeNodeContext(TypeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdge(TypeEdge edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNodeSetContext(Collection<? extends TypeNode> nodeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNode(TypeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNodeSet(Collection<? extends TypeNode> nodeSet) {
        throw new UnsupportedOperationException();
    }
}

