/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.trans.PatternRule;
import groove.control.CtrlAut;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import java.util.Map;
import java.util.TreeMap;

public final class PatternGraphGrammar {
    private final Grammar sGrammar;
    private final TypeGraph typeGraph;
    private final String name;
    private final Map<String, PatternRule> nameRuleMap = new TreeMap<String, PatternRule>();
    private PatternGraph startGraph;

    public PatternGraphGrammar(Grammar sGrammar, TypeGraph typeGraph) {
        assert (sGrammar.isFixed());
        this.sGrammar = sGrammar;
        this.typeGraph = typeGraph;
        this.name = sGrammar.getName();
        this.liftStartGraph();
        this.liftRules();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Rule system:\n");
        for (PatternRule pRule : this.nameRuleMap.values()) {
            res.append(pRule + "\n");
        }
        res.append("\nStart graph:\n");
        res.append(this.startGraph.toString());
        return res.toString();
    }

    private void liftStartGraph() {
        this.startGraph = this.typeGraph.lift(this.sGrammar.getStartGraph());
    }

    private void liftRules() {
        for (Rule sRule : this.sGrammar.getAllRules()) {
            PatternRule pRule = this.typeGraph.lift(sRule);
            this.nameRuleMap.put(sRule.getLastName(), pRule);
        }
    }

    public String getName() {
        return this.name;
    }

    public PatternRule getRule(String name) {
        return this.nameRuleMap.get(name);
    }

    public PatternGraph getStartGraph() {
        return this.startGraph;
    }

    public CtrlAut getCtrlAut() {
        return this.sGrammar.getCtrlAut();
    }

    public Grammar getSimpleGrammar() {
        return this.sGrammar;
    }
}

