/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.AlgebraFamily;
import groove.algebra.RealAlgebra;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDoubleAlgebra
extends RealAlgebra<BigDecimal, Boolean, String> {
    public static final double TOLERANCE = 1.0E-30;
    public static final String NAME = "bdouble";
    public static final BigDoubleAlgebra instance = new BigDoubleAlgebra();

    private BigDoubleAlgebra() {
    }

    @Override
    public BigDecimal abs(BigDecimal arg) {
        return arg.abs();
    }

    @Override
    public BigDecimal add(BigDecimal arg0, BigDecimal arg1) {
        return arg0.add(arg1);
    }

    @Override
    public BigDecimal div(BigDecimal arg0, BigDecimal arg1) {
        return arg0.divide(arg1);
    }

    @Override
    public Boolean eq(BigDecimal arg0, BigDecimal arg1) {
        return BigDoubleAlgebra.approximatelyEquals(arg0, arg1);
    }

    @Override
    public Boolean neq(BigDecimal arg0, BigDecimal arg1) {
        return !BigDoubleAlgebra.approximatelyEquals(arg0, arg1);
    }

    @Override
    public Boolean ge(BigDecimal arg0, BigDecimal arg1) {
        if (arg0.subtract(arg1).signum() < 0 && !BigDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean gt(BigDecimal arg0, BigDecimal arg1) {
        if (arg0.subtract(arg1).signum() > 0 && !BigDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean le(BigDecimal arg0, BigDecimal arg1) {
        if (arg0.subtract(arg1).signum() > 0 && !BigDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean lt(BigDecimal arg0, BigDecimal arg1) {
        if (arg0.subtract(arg1).signum() < 0 && !BigDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return true;
        }
        return false;
    }

    @Override
    public BigDecimal max(BigDecimal arg0, BigDecimal arg1) {
        return arg0.max(arg1);
    }

    @Override
    public BigDecimal min(BigDecimal arg0, BigDecimal arg1) {
        return arg0.min(arg1);
    }

    @Override
    public BigDecimal mul(BigDecimal arg0, BigDecimal arg1) {
        return arg0.multiply(arg1);
    }

    @Override
    public BigDecimal neg(BigDecimal arg) {
        return arg.negate();
    }

    @Override
    public BigDecimal sub(BigDecimal arg0, BigDecimal arg1) {
        return arg0.subtract(arg1);
    }

    @Override
    public String toString(BigDecimal arg) {
        return arg.toString();
    }

    @Override
    public BigDecimal getValueFromSymbol(String symbol) {
        return new BigDecimal(symbol, MathContext.DECIMAL128);
    }

    @Override
    protected BigDecimal toValue(Double constant) {
        return BigDecimal.valueOf(constant);
    }

    @Override
    public String getSymbol(Object value) {
        return value.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AlgebraFamily getFamily() {
        return AlgebraFamily.BIG;
    }

    public static boolean approximatelyEquals(BigDecimal d1, BigDecimal d2) {
        return d1.subtract(d2).abs().doubleValue() < (d1.abs().doubleValue() + d2.abs().doubleValue() + 1.0E-30) * 1.0E-30;
    }
}

