/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Precedence;
import groove.algebra.Signature;
import groove.algebra.SignatureKind;
import groove.annotation.InfixSymbol;
import groove.annotation.PrefixSymbol;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import java.math.BigDecimal;

public abstract class RealSignature<Real, Bool, String>
implements Signature {
    @Syntax(value="Q%s.LPAR.i.RPAR")
    @ToolTipHeader(value="Absolute value")
    @ToolTipBody(value={"Returns the absolute value of %s"})
    public abstract Real abs(Real var1);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number addition")
    @ToolTipBody(value={"Returns the sum of %s and %s"})
    @InfixSymbol(symbol="+", precedence=Precedence.ADD)
    public abstract Real add(Real var1, Real var2);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number subtraction")
    @ToolTipBody(value={"Returns the difference between %s and %s"})
    @InfixSymbol(symbol="-", precedence=Precedence.ADD)
    public abstract Real sub(Real var1, Real var2);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number multiplication")
    @ToolTipBody(value={"Returns the product of %s and %s"})
    @InfixSymbol(symbol="*", precedence=Precedence.MULT)
    public abstract Real mul(Real var1, Real var2);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number division")
    @ToolTipBody(value={"Returns the quotient of %s and %s"})
    @InfixSymbol(symbol="/", precedence=Precedence.MULT)
    public abstract Real div(Real var1, Real var2);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number minimum")
    @ToolTipBody(value={"Returns the minimum of %s and %s"})
    public abstract Real min(Real var1, Real var2);

    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipHeader(value="Real number minimum")
    @ToolTipBody(value={"Returns the maximum of %s and %s"})
    public abstract Real max(Real var1, Real var2);

    @ToolTipHeader(value="Real number lesser-than test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %s is properly smaller than real number %s"})
    @InfixSymbol(symbol="<", precedence=Precedence.COMPARE)
    public abstract Bool lt(Real var1, Real var2);

    @ToolTipHeader(value="Real number lesser-or-equal test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %s is smaller than real number %s"})
    @InfixSymbol(symbol="<=", precedence=Precedence.COMPARE)
    public abstract Bool le(Real var1, Real var2);

    @ToolTipHeader(value="Real number greater-than test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %2$s is properly larger than real number %1$s"})
    @InfixSymbol(symbol=">", precedence=Precedence.COMPARE)
    public abstract Bool gt(Real var1, Real var2);

    @ToolTipHeader(value="Real number greater-or-equal test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %s is larger than real number %s"})
    @InfixSymbol(symbol=">=", precedence=Precedence.COMPARE)
    public abstract Bool ge(Real var1, Real var2);

    @ToolTipHeader(value="Real number equality test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %s equals real number %s"})
    @InfixSymbol(symbol="==", precedence=Precedence.EQUAL)
    public abstract Bool eq(Real var1, Real var2);

    @ToolTipHeader(value="Real number equality test")
    @Syntax(value="Q%s.LPAR.r1.COMMA.r2.RPAR")
    @ToolTipBody(value={"Yields TRUE if real number %s does not equal real number %s"})
    @InfixSymbol(symbol="!=", precedence=Precedence.EQUAL)
    public abstract Bool neq(Real var1, Real var2);

    @ToolTipHeader(value="Real inversion")
    @Syntax(value="Q%s.LPAR.r1.RPAR")
    @ToolTipBody(value={"Yields the inverse of %s"})
    @PrefixSymbol(symbol="-")
    public abstract Real neg(Real var1);

    @ToolTipHeader(value="Real-to-string conversion")
    @Syntax(value="Q%s.LPAR.r1.RPAR")
    @ToolTipBody(value={"Yields a string representation of %s"})
    public abstract String toString(Real var1);

    @Override
    public SignatureKind getKind() {
        return SignatureKind.REAL;
    }

    @Override
    public final boolean isValue(String value) {
        try {
            new BigDecimal(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public final Real getValueFromJava(Object constant) {
        if (!(constant instanceof Double)) {
            throw new IllegalArgumentException(String.format("Native int type is %s, not %s", Double.class.getSimpleName(), constant.getClass().getSimpleName()));
        }
        return this.toValue((Double)constant);
    }

    protected abstract Real toValue(Double var1);
}

