/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SignatureKind {
    BOOL("bool", "true"),
    INT("int", "0"),
    REAL("real", "0.0"),
    STRING("string", "\"\"");

    private final String name;
    private final String defaultValue;
    private static Map<String, SignatureKind> sigKindMap;

    static {
        sigKindMap = new HashMap<String, SignatureKind>();
        SignatureKind[] signatureKindArray = SignatureKind.values();
        int n = signatureKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignatureKind kind = signatureKindArray[n2];
            sigKindMap.put(kind.getName(), kind);
            ++n2;
        }
    }

    private SignatureKind(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public final String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.getName();
    }

    public static SignatureKind getKind(String sigName) {
        return sigKindMap.get(sigName);
    }

    public static Set<String> getNames() {
        return Collections.unmodifiableSet(sigKindMap.keySet());
    }
}

