/*
 * Decompiled with CFR 0.152.
 */
package groove.annotation;

import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import groove.annotation.ToolTipPars;
import groove.io.HTMLConverter;
import groove.util.Pair;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Help {
    private final Map<String, String> tokenMap;
    private final StringBuilder body = new StringBuilder();
    private String syntax;
    private String header;
    private final List<String> parNames = new ArrayList<String>();
    private final List<String> parDocs = new ArrayList<String>();
    private static HTMLConverter.HTMLTag DIV_TAG = HTMLConverter.createDivTag("width: 250px;");
    private static final HTMLConverter.HTMLTag TABLE_TAG = HTMLConverter.createHtmlTag("table", "cellpadding", "0");
    private static final HTMLConverter.HTMLTag SOURCE_TAG = HTMLConverter.createHtmlTag("font", "color", "green");

    public Help(Map<String, String> tokenMap) {
        this.tokenMap = tokenMap;
    }

    public Help() {
        this.tokenMap = null;
    }

    public void setSyntax(String syntax) {
        this.setSyntax(syntax, this.isFormatSyntax());
    }

    public void setSyntax(String syntax, boolean parse) {
        if (parse) {
            Pair<String, List<String>> parsed = Help.processTokensAndArgs(syntax, this.tokenMap);
            this.syntax = Help.html(parsed.one());
            for (String parName : parsed.two()) {
                this.parNames.add(Help.it(parName));
            }
        } else {
            this.syntax = Help.html(syntax);
        }
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void addBody(String text) {
        if (this.body.length() > 0) {
            this.body.append(' ');
        }
        this.body.append(text);
    }

    public void setBody(String ... text) {
        this.setBody(Arrays.asList(text));
    }

    public void setBody(List<String> text) {
        if (this.body.length() > 0) {
            throw new IllegalStateException(String.format("Tool tip body already set to %s", this.body));
        }
        for (String line : text) {
            this.addBody(line);
        }
    }

    public void setParNames(List<String> names) {
        for (String name : names) {
            this.parNames.add(Help.it(name));
        }
    }

    public void setPars(String[] parDocs) {
        this.setPars(Arrays.asList(parDocs));
    }

    public void setPars(List<String> parDocs) {
        this.parDocs.addAll(parDocs);
    }

    public void addPar(String parDoc) {
        if (!this.isFormatSyntax()) {
            throw new IllegalStateException(String.format("Parameter name for %s must be provided", parDoc));
        }
        this.parDocs.add(parDoc);
    }

    public String getItem() {
        if (this.syntax == null) {
            throw new IllegalStateException("Syntax of item is not set.");
        }
        return this.syntax;
    }

    public String getTip() {
        StringBuilder result = new StringBuilder();
        if (this.header != null) {
            result.append(Help.bf(this.header));
            result.append(HTMLConverter.HTML_LINEBREAK);
        }
        if (this.body.length() > 0) {
            result.append(DIV_TAG.on(this.format(this.body.toString())));
        }
        if (!this.parDocs.isEmpty()) {
            if (this.parNames.size() != this.parDocs.size()) {
                throw new IllegalStateException(String.format("Parameter count error: %s documentation lines for %s parameters", this.parDocs.size(), this.parNames.size()));
            }
            StringBuilder paramText = new StringBuilder();
            int p = 0;
            while (p < this.parNames.size()) {
                paramText.append("<tr><th align=\"right\">");
                paramText.append(Help.bf(this.parNames.get(p)));
                paramText.append("<td width=\"5\"><td> - ");
                paramText.append(this.format(this.parDocs.get(p)));
                ++p;
            }
            result.append(HTMLConverter.HTML_LINEBREAK);
            result.append((CharSequence)TABLE_TAG.on(paramText));
        }
        return result.length() == 0 ? null : HTMLConverter.HTML_TAG.on(result).toString();
    }

    private boolean isFormatSyntax() {
        return this.tokenMap != null;
    }

    private String format(String text) {
        if (this.isFormatSyntax()) {
            text = Help.processTokens(text, this.tokenMap);
        }
        try {
            return String.format(text, this.parNames.toArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String toString() {
        return "Help [syntax=" + this.syntax + ", header=" + this.header + ", body=" + this.body + ", parDocs=" + this.parDocs + "]";
    }

    public static Help createHelp(Class<?> source, Map<String, String> tokenMap) {
        Syntax syntax = source.getAnnotation(Syntax.class);
        ToolTipHeader header = source.getAnnotation(ToolTipHeader.class);
        ToolTipBody body = source.getAnnotation(ToolTipBody.class);
        ToolTipPars pars = source.getAnnotation(ToolTipPars.class);
        return Help.createHelp(source, syntax, header, body, pars, tokenMap);
    }

    public static Help createHelp(AccessibleObject source, Map<String, String> tokenMap) {
        Syntax syntax = source.getAnnotation(Syntax.class);
        ToolTipHeader header = source.getAnnotation(ToolTipHeader.class);
        ToolTipBody body = source.getAnnotation(ToolTipBody.class);
        ToolTipPars pars = source.getAnnotation(ToolTipPars.class);
        return Help.createHelp(source, syntax, header, body, pars, tokenMap);
    }

    private static Help createHelp(Object source, Syntax syntax, ToolTipHeader header, ToolTipBody body, ToolTipPars pars, Map<String, String> tokenMap) {
        Help result = null;
        if (syntax != null) {
            result = new Help(tokenMap);
            String syntaxText = String.format(syntax.value(), Help.getReflectionName(source), Help.getContextName(source));
            result.setSyntax(syntaxText);
            if (header != null) {
                result.setHeader(header.value());
            }
            if (body != null) {
                result.setBody(body.value());
            }
            if (pars != null) {
                result.setPars(pars.value());
            }
        }
        return result;
    }

    private static String getReflectionName(Object object) {
        String result = null;
        if (object instanceof Class) {
            result = ((Class)object).getSimpleName();
        } else if (object instanceof Field) {
            result = ((Field)object).getName();
        } else if (object instanceof Method) {
            result = ((Method)object).getName();
        }
        return result;
    }

    private static String getContextName(Object object) {
        String result = null;
        if (object instanceof Field) {
            result = ((Field)object).getDeclaringClass().getSimpleName();
        } else if (object instanceof Method) {
            result = ((Method)object).getDeclaringClass().getSimpleName();
        }
        return result;
    }

    public static StringBuilder bf(StringBuilder text) {
        return HTMLConverter.STRONG_TAG.on(text);
    }

    public static String bf(String text) {
        return HTMLConverter.STRONG_TAG.on(text);
    }

    public static String bf(Object text) {
        return HTMLConverter.STRONG_TAG.on(text);
    }

    public static StringBuilder it(StringBuilder text) {
        return HTMLConverter.ITALIC_TAG.on(text);
    }

    public static String it(String text) {
        return HTMLConverter.ITALIC_TAG.on(text);
    }

    public static String it(Object text) {
        return HTMLConverter.ITALIC_TAG.on(text);
    }

    public static String source(String text) {
        return SOURCE_TAG.on(text);
    }

    public static String html(String text) {
        return HTMLConverter.HTML_TAG.on(text);
    }

    private static String processTokens(String text, Map<String, String> tokenMap) {
        return Help.processTokensAndArgs(text, tokenMap, false).one();
    }

    private static Pair<String, List<String>> processTokensAndArgs(String text, Map<String, String> tokenMap) {
        return Help.processTokensAndArgs(text, tokenMap, true);
    }

    private static Pair<String, List<String>> processTokensAndArgs(String text, Map<String, String> tokenMap, boolean getArgs) {
        StringBuilder result = new StringBuilder(text);
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < result.length()) {
            char first = result.charAt(i);
            if (getArgs && first == '.') {
                result.replace(i, i + 1, "");
                --i;
            } else if (Character.isJavaIdentifierStart(first)) {
                int start = i;
                int end = i + 1;
                while (end < result.length() && Character.isJavaIdentifierPart(result.charAt(end))) {
                    ++end;
                }
                String id = result.substring(start, end);
                String token = tokenMap.get(id);
                if (token != null) {
                    id = Help.source(Help.bf(token));
                } else if (getArgs) {
                    id = Help.source(Help.it(id));
                    args.add(id);
                }
                result.replace(start, end, id);
                i += id.length() - 1;
            }
            ++i;
        }
        return Pair.newPair(result.toString(), args);
    }
}

