/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.Direction;
import groove.automaton.RegAut;
import groove.automaton.RegEdge;
import groove.automaton.RegExpr;
import groove.automaton.RegFactory;
import groove.automaton.RegNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.Valuation;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Element;
import groove.graph.ElementFactory;
import groove.graph.NodeSetEdgeSetGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MatrixAutomaton
extends NodeSetEdgeSetGraph<RegNode, RegEdge>
implements RegAut {
    private RegNode start;
    private RegNode end;
    private boolean acceptsEmptyWord;
    private final TypeGraph typeGraph;
    private Map<Direction, Map<TypeLabel, int[]>[]> nodePosLabelEdgeIndicesMap;
    private Map<Direction, Map<TypeLabel, int[]>[]> nodeInvLabelEdgeIndicesMap;
    private TypeLabel[] initPosLabels;
    private TypeLabel[] initInvLabels;
    private boolean initWildcard;
    private BitSet cyclicNodes;
    private Map<RegNode, Integer> nodeIndexMap;
    private RegNode[] nodes;
    private Map<RegEdge, Integer> edgeIndexMap;
    private int[] sources;
    private int[] targets;
    private RuleLabel[] labels;
    private Set<LabelVar> allVarSet;
    private int endNodeIndex = -1;
    private Map<Direction, MatchingAlgorithm> algorithm;
    private static final String DUMMY_LABEL_TEXT = "\u0000";
    private static final Map<EdgeRole, TypeLabel> DUMMY_LABELS = new EnumMap<EdgeRole, TypeLabel>(EdgeRole.class);
    public static final MatrixAutomaton PROTOTYPE;

    static {
        EdgeRole[] edgeRoleArray = EdgeRole.values();
        int n = edgeRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeRole kind = edgeRoleArray[n2];
            DUMMY_LABELS.put(kind, TypeLabel.createLabel(kind, DUMMY_LABEL_TEXT));
            ++n2;
        }
        PROTOTYPE = new MatrixAutomaton();
    }

    private MatrixAutomaton() {
        super("prototype");
        this.start = null;
        this.end = null;
        this.typeGraph = null;
    }

    private MatrixAutomaton(RegNode start, RegNode end, TypeGraph typeGraph) {
        super("automaton");
        this.start = start;
        this.end = end;
        this.addNode(start);
        this.addNode(end);
        this.typeGraph = typeGraph;
        assert (typeGraph != null);
    }

    @Override
    public RegAut newAutomaton(RegNode start, RegNode end, TypeGraph typeGraph) {
        return new MatrixAutomaton(start, end, typeGraph);
    }

    @Override
    public RegNode addNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegNode getStartNode() {
        return this.start;
    }

    @Override
    public RegNode getEndNode() {
        return this.end;
    }

    @Override
    public boolean isAcceptsEmptyWord() {
        return this.acceptsEmptyWord;
    }

    @Override
    public void setAcceptsEmptyWord(boolean acceptsEmptyWord) {
        this.acceptsEmptyWord = acceptsEmptyWord;
    }

    @Override
    public void setEndNode(RegNode endNode) {
        this.end = endNode;
    }

    @Override
    public void setStartNode(RegNode startNode) {
        this.start = startNode;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("\nStart node: " + this.getStartNode());
        result.append("\nEnd node: " + this.getEndNode());
        result.append("\nAccepts empty word: " + this.isAcceptsEmptyWord());
        return result.toString();
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result) {
            this.initNodeEdgeIndices();
            this.initNodeLabelEdgeMaps();
            this.initVarSets();
        }
        return result;
    }

    @Override
    public ElementFactory<RegNode, RegEdge> getFactory() {
        return RegFactory.instance();
    }

    private void initNodeEdgeIndices() {
        this.nodeIndexMap = new HashMap<RegNode, Integer>();
        this.edgeIndexMap = new HashMap<RegEdge, Integer>();
        HashSet<RegNode> cyclicNodeSet = new HashSet<RegNode>();
        this.cyclicNodes = new BitSet(this.nodeCount());
        ArrayList<RegNode> nodeList = new ArrayList<RegNode>();
        nodeList.add(this.getStartNode());
        HashSet<RegNode> visitedNodes = new HashSet<RegNode>();
        ArrayList<RegNode> sourceList = new ArrayList<RegNode>();
        ArrayList<RegNode> targetList = new ArrayList<RegNode>();
        ArrayList<RuleLabel> labelList = new ArrayList<RuleLabel>();
        int nodeIndex = 0;
        int edgeIndex = 0;
        while (nodeIndex < nodeList.size()) {
            RegNode node = (RegNode)nodeList.get(nodeIndex);
            this.nodeIndexMap.put(node, nodeIndex);
            ++nodeIndex;
            for (RegEdge outEdge : this.outEdgeSet(node)) {
                RegNode target = (RegNode)outEdge.target();
                if (visitedNodes.add(target)) {
                    nodeList.add(target);
                } else {
                    cyclicNodeSet.add(target);
                }
                this.edgeIndexMap.put(outEdge, edgeIndex);
                ++edgeIndex;
                sourceList.add((RegNode)outEdge.source());
                targetList.add((RegNode)outEdge.target());
                labelList.add((RuleLabel)outEdge.label());
            }
        }
        this.nodes = new RegNode[nodeList.size()];
        nodeList.toArray(this.nodes);
        this.cyclicNodes = new BitSet(nodeIndex);
        for (RegNode cyclicNode : cyclicNodeSet) {
            this.cyclicNodes.set(this.getIndex(cyclicNode));
        }
        this.sources = this.toIntArray(sourceList);
        this.targets = this.toIntArray(targetList);
        this.labels = new RuleLabel[labelList.size()];
        labelList.toArray(this.labels);
    }

    private void initNodeLabelEdgeMaps() {
        HashSet initPosLabelSet = new HashSet();
        HashSet<TypeLabel> initInvLabelSet = new HashSet<TypeLabel>();
        int indexedNodeCount = this.nodes.length;
        EnumMap<Direction, Map[]> nodeInvLabelEdgeMap = new EnumMap<Direction, Map[]>(Direction.class);
        EnumMap<Direction, Map[]> nodePosLabelEdgeMap = new EnumMap<Direction, Map[]>(Direction.class);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            nodeInvLabelEdgeMap.put(dir, new Map[indexedNodeCount]);
            nodePosLabelEdgeMap.put(dir, new Map[indexedNodeCount]);
            ++n2;
        }
        for (RegEdge edge : this.edgeIndexMap.keySet()) {
            RuleLabel label = (RuleLabel)edge.label();
            boolean isInverse = label.isInv();
            if (isInverse) {
                label = label.getInvLabel();
            }
            HashSet<TypeLabel> derivedLabels = new HashSet<TypeLabel>();
            for (TypeElement element : this.typeGraph.getMatches(label)) {
                derivedLabels.add(element.label());
            }
            if (label.isWildcard()) {
                derivedLabels.add(DUMMY_LABELS.get((Object)label.getWildcardGuard().getKind()));
            }
            EnumMap<Direction, Map[]> nodeLabelEdgeMap = isInverse ? nodeInvLabelEdgeMap : nodePosLabelEdgeMap;
            for (TypeLabel derivedLabel : derivedLabels) {
                Direction[] directionArray2 = Direction.values();
                int n3 = directionArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Direction direction = directionArray2[n4];
                    this.addToNodeLabelEdgeSetMap((Map[])nodeLabelEdgeMap.get((Object)direction), (RegNode)direction.origin(edge), derivedLabel, edge);
                    ++n4;
                }
                if (edge.source() != this.getStartNode()) continue;
                (isInverse ? initInvLabelSet : initPosLabelSet).add(derivedLabel);
            }
        }
        this.initPosLabels = new TypeLabel[initPosLabelSet.size()];
        initPosLabelSet.toArray(this.initPosLabels);
        this.initInvLabels = new TypeLabel[initInvLabelSet.size()];
        initInvLabelSet.toArray(this.initInvLabels);
        this.nodePosLabelEdgeIndicesMap = new EnumMap<Direction, Map<TypeLabel, int[]>[]>(Direction.class);
        this.nodeInvLabelEdgeIndicesMap = new EnumMap<Direction, Map<TypeLabel, int[]>[]>(Direction.class);
        directionArray = Direction.values();
        n = directionArray.length;
        int n5 = 0;
        while (n5 < n) {
            Direction direction = directionArray[n5];
            Map[] posLabelEdgeIndices = new Map[indexedNodeCount];
            Map[] invLabelEdgeIndices = new Map[indexedNodeCount];
            int nodeIndex = 0;
            while (nodeIndex < indexedNodeCount) {
                posLabelEdgeIndices[nodeIndex] = this.toIntArrayMap(((Map[])nodePosLabelEdgeMap.get((Object)direction))[nodeIndex]);
                invLabelEdgeIndices[nodeIndex] = this.toIntArrayMap(((Map[])nodeInvLabelEdgeMap.get((Object)direction))[nodeIndex]);
                ++nodeIndex;
            }
            this.nodePosLabelEdgeIndicesMap.put(direction, posLabelEdgeIndices);
            this.nodeInvLabelEdgeIndicesMap.put(direction, invLabelEdgeIndices);
            ++n5;
        }
        this.initPosLabels = new TypeLabel[initPosLabelSet.size()];
        initPosLabelSet.toArray(this.initPosLabels);
    }

    private void initVarSets() {
        HashSet<RegNode> remainingNodes = new HashSet<RegNode>();
        remainingNodes.add(this.getStartNode());
        HashMap allVarMap = new HashMap();
        allVarMap.put(this.getStartNode(), new HashSet());
        while (!remainingNodes.isEmpty()) {
            RegNode source = (RegNode)remainingNodes.iterator().next();
            remainingNodes.remove(source);
            Set sourceAllVarSet = (Set)allVarMap.get(source);
            for (RegEdge outEdge : this.outEdgeSet(source)) {
                RegNode target = (RegNode)outEdge.target();
                HashSet<LabelVar> targetAllVarSet = new HashSet<LabelVar>(sourceAllVarSet);
                RegExpr expr = ((RuleLabel)outEdge.label()).getMatchExpr();
                targetAllVarSet.addAll(expr.allVarSet());
                if (allVarMap.containsKey(target)) {
                    ((Set)allVarMap.get(target)).addAll(targetAllVarSet);
                    continue;
                }
                remainingNodes.add(target);
                allVarMap.put(target, targetAllVarSet);
            }
        }
        this.allVarSet = (Set)allVarMap.get(this.getEndNode());
        if (this.allVarSet == null) {
            this.allVarSet = Collections.emptySet();
        }
    }

    @Override
    public boolean accepts(List<String> word) {
        assert (this.isFixed());
        assert (this.typeGraph.isImplicit());
        if (word.isEmpty()) {
            return this.isAcceptsEmptyWord();
        }
        Map matchSet = Collections.singletonMap(this.getStartNode(), new HashMap());
        boolean accepts = false;
        int index = 0;
        while (!accepts && !matchSet.isEmpty() && index < word.size()) {
            boolean lastIndex = index == word.size() - 1;
            TypeEdge letter = this.getLetter(word.get(index));
            HashMap<RegNode, HashMap<RegNode, HashMap<LabelVar, TypeEdge>>> newMatchSet = new HashMap<RegNode, HashMap<RegNode, HashMap<LabelVar, TypeEdge>>>();
            Iterator matchIter = matchSet.entrySet().iterator();
            while (!accepts && matchIter.hasNext()) {
                Map.Entry matchEntry = matchIter.next();
                RegNode match = matchEntry.getKey();
                HashMap<LabelVar, TypeEdge> idMap = matchEntry.getValue();
                Iterator outEdgeIter = this.outEdgeSet(match).iterator();
                while (!accepts && outEdgeIter.hasNext()) {
                    boolean labelOK;
                    RegEdge outEdge = (RegEdge)outEdgeIter.next();
                    RuleLabel label = (RuleLabel)outEdge.label();
                    if (label.isInv()) {
                        labelOK = false;
                    } else if (label.isWildcard()) {
                        TypeGuard guard = label.getWildcardGuard();
                        labelOK = guard.isSatisfied(letter);
                        if (guard.isNamed()) {
                            TypeElement oldIdValue = (idMap = new HashMap(idMap)).put(guard.getVar(), letter);
                            labelOK = oldIdValue == null || oldIdValue.equals(letter);
                        }
                    } else {
                        labelOK = label.getTypeLabel().equals(letter.label());
                    }
                    if (!labelOK) continue;
                    if (lastIndex) {
                        accepts = ((RegNode)outEdge.target()).equals(this.getEndNode());
                        continue;
                    }
                    newMatchSet.put((RegNode)outEdge.target(), idMap);
                }
            }
            matchSet = newMatchSet;
            ++index;
        }
        return accepts;
    }

    private TypeEdge getLetter(String text) {
        TypeEdge result = null;
        TypeLabel label = TypeLabel.createLabel(text);
        Set letters = this.typeGraph.edgeSet(label);
        if (letters != null) {
            for (TypeEdge e : letters) {
                if (e.target() != e.source()) continue;
                result = e;
                break;
            }
        }
        return result;
    }

    @Override
    public Set<RegAut.Result> getMatches(HostGraph graph, HostNode startImage, HostNode endImage, Valuation valuation) {
        assert (this.isFixed());
        if (valuation == null) {
            valuation = Valuation.EMPTY;
        }
        if (startImage != null) {
            return this.getMatchingAlgorithm(Direction.FORWARD).computeMatches(graph, startImage, endImage, valuation);
        }
        if (endImage != null) {
            return this.getMatchingAlgorithm(Direction.BACKWARD).computeMatches(graph, endImage, null, valuation);
        }
        return this.getMatchingAlgorithm(Direction.FORWARD).computeMatches(graph, null, null, valuation);
    }

    @Override
    public Set<RegAut.Result> getMatches(HostGraph graph, HostNode startImage, HostNode endImage) {
        return this.getMatches(graph, startImage, endImage, null);
    }

    boolean hasVars() {
        assert (this.isFixed());
        return !this.allVarSet.isEmpty();
    }

    @Override
    public Set<TypeElement> getAlphabet() {
        assert (this.isFixed());
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (RegEdge edge : this.edgeSet()) {
            result.addAll(this.typeGraph.getMatches((RuleLabel)edge.label()));
        }
        return result;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        boolean result;
        boolean bl = result = edge instanceof RegEdge && edge.label() instanceof RuleLabel;
        if (result) {
            RuleLabel edgeLabel = (RuleLabel)edge.label();
            if (edgeLabel.isInv()) {
                edgeLabel = edgeLabel.getInvLabel();
            }
            result = edgeLabel.isWildcard() || edgeLabel.isSharp() || edgeLabel.isAtom();
        }
        return result;
    }

    final MatchingAlgorithm getMatchingAlgorithm(Direction direction) {
        if (this.algorithm == null) {
            this.algorithm = new EnumMap<Direction, MatchingAlgorithm>(Direction.class);
            this.algorithm.put(Direction.FORWARD, this.createMatchingAlgorithm(Direction.FORWARD));
            this.algorithm.put(Direction.BACKWARD, this.createMatchingAlgorithm(Direction.BACKWARD));
        }
        return this.algorithm.get((Object)direction);
    }

    final MatchingAlgorithm createMatchingAlgorithm(Direction direction) {
        return new MatchingAlgorithm(direction);
    }

    final Map<TypeLabel, int[]>[] getNodePosLabelEdgeMap(Direction direction) {
        return this.nodePosLabelEdgeIndicesMap.get((Object)direction);
    }

    final Map<TypeLabel, int[]>[] getNodeInvLabelEdgeMap(Direction direction) {
        return this.nodeInvLabelEdgeIndicesMap.get((Object)direction);
    }

    final TypeLabel[] getInitPosLabels() {
        return this.initPosLabels;
    }

    final TypeLabel[] getInitInvLabels() {
        return this.initInvLabels;
    }

    final boolean isInitWildcard() {
        return this.initWildcard;
    }

    final boolean isCyclic(int nodeIndex) {
        return this.cyclicNodes.get(nodeIndex);
    }

    final void addToNodeLabelEdgeSetMap(Map<TypeLabel, Set<RegEdge>>[] nodeLabelEdgeSetMap, RegNode node, TypeLabel label, RegEdge edge) {
        Set<RegEdge> edgeSet;
        Map<TypeLabel, Set<RegEdge>> labelEdgeMap = nodeLabelEdgeSetMap[this.getIndex(node)];
        if (labelEdgeMap == null) {
            nodeLabelEdgeSetMap[this.getIndex((RegNode)node)] = labelEdgeMap = new HashMap<TypeLabel, Set<RegEdge>>();
        }
        if ((edgeSet = labelEdgeMap.get(label)) == null) {
            edgeSet = new HashSet<RegEdge>();
            labelEdgeMap.put(label, edgeSet);
        }
        edgeSet.add(edge);
    }

    final int getIndex(RegNode node) {
        Integer result = this.nodeIndexMap.get(node);
        if (result != null) {
            return result;
        }
        return -1;
    }

    final int getIndex(RegEdge edge) {
        Integer result = this.edgeIndexMap.get(edge);
        if (result != null) {
            return result;
        }
        return -1;
    }

    final int indexedNodeCount() {
        return this.nodes.length;
    }

    final int getStartNodeIndex() {
        return 0;
    }

    final int getSource(int edgeIndex) {
        return this.sources[edgeIndex];
    }

    final int getTarget(int edgeIndex) {
        return this.targets[edgeIndex];
    }

    final RuleLabel getLabel(int edgeIndex) {
        return this.labels[edgeIndex];
    }

    final int getEndNodeIndex() {
        if (this.endNodeIndex < 0) {
            this.endNodeIndex = this.getIndex(this.getEndNode());
        }
        return this.endNodeIndex;
    }

    final Map<TypeLabel, int[]> toIntArrayMap(Map<TypeLabel, ? extends Collection<? extends Element>> labelSetMap) {
        if (labelSetMap != null) {
            HashMap<TypeLabel, int[]> result = new HashMap<TypeLabel, int[]>();
            for (Map.Entry<TypeLabel, ? extends Collection<? extends Element>> entry : labelSetMap.entrySet()) {
                result.put(entry.getKey(), this.toIntArray(entry.getValue()));
            }
            return result;
        }
        return null;
    }

    final int[] toIntArray(Collection<? extends Element> elementSet) {
        int[] result = new int[elementSet.size()];
        int i = 0;
        for (Element element : elementSet) {
            result[i] = element instanceof RegNode ? this.getIndex((RegNode)element) : this.getIndex((RegEdge)element);
            ++i;
        }
        return result;
    }

    @Override
    public final TypeGraph getTypeGraph() {
        return this.typeGraph;
    }

    private class MatchingAlgorithm {
        final MatchingComputation MATCH_DUMMY = new MatchingComputation(0, null, null);
        final int startIndex;
        final int endIndex;
        final Map<TypeLabel, int[]>[] nodePosLabelEdgeMap;
        final Map<TypeLabel, int[]>[] nodeInvLabelEdgeMap;
        final Direction direction;
        transient HostGraph graph;
        transient Set<? extends HostNode> endImages;
        transient int remainingImageCount;
        transient Set<RegAut.Result> result;
        transient boolean storeIntermediates;
        final Map<HostNode, MatchingComputation>[] auxResults;

        public MatchingAlgorithm(Direction direction) {
            this.auxResults = new Map[MatrixAutomaton.this.indexedNodeCount()];
            switch (direction) {
                case FORWARD: {
                    this.startIndex = MatrixAutomaton.this.getStartNodeIndex();
                    this.endIndex = MatrixAutomaton.this.getEndNodeIndex();
                    break;
                }
                case BACKWARD: {
                    this.startIndex = MatrixAutomaton.this.getEndNodeIndex();
                    this.endIndex = MatrixAutomaton.this.getStartNodeIndex();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal matching direction value" + (Object)((Object)direction));
                }
            }
            this.nodePosLabelEdgeMap = MatrixAutomaton.this.getNodePosLabelEdgeMap(direction);
            this.nodeInvLabelEdgeMap = MatrixAutomaton.this.getNodeInvLabelEdgeMap(direction);
            this.direction = direction;
        }

        public Set<RegAut.Result> computeMatches(HostGraph graph, HostNode startImage, HostNode endImage, Valuation valuation) {
            if (graph != this.graph) {
                this.cleanOldMatches();
                this.graph = graph;
            }
            this.endImages = endImage == null ? graph.nodeSet() : Collections.singleton(endImage);
            this.storeIntermediates = !MatrixAutomaton.this.hasVars();
            this.result = new HashSet<RegAut.Result>();
            Set<Object> startImages = startImage == null ? graph.nodeSet() : Collections.singleton(startImage);
            for (HostNode hostNode : startImages) {
                if (MatrixAutomaton.this.isAcceptsEmptyWord() && this.isAllowedResult(hostNode)) {
                    this.result.add(new RegAut.Result(hostNode, hostNode));
                }
                Map<HostNode, Set<Valuation>> resultMap = new MatchingComputation(this.startIndex, hostNode, valuation).start();
                for (Map.Entry<HostNode, Set<Valuation>> resultEntry : resultMap.entrySet()) {
                    HostNode resultKey = resultEntry.getKey();
                    if (!this.isAllowedResult(resultKey)) continue;
                    if (MatrixAutomaton.this.hasVars()) {
                        this.addRelated(hostNode, resultKey);
                        continue;
                    }
                    this.addRelated(hostNode, resultKey);
                }
            }
            Set<RegAut.Result> set = this.result;
            this.result = null;
            return set;
        }

        protected Map<TypeLabel, int[]> getPosLabelEdgeMap(int nodeIndex) {
            return this.nodePosLabelEdgeMap[nodeIndex];
        }

        protected Map<TypeLabel, int[]> getInvLabelEdgeMap(int nodeIndex) {
            return this.nodeInvLabelEdgeMap[nodeIndex];
        }

        protected Collection<? extends HostEdge> getPosEdgeSet(HostNode node) {
            switch (this.direction) {
                case FORWARD: {
                    return this.graph.outEdgeSet(node);
                }
            }
            return this.graph.inEdgeSet(node);
        }

        protected Collection<? extends HostEdge> getInvEdgeSet(HostNode node) {
            switch (this.direction) {
                case FORWARD: {
                    return this.graph.inEdgeSet(node);
                }
            }
            return this.graph.outEdgeSet(node);
        }

        protected HostNode getThisEnd(HostEdge edge) {
            switch (this.direction) {
                case FORWARD: {
                    return edge.source();
                }
            }
            return edge.target();
        }

        protected HostNode getOpposite(HostEdge edge) {
            switch (this.direction) {
                case FORWARD: {
                    return edge.target();
                }
            }
            return edge.source();
        }

        protected int getOpposite(int edgeIndex) {
            switch (this.direction) {
                case FORWARD: {
                    return MatrixAutomaton.this.getTarget(edgeIndex);
                }
            }
            return MatrixAutomaton.this.getSource(edgeIndex);
        }

        protected boolean addRelated(HostNode startImage, HostNode endImage) {
            switch (this.direction) {
                case FORWARD: {
                    return this.result.add(this.createResult(startImage, endImage));
                }
            }
            return this.result.add(this.createResult(endImage, startImage));
        }

        RegAut.Result createResult(HostNode source, HostNode target) {
            return new RegAut.Result(source, target);
        }

        protected void cleanOldMatches() {
            if (this.auxResults != null) {
                int i = 0;
                while (i < this.auxResults.length) {
                    this.auxResults[i] = null;
                    ++i;
                }
            }
        }

        protected boolean isAllowedResult(HostNode image) {
            return this.endImages == null || this.endImages.contains(image);
        }

        protected boolean isCountingEdgeImages() {
            return this.endImages != null && !MatrixAutomaton.this.hasVars() && !this.isStoringIntermediates();
        }

        protected boolean isStoringIntermediates() {
            return this.storeIntermediates;
        }

        protected class MatchingComputation
        extends HashMap<HostNode, Set<Valuation>> {
            private Collection<MatchingComputation> dependents;
            private final int keyIndex;
            private final HostNode image;
            private final Valuation valuation;

            public MatchingComputation(int keyIndex, HostNode image, MatchingComputation dependent, Valuation valuation) {
                this.keyIndex = keyIndex;
                this.image = image;
                this.valuation = valuation;
                if (dependent != null) {
                    this.dependents = new HashSet<MatchingComputation>();
                    this.addDependents(dependent);
                }
            }

            private void addDependents(MatchingComputation dependent) {
                if (dependent != this && this.dependents.add(dependent) && dependent.dependents != null) {
                    for (MatchingComputation subDependent : dependent.dependents) {
                        this.addDependents(subDependent);
                    }
                }
            }

            public MatchingComputation(int keyIndex, HostNode image, Valuation valuation) {
                this(keyIndex, image, null, valuation);
                matchingAlgorithm.remainingImageCount = matchingAlgorithm.isCountingEdgeImages() ? matchingAlgorithm.endImages.size() : -1;
                if (!matchingAlgorithm.isStoringIntermediates()) {
                    matchingAlgorithm.cleanOldMatches();
                }
            }

            public Map<HostNode, Set<Valuation>> start() {
                this.propagate(this.keyIndex, this.image, this.valuation);
                if (this.dependents != null) {
                    for (MatchingComputation dependent : this.dependents) {
                        dependent.addAll(this);
                    }
                    this.dependents = null;
                }
                return this;
            }

            private void propagate(int keyIndex, HostNode image, Valuation valuation) {
                this.extend(MatchingAlgorithm.this.getPosLabelEdgeMap(keyIndex), image, MatchingAlgorithm.this.getPosEdgeSet(image), valuation, true);
                this.extend(MatchingAlgorithm.this.getInvLabelEdgeMap(keyIndex), image, MatchingAlgorithm.this.getInvEdgeSet(image), valuation, false);
            }

            private void extend(Map<TypeLabel, int[]> keyLabelEdgeMap, HostNode image, Collection<? extends HostEdge> imageEdgeSet, Valuation valuation, boolean positive) {
                if (keyLabelEdgeMap != null) {
                    if (!MatrixAutomaton.this.typeGraph.isImplicit()) {
                        TypeNode typeNode = image.getType();
                        this.extend(keyLabelEdgeMap.get(typeNode.label()), image, typeNode, valuation);
                    }
                    for (HostEdge hostEdge : imageEdgeSet) {
                        if (MatchingAlgorithm.this.remainingImageCount == 0) break;
                        TypeEdge imageType = hostEdge.getType();
                        HostNode imageNode = positive ? MatchingAlgorithm.this.getOpposite(hostEdge) : MatchingAlgorithm.this.getThisEnd(hostEdge);
                        this.extend(keyLabelEdgeMap.get(imageType.label()), imageNode, imageType, valuation);
                    }
                }
            }

            private void extend(int[] keyEdgeIndices, HostNode imageNode, TypeElement type, Valuation valuation) {
                if (keyEdgeIndices != null) {
                    int[] nArray = keyEdgeIndices;
                    int n = keyEdgeIndices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int keyEdgeIndex = nArray[n2];
                        if (MatchingAlgorithm.this.remainingImageCount == 0) break;
                        RuleLabel edgeLabel = MatrixAutomaton.this.getLabel(keyEdgeIndex);
                        boolean labelOk = true;
                        if (edgeLabel.isWildcard() && type instanceof TypeEdge) {
                            TypeGuard guard = edgeLabel.getWildcardGuard();
                            if (guard != null) {
                                labelOk = guard.isSatisfied(type);
                            }
                            if (labelOk && guard.isNamed()) {
                                LabelVar var = guard.getVar();
                                TypeElement oldLabel = (TypeElement)valuation.get(var);
                                if (oldLabel == null) {
                                    valuation = new Valuation(valuation);
                                    valuation.put(var, type);
                                } else {
                                    labelOk = oldLabel.equals(type);
                                }
                            }
                        }
                        if (labelOk) {
                            this.extend(MatchingAlgorithm.this.getOpposite(keyEdgeIndex), imageNode, valuation);
                        }
                        ++n2;
                    }
                }
            }

            private void extend(int keyIndex, HostNode image, Valuation valuation) {
                if (keyIndex == MatchingAlgorithm.this.endIndex) {
                    this.add(image, valuation);
                } else if (!MatrixAutomaton.this.isCyclic(keyIndex)) {
                    this.propagate(keyIndex, image, valuation);
                } else {
                    MatchingComputation previous = this.getMatch(keyIndex, image);
                    if (previous != null) {
                        if (MatchingAlgorithm.this.isStoringIntermediates()) {
                            previous.copyTo(this);
                        }
                    } else if (MatchingAlgorithm.this.isStoringIntermediates()) {
                        MatchingComputation newResult = new MatchingComputation(keyIndex, image, this, valuation);
                        this.putMatch(newResult);
                        newResult.start();
                    } else {
                        this.putDummyMatch(keyIndex, image);
                        this.propagate(keyIndex, image, valuation);
                    }
                }
            }

            public boolean add(HostNode image, Valuation valuation) {
                if (MatchingAlgorithm.this.isStoringIntermediates() || MatchingAlgorithm.this.isAllowedResult(image)) {
                    boolean result;
                    if (MatrixAutomaton.this.hasVars()) {
                        HashSet<Valuation> currentValuations = (HashSet<Valuation>)this.get(image);
                        if (currentValuations == null) {
                            currentValuations = new HashSet<Valuation>();
                            this.put(image, currentValuations);
                        }
                        return currentValuations.add(valuation);
                    }
                    boolean bl = result = super.put(image, Collections.emptySet()) == null;
                    if (result && MatchingAlgorithm.this.remainingImageCount > 0) {
                        --MatchingAlgorithm.this.remainingImageCount;
                    }
                    return result;
                }
                return false;
            }

            public void addAll(MatchingComputation other) {
                if (MatrixAutomaton.this.hasVars()) {
                    for (Map.Entry otherEntry : other.entrySet()) {
                        HostNode image = (HostNode)otherEntry.getKey();
                        Set valuations = (Set)otherEntry.getValue();
                        HashSet currentValuations = (HashSet)this.get(image);
                        if (currentValuations == null) {
                            currentValuations = new HashSet();
                            this.put(image, currentValuations);
                        }
                        currentValuations.addAll(valuations);
                    }
                } else {
                    this.putAll(other);
                }
            }

            protected MatchingComputation getMatch(int keyIndex, HostNode image) {
                if (MatchingAlgorithm.this.auxResults[keyIndex] == null) {
                    return null;
                }
                return MatchingAlgorithm.this.auxResults[keyIndex].get(image);
            }

            protected void putMatch(MatchingComputation result) {
                Map<HostNode, MatchingComputation> matched = MatchingAlgorithm.this.auxResults[result.keyIndex];
                if (matched == null) {
                    matched = MatchingAlgorithm.this.auxResults[result.keyIndex] = new HashMap<HostNode, MatchingComputation>();
                }
                matched.put(result.image, result);
            }

            protected void putDummyMatch(int keyIndex, HostNode image) {
                Map<HostNode, MatchingComputation> matched = MatchingAlgorithm.this.auxResults[keyIndex];
                if (matched == null) {
                    matched = MatchingAlgorithm.this.auxResults[keyIndex] = new HashMap<HostNode, MatchingComputation>();
                }
                matched.put(image, MatchingAlgorithm.this.MATCH_DUMMY);
            }

            protected void copyTo(MatchingComputation other) {
                if (this.isBusy()) {
                    this.addDependents(other);
                } else {
                    other.addAll(this);
                }
            }

            protected boolean isBusy() {
                return this.dependents != null;
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }
        }
    }
}

