/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.Node;
import groove.util.Duo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeRelation
implements Cloneable {
    private Map<Node, Set<Entry>> oneToEntryMap;
    private Map<Entry, Entry> supportMap = new HashMap<Entry, Entry>();
    private Set<Element> allSupport = new HashSet<Element>();

    public Set<Entry> getAllRelated() {
        return this.supportMap.keySet();
    }

    public boolean addSelfRelated(Node node) {
        return this.addRelated(this.createEntry(node));
    }

    public boolean addRelated(Edge edge) {
        return this.addRelated(this.createEntry(edge));
    }

    public NodeRelation clone() {
        NodeRelation result = this.newInstance();
        for (Entry entry : this.getAllRelated()) {
            result.addRelated(entry);
        }
        return result;
    }

    public NodeRelation newInstance() {
        return new NodeRelation();
    }

    public boolean doOr(NodeRelation other) {
        boolean result = false;
        for (Entry entry : other.getAllRelated()) {
            result |= this.addRelated(entry);
        }
        return result;
    }

    public NodeRelation doThen(NodeRelation other) {
        HashSet<Entry> oldRelatedSet = new HashSet<Entry>(this.getAllRelated());
        this.clear();
        for (Entry oldRel : oldRelatedSet) {
            Set<Entry> otherEntries = other.getEntries((Node)oldRel.two());
            if (otherEntries == null) continue;
            for (Entry otherRel : otherEntries) {
                assert (((Node)otherRel.one()).equals(oldRel.two()));
                Entry newRel = oldRel.append(otherRel);
                this.addRelated(newRel);
            }
        }
        return this;
    }

    public boolean doTransitiveClosure() {
        boolean result = false;
        boolean unstable = true;
        NodeRelation me = this.clone();
        while (unstable) {
            unstable = this.doOrThen(me);
            result |= unstable;
        }
        return result;
    }

    public void doInverse() {
        HashSet<Entry> relatedSet = new HashSet<Entry>(this.getAllRelated());
        this.clear();
        for (Entry entry : relatedSet) {
            this.addRelated(entry.invert());
        }
    }

    public boolean isEmpty() {
        return this.getAllRelated().isEmpty();
    }

    public boolean equals(Object obj) {
        return obj instanceof NodeRelation && this.getAllRelated().equals(((NodeRelation)obj).getAllRelated());
    }

    public int hashCode() {
        return this.getAllRelated().hashCode();
    }

    public String toString() {
        return this.getAllRelated().toString();
    }

    public Collection<Element> getSupport() {
        return this.allSupport;
    }

    protected void clear() {
        this.oneToEntryMap = null;
        this.supportMap.clear();
        this.allSupport.clear();
    }

    protected boolean addRelated(Entry entry) {
        boolean result;
        this.addToEntryMap(entry);
        Entry existing = this.supportMap.get(entry);
        if (existing == null) {
            this.supportMap.put(entry, entry);
            result = true;
        } else {
            result = existing.addSupport(entry);
        }
        this.allSupport.addAll(entry.getSupport());
        return result;
    }

    protected boolean doOrThen(NodeRelation other) {
        boolean result = false;
        HashSet<Entry> oldRelatedSet = new HashSet<Entry>(this.getAllRelated());
        for (Entry oldRel : oldRelatedSet) {
            Set<Entry> otherEntries = other.getEntries((Node)oldRel.two());
            if (otherEntries == null) continue;
            for (Entry otherRel : otherEntries) {
                assert (((Node)otherRel.one()).equals(oldRel.two()));
                Entry newRel = oldRel.append(otherRel);
                result |= this.addRelated(newRel);
            }
        }
        return result;
    }

    protected Entry createEntry(Node node) {
        return new Entry(node);
    }

    protected Entry createEntry(Edge edge) {
        return new Entry(edge);
    }

    protected Set<Entry> getEntries(Node one) {
        return this.getOneToEntryMap().get(one);
    }

    protected boolean addToEntryMap(Entry entry) {
        boolean result = false;
        if (this.oneToEntryMap != null) {
            result = this.addToOneToEntryMap(entry, this.oneToEntryMap);
        }
        return result;
    }

    private Map<Node, Set<Entry>> getOneToEntryMap() {
        if (this.oneToEntryMap == null) {
            this.oneToEntryMap = this.computeOneToEntryMap();
        }
        return this.oneToEntryMap;
    }

    private Map<Node, Set<Entry>> computeOneToEntryMap() {
        HashMap<Node, Set<Entry>> result = new HashMap<Node, Set<Entry>>();
        for (Entry entry : this.getAllRelated()) {
            this.addToOneToEntryMap(entry, result);
        }
        return result;
    }

    private boolean addToOneToEntryMap(Entry entry, Map<Node, Set<Entry>> result) {
        Set<Entry> entries = result.get(entry.one());
        if (entries == null) {
            entries = new HashSet<Entry>();
            result.put((Node)entry.one(), entries);
        }
        return entries.add(entry);
    }

    static class Entry
    extends Duo<Node> {
        private final Set<Element> support = new HashSet<Element>();

        public Entry(Node node) {
            super(node, node);
        }

        protected Entry(Node one, Node two) {
            super(one, two);
            this.support.add(one);
            this.support.add(two);
        }

        public Entry(Edge edge) {
            this(edge.source(), edge.target());
            this.support.add(edge);
        }

        public Entry invert() {
            Entry result = new Entry((Node)this.two(), (Node)this.one());
            result.addSupport(this);
            return result;
        }

        public Entry append(Entry other) {
            assert (((Node)this.two()).equals(other.one()));
            Entry result = new Entry((Node)this.one(), (Node)other.two());
            result.addSupport(this);
            result.addSupport(other);
            return result;
        }

        public Set<Element> getSupport() {
            return this.support;
        }

        public boolean addSupport(Entry other) {
            return this.support.addAll(other.support);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", support: " + this.support.toString();
        }
    }
}

