/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.annotation.Help;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import groove.annotation.ToolTipPars;
import groove.automaton.RegExprCalculator;
import groove.grammar.model.FormatException;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.util.ExprParser;
import groove.util.Groove;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class RegExpr {
    private final String operator;
    private final String symbol;
    private RuleLabel label;
    public static final char SEQ_OPERATOR = '.';
    public static final String SEQ_SYMBOLIC_NAME = "Seq";
    public static final char STAR_OPERATOR = '*';
    public static final String STAR_SYMBOLIC_NAME = "Some";
    public static final char CHOICE_OPERATOR = '|';
    public static final String CHOICE_SYMBOLIC_NAME = "Or";
    public static final char PLUS_OPERATOR = '+';
    public static final String PLUS_SYMBOLIC_NAME = "More";
    public static final char EMPTY_OPERATOR = '=';
    public static final String EMPTY_SYMBOLIC_NAME = "Empty";
    public static final char WILDCARD_OPERATOR = '?';
    public static final String WILDCARD_SYMBOLIC_NAME = "Any";
    public static final char SHARP_OPERATOR = '#';
    public static final String SHARP_SYMBOLIC_NAME = "Sharp";
    public static final char INV_OPERATOR = '-';
    public static final String INV_SYMBOLIC_NAME = "Back";
    public static final String NEG_OPERATOR = "!";
    public static final String NEG_SYMBOLIC_NAME = "Not";
    public static final String ATOM_SYMBOLIC_NAME = "Atom";
    public static final String ATOM_CHARS = "_$-";
    private static final RegExpr[] prototypes = new RegExpr[]{new Atom(), new Neg(), new Choice(), new Seq(), new Inv(), new Star(), new Plus(), new Wildcard(), new Sharp(), new Empty()};
    private static final List<String> operators = new LinkedList<String>();
    private static final Map<String, String> tokenMap = new HashMap<String, String>();
    private static final int classHashCode;
    private static Map<String, String> docMap;

    static {
        RegExpr[] regExprArray = prototypes;
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            RegExpr prototype = regExprArray[n2];
            if (!(prototype instanceof Atom)) {
                operators.add(prototype.getOperator());
                tokenMap.put(prototype.getClass().getSimpleName(), Help.bf(prototype.getOperator()));
            }
            ++n2;
        }
        tokenMap.put("LSQUARE", "[");
        tokenMap.put("RSQUARE", "]");
        tokenMap.put("COMMA", ",");
        tokenMap.put("COLON", ":");
        tokenMap.put("HAT", "^");
        tokenMap.put("FLAG", "flag");
        tokenMap.put("TYPE", "type");
        classHashCode = System.identityHashCode(RegExpr.class);
    }

    protected RegExpr(String operator, String symbol) {
        this.operator = operator;
        this.symbol = symbol;
    }

    public boolean isAtom() {
        return this.getAtomText() != null;
    }

    public String getAtomText() {
        if (this instanceof Atom) {
            return ((Atom)this).text();
        }
        return null;
    }

    public boolean isEmpty() {
        return this instanceof Empty;
    }

    public boolean isSharp() {
        return this instanceof Sharp;
    }

    public TypeLabel getSharpLabel() {
        return this.isSharp() ? ((Sharp)this).getTypeLabel() : null;
    }

    public boolean isWildcard() {
        return this instanceof Wildcard;
    }

    public LabelVar getWildcardId() {
        if (this instanceof Wildcard) {
            return ((Wildcard)this).getLabelVar();
        }
        return null;
    }

    public TypeGuard getWildcardGuard() {
        if (this instanceof Wildcard) {
            return ((Wildcard)this).getGuard();
        }
        return null;
    }

    public EdgeRole getWildcardKind() {
        if (this instanceof Wildcard) {
            return ((Wildcard)this).getKind();
        }
        return null;
    }

    public boolean isChoice() {
        return this instanceof Choice;
    }

    public List<RegExpr> getChoiceOperands() {
        if (this instanceof Choice) {
            return ((Choice)this).getOperands();
        }
        return null;
    }

    public boolean isSeq() {
        return this instanceof Seq;
    }

    public List<RegExpr> getSeqOperands() {
        if (this instanceof Seq) {
            return ((Seq)this).getOperands();
        }
        return null;
    }

    public boolean isStar() {
        return this instanceof Star;
    }

    public RegExpr getStarOperand() {
        if (this instanceof Star) {
            return ((Star)this).getOperand();
        }
        return null;
    }

    public boolean isPlus() {
        return this instanceof Plus;
    }

    public RegExpr getPlusOperand() {
        if (this instanceof Plus) {
            return ((Plus)this).getOperand();
        }
        return null;
    }

    public boolean isInv() {
        return this instanceof Inv;
    }

    public RegExpr getInvOperand() {
        if (this instanceof Inv) {
            return ((Inv)this).getOperand();
        }
        return null;
    }

    public boolean isNeg() {
        return this instanceof Neg;
    }

    public RegExpr getNegOperand() {
        if (this instanceof Neg) {
            return ((Neg)this).getOperand();
        }
        return null;
    }

    public Choice choice(RegExpr other) {
        if (other instanceof Choice) {
            ArrayList<RegExpr> operands = new ArrayList<RegExpr>();
            operands.add(this);
            operands.addAll(other.getOperands());
            return new Choice(operands);
        }
        return new Choice(Arrays.asList(this, other));
    }

    public Seq seq(RegExpr other) {
        if (other instanceof Seq) {
            ArrayList<RegExpr> operands = new ArrayList<RegExpr>();
            operands.add(this);
            operands.addAll(other.getOperands());
            return new Seq(operands);
        }
        return new Seq(Arrays.asList(this, other));
    }

    public Star star() {
        return new Star(this);
    }

    public Plus plus() {
        return new Plus(this);
    }

    public Inv inv() {
        return new Inv(this);
    }

    public Neg neg() {
        return new Neg(this);
    }

    public abstract RegExpr relabel(TypeLabel var1, TypeLabel var2);

    public abstract Set<TypeLabel> getTypeLabels();

    public abstract boolean isAcceptsEmptyWord();

    public boolean containsOperator(String operator) {
        boolean found = false;
        Iterator<RegExpr> operandIter = this.getOperands().iterator();
        while (!found && operandIter.hasNext()) {
            RegExpr operand = operandIter.next();
            boolean bl = found = operand.isMyOperator(operator) || operand.containsOperator(operator);
        }
        return found;
    }

    public boolean containsOperator(RegExpr operator) {
        return this.containsOperator(operator.getOperator());
    }

    public Set<LabelVar> allVarSet() {
        LinkedHashSet<LabelVar> result = new LinkedHashSet<LabelVar>();
        if (this.getWildcardId() != null && this.getWildcardId().hasName()) {
            result.add(this.getWildcardId());
        } else {
            for (RegExpr operand : this.getOperands()) {
                result.addAll(operand.allVarSet());
            }
        }
        return result;
    }

    public Set<LabelVar> boundVarSet() {
        LinkedHashSet<LabelVar> result = new LinkedHashSet<LabelVar>();
        if (this.getWildcardId() != null && this.getWildcardId().hasName()) {
            result.add(this.getWildcardId());
        }
        return result;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getDescription() {
        StringBuffer result = new StringBuffer(this.getSymbol());
        Iterator<RegExpr> operandIter = this.getOperands().iterator();
        if (operandIter.hasNext()) {
            result.append('[');
            while (operandIter.hasNext()) {
                RegExpr operand = operandIter.next();
                result.append(operand.getDescription());
                if (!operandIter.hasNext()) continue;
                result.append(", ");
            }
            result.append(']');
        }
        return result.toString();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean equals(Object obj) {
        return obj instanceof RegExpr && this.toString().equals(obj.toString());
    }

    public RuleLabel toLabel() {
        if (this.label == null) {
            this.label = new RuleLabel(this);
        }
        return this.label;
    }

    public int hashCode() {
        return classHashCode ^ this.toString().hashCode();
    }

    public abstract List<RegExpr> getOperands();

    public abstract <Result> Result apply(RegExprCalculator<Result> var1);

    protected abstract RegExpr parseOperator(String var1) throws FormatException;

    public static void assertAtom(String text) throws FormatException {
        if (text.length() == 0) {
            throw new FormatException("Empty atom", new Object[0]);
        }
        switch (text.charAt(0)) {
            case '\"': 
            case '<': {
                Pair<String, List<String>> parseResult = ExprParser.parseExpr(text);
                if (parseResult.one().length() == 1) break;
                String error = text.charAt(0) == '\"' ? String.format("Atom '%s' has unbalanced quotes", text) : String.format("Atom '%s' has unbalanced brackets", text);
                throw new FormatException(error, new Object[0]);
            }
            case '-': {
                String error = String.format("Atom '%s' contains invalid first character '%c'", text, Character.valueOf('-'));
                throw new FormatException(error, new Object[0]);
            }
            default: {
                text = TypeLabel.createLabelWithCheck(text).text();
                boolean correct = true;
                int i = 0;
                while (correct && i < text.length()) {
                    correct = RegExpr.isAtomChar(text.charAt(i));
                    ++i;
                }
                if (correct) break;
                throw new FormatException("Atom '%s' contains invalid character '%c'", text, Character.valueOf(text.charAt(i - 1)));
            }
        }
    }

    public static boolean isAtom(String text) {
        try {
            RegExpr.assertAtom(text);
            return true;
        }
        catch (FormatException formatException) {
            return false;
        }
    }

    public static boolean isAtomChar(char c) {
        return Character.isLetterOrDigit(c) || ATOM_CHARS.indexOf(c) >= 0;
    }

    protected boolean isMyOperator(Object token) {
        return this.getOperator().equals(token);
    }

    protected boolean bindsWeaker(String operator1, String operator2) {
        return operators.indexOf(operator1) <= operators.indexOf(operator2);
    }

    protected boolean bindsWeaker(RegExpr operator1, RegExpr operator2) {
        if (operator2 instanceof Constant) {
            return true;
        }
        if (operator1 instanceof Constant) {
            return false;
        }
        return this.bindsWeaker(((Composite)operator1).getOperator(), ((Composite)operator2).getOperator());
    }

    public static RegExpr parse(String expr) throws FormatException {
        ExprParser.parseExpr(expr);
        RegExpr[] regExprArray = prototypes;
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            RegExpr prototype = regExprArray[n2];
            RegExpr result = prototype.parseOperator(expr);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        throw new FormatException("Unable to parse expression %s as regular expression", expr);
    }

    public static Atom atom(String text) {
        return new Atom(text);
    }

    public static Sharp sharp(TypeLabel typeLabel) {
        return new Sharp(typeLabel);
    }

    public static Wildcard wildcard(EdgeRole kind) {
        return RegExpr.wildcard(kind, null, true, new String[0]);
    }

    public static Wildcard wildcard(EdgeRole kind, String name) {
        assert (name != null);
        return RegExpr.wildcard(kind, name, true, new String[0]);
    }

    public static Wildcard wildcard(EdgeRole kind, boolean negated, String ... labels) {
        return RegExpr.wildcard(kind, null, negated, labels);
    }

    public static Wildcard wildcard(EdgeRole kind, String name, boolean negated, String ... labels) {
        Wildcard prototype = new Wildcard();
        TypeGuard guard = new TypeGuard(name == null ? new LabelVar(kind) : new LabelVar(name, kind));
        if (labels.length > 0) {
            guard.setLabels(Arrays.asList(labels), negated);
        }
        return prototype.newInstance(guard);
    }

    public static Empty empty() {
        return new Empty();
    }

    private static void test(String text) {
        try {
            System.out.println("Input: " + text);
            System.out.println("Output: " + RegExpr.parse(text));
            System.out.println("Description: " + RegExpr.parse(text).getDescription());
        }
        catch (FormatException e) {
            System.out.println("Error:  " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            RegExpr.test("");
            RegExpr.test("?");
            RegExpr.test("a|b");
            RegExpr.test("|b");
            RegExpr.test("*");
            RegExpr.test("((a).(b))*");
            RegExpr.test("((a)*|b)+");
            RegExpr.test("?.'b.c'. 'b'. \"c\". (d*)");
            RegExpr.test("a+*");
            RegExpr.test("a.?*");
            RegExpr.test("((a)");
            RegExpr.test("(<a)");
            RegExpr.test("(a . b)* .c. d|e*");
            RegExpr.test("=. b|c*");
            RegExpr.test("!a*");
            RegExpr.test("!a.b | !(a.!b)");
            RegExpr.test("?ab");
            RegExpr.test("type:?ab[a,b]");
            RegExpr.test("flag:?ab[^a,b]");
        } else {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                RegExpr.test(arg);
                ++n2;
            }
        }
    }

    public static Map<String, String> getDocMap() {
        if (docMap == null) {
            docMap = RegExpr.computeDocMap();
        }
        return docMap;
    }

    private static Map<String, String> computeDocMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Class<?>[] classArray = RegExpr.class.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> subClass = classArray[n2];
            Help help = Help.createHelp(subClass, tokenMap);
            if (help != null) {
                result.put(help.getItem(), help.getTip());
            }
            ++n2;
        }
        return result;
    }

    @Syntax(value="[role COLON] label")
    @ToolTipHeader(value="Single edge or label")
    @ToolTipBody(value={"Matched by a single edge labelled %2$s (if no %1$s is specified),", "a %2$s-flag (if %1$s equals FLAG) or a %2$s-type (if %1$s equals TYPE).", "In the latter case, any subtype of %2$s is also correct."})
    @ToolTipPars(value={"optional role: either TYPE or FLAG", "edge label; should be single-quoted if it contains non-identifier characters."})
    public static class Atom
    extends Constant {
        private final String text;

        public Atom(String token) {
            super("", RegExpr.ATOM_SYMBOLIC_NAME);
            this.text = token;
        }

        Atom() {
            this("");
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            return oldLabel.equals(this.toTypeLabel()) ? this.newInstance(newLabel.toPrefixedString()) : this;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            HashSet<TypeLabel> result = new HashSet<TypeLabel>();
            result.add(this.toTypeLabel());
            return result;
        }

        @Override
        public String toString() {
            if (Atom.isAtom(this.text())) {
                return this.text();
            }
            return ExprParser.toQuoted(this.text(), '\'');
        }

        @Override
        public String getDescription() {
            return this.text;
        }

        public String text() {
            return this.text;
        }

        public TypeLabel toTypeLabel() {
            return TypeLabel.createLabel(this.text());
        }

        @Override
        public RegExpr parseOperator(String expr) throws FormatException {
            if ((expr = expr.trim()).length() == 0) {
                throw new FormatException("Empty string not allowed in expression", new Object[0]);
            }
            if (Atom.isAtom(expr)) {
                return this.newInstance(expr);
            }
            Pair<String, List<String>> parseResult = ExprParser.parseExpr(expr);
            if (parseResult.one().length() == 1 && parseResult.one().charAt(0) == '\uffff') {
                String parsedExpr = parseResult.two().get(0);
                switch (parsedExpr.charAt(0)) {
                    case '(': {
                        return Atom.parse(parsedExpr.substring(1, expr.length() - 1));
                    }
                    case '\'': {
                        return this.newInstance(ExprParser.toUnquoted(parsedExpr, '\''));
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        protected Constant newInstance() {
            throw new UnsupportedOperationException("Atom instances must have a parameter");
        }

        protected Atom newInstance(String text) {
            return new Atom(text);
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return calculator.computeAtom(this);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return false;
        }
    }

    @Syntax(value="expr1 %s expr2")
    @ToolTipHeader(value="Choice")
    @ToolTipBody(value={"Satisfied by a path <i>p</i> if satisfies either %1$s or %2$s"})
    public static class Choice
    extends Infix {
        public Choice(List<RegExpr> tokenList) {
            super("|", RegExpr.CHOICE_SYMBOLIC_NAME, tokenList);
        }

        Choice() {
            this(null);
        }

        @Override
        protected Infix newInstance(List<RegExpr> operandList) {
            return new Choice(operandList);
        }

        @Override
        protected <Result> Result applyInfix(RegExprCalculator<Result> visitor, List<Result> argsList) {
            return visitor.computeChoice(this, argsList);
        }

        @Override
        boolean computeAcceptsEmptyWord(List<RegExpr> operandList) {
            boolean result = false;
            for (RegExpr operand : operandList) {
                if (!operand.isAcceptsEmptyWord()) continue;
                result = true;
                break;
            }
            return result;
        }
    }

    protected static abstract class Composite
    extends RegExpr {
        protected Composite(String operator, String symbol) {
            super(operator, symbol);
        }
    }

    protected static abstract class Constant
    extends RegExpr {
        Constant(String operator, String symbol) {
            super(operator, symbol);
        }

        @Override
        public List<RegExpr> getOperands() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getOperator();
        }

        @Override
        protected RegExpr parseOperator(String expr) throws FormatException {
            if (expr.equals(this.getOperator())) {
                return this.newInstance();
            }
            return null;
        }

        protected abstract Constant newInstance();
    }

    @Syntax(value="%s")
    @ToolTipHeader(value="Equality or merging")
    @ToolTipBody(value={"Satisfied only by an empty path; i.e., a path not containing any edges."})
    public static class Empty
    extends Constant {
        public Empty() {
            super("=", RegExpr.EMPTY_SYMBOLIC_NAME);
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            return this;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            return Collections.emptySet();
        }

        @Override
        protected Constant newInstance() {
            return new Empty();
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return calculator.computeEmpty(this);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return true;
        }
    }

    protected static abstract class Infix
    extends Composite {
        private final List<RegExpr> operandList;
        private final boolean acceptsEmptyWord;

        public Infix(String operator, String symbol, List<RegExpr> operands) {
            super(operator, symbol);
            this.operandList = operands;
            this.acceptsEmptyWord = operands != null && this.computeAcceptsEmptyWord(operands);
        }

        @Override
        public List<RegExpr> getOperands() {
            return Collections.unmodifiableList(this.operandList);
        }

        @Override
        public RegExpr parseOperator(String expr) throws FormatException {
            String[] operands = ExprParser.splitExpr(expr, this.getOperator(), 0);
            if (operands.length < 2) {
                return null;
            }
            LinkedList<RegExpr> operandList = new LinkedList<RegExpr>();
            String[] stringArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                operandList.add(Infix.parse(element));
                ++n2;
            }
            return this.newInstance(operandList);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator<RegExpr> operandIter = this.getOperands().iterator();
            while (operandIter.hasNext()) {
                RegExpr operand = operandIter.next();
                if (this.bindsWeaker(operand, this)) {
                    result.append("(" + operand + ')');
                } else {
                    result.append(operand);
                }
                if (!operandIter.hasNext()) continue;
                result.append(this.getOperator());
            }
            return result.toString();
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            ArrayList<Result> argsList = new ArrayList<Result>();
            for (RegExpr operand : this.getOperands()) {
                argsList.add(operand.apply(calculator));
            }
            return this.applyInfix(calculator, argsList);
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            ArrayList<RegExpr> newOperands = new ArrayList<RegExpr>();
            boolean hasChanged = false;
            for (RegExpr operand : this.getOperands()) {
                RegExpr newOperand = operand.relabel(oldLabel, newLabel);
                newOperands.add(newOperand);
                hasChanged |= newOperand != operand;
            }
            return hasChanged ? this.newInstance(newOperands) : this;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            HashSet<TypeLabel> result = new HashSet<TypeLabel>();
            for (RegExpr operand : this.getOperands()) {
                result.addAll(operand.getTypeLabels());
            }
            return result;
        }

        protected abstract Infix newInstance(List<RegExpr> var1);

        protected abstract <Result> Result applyInfix(RegExprCalculator<Result> var1, List<Result> var2);

        @Override
        public boolean isAcceptsEmptyWord() {
            return this.acceptsEmptyWord;
        }

        abstract boolean computeAcceptsEmptyWord(List<RegExpr> var1);
    }

    @Syntax(value="%s expr")
    @ToolTipHeader(value="Inversion")
    @ToolTipBody(value={"Matched by a path <i>p</i> that, when traversed backwards, satisfies %1$s."})
    public static class Inv
    extends Prefix {
        public Inv(RegExpr operand) {
            super("-", RegExpr.INV_SYMBOLIC_NAME, operand);
        }

        Inv() {
            this(null);
        }

        @Override
        protected Prefix newInstance(RegExpr operand) {
            return new Inv(operand);
        }

        @Override
        protected <Result> Result applyPrefix(RegExprCalculator<Result> visitor, Result arg) {
            return visitor.computeInv(this, arg);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return this.getOperand().isAcceptsEmptyWord();
        }
    }

    @Syntax(value="%s expr")
    @ToolTipHeader(value="Negation")
    @ToolTipBody(value={"Matched by any path <i>p</i> that does <i>not</i> satisfy %1$s."})
    public static class Neg
    extends Prefix {
        public Neg(RegExpr operand) {
            super(RegExpr.NEG_OPERATOR, RegExpr.NEG_SYMBOLIC_NAME, operand);
        }

        Neg() {
            this(null);
        }

        @Override
        protected Prefix newInstance(RegExpr operand) {
            return new Neg(operand);
        }

        @Override
        protected <Result> Result applyPrefix(RegExprCalculator<Result> visitor, Result arg) {
            return visitor.computeNeg(this, arg);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return this.getOperand().isAcceptsEmptyWord();
        }
    }

    @Syntax(value="expr %s")
    @ToolTipHeader(value="One or more")
    @ToolTipBody(value={"Matched by a path <i>p</i> if it is the concatenation of at least one", "fragment satisfying %1$s"})
    public static class Plus
    extends Postfix {
        public Plus(RegExpr operand) {
            super("+", RegExpr.PLUS_SYMBOLIC_NAME, operand);
        }

        Plus() {
            this(null);
        }

        @Override
        protected Postfix newInstance(RegExpr operand) {
            return new Plus(operand);
        }

        @Override
        protected <Result> Result applyPostfix(RegExprCalculator<Result> visitor, Result arg) {
            return visitor.computePlus(this, arg);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return false;
        }
    }

    protected static abstract class Postfix
    extends Composite {
        private final RegExpr operand;
        private final List<RegExpr> operandList;

        public Postfix(String operator, String symbol, RegExpr operand) {
            super(operator, symbol);
            this.operand = operand;
            this.operandList = Collections.singletonList(operand);
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            RegExpr newOperand = this.getOperand().relabel(oldLabel, newLabel);
            return newOperand != this.getOperand() ? this.newInstance(newOperand) : this;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            return this.getOperand().getTypeLabels();
        }

        public RegExpr getOperand() {
            return this.operand;
        }

        @Override
        public List<RegExpr> getOperands() {
            return this.operandList;
        }

        public String toString() {
            if (this.bindsWeaker(this.operand, this)) {
                return "(" + this.getOperand() + ')' + this.getOperator();
            }
            return this.getOperand() + this.getOperator();
        }

        @Override
        protected RegExpr parseOperator(String expr) throws FormatException {
            String[] operands = ExprParser.splitExpr(expr, this.getOperator(), 2);
            if (operands == null) {
                return null;
            }
            return this.newInstance(Postfix.parse(operands[0]));
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return this.applyPostfix(calculator, this.getOperand().apply(calculator));
        }

        protected abstract Postfix newInstance(RegExpr var1);

        protected abstract <Result> Result applyPostfix(RegExprCalculator<Result> var1, Result var2);
    }

    protected static abstract class Prefix
    extends Composite {
        private final RegExpr operand;
        private final List<RegExpr> operandList;

        public Prefix(String operator, String symbol, RegExpr operand) {
            super(operator, symbol);
            this.operand = operand;
            this.operandList = Collections.singletonList(operand);
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            RegExpr newOperand = this.getOperand().relabel(oldLabel, newLabel);
            return newOperand != this.getOperand() ? this.newInstance(newOperand) : this;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            return this.getOperand().getTypeLabels();
        }

        public RegExpr getOperand() {
            return this.operand;
        }

        @Override
        public List<RegExpr> getOperands() {
            return this.operandList;
        }

        public String toString() {
            if (this.bindsWeaker(this.operand, this)) {
                return this.getOperator() + '(' + this.getOperand() + ')';
            }
            return this.getOperator() + this.getOperand();
        }

        @Override
        protected RegExpr parseOperator(String expr) throws FormatException {
            String[] operands = ExprParser.splitExpr(expr, this.getOperator(), 1);
            if (operands == null) {
                return null;
            }
            return this.newInstance(Prefix.parse(operands[0]));
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return this.applyPrefix(calculator, this.getOperand().apply(calculator));
        }

        protected abstract Prefix newInstance(RegExpr var1);

        protected abstract <Result> Result applyPrefix(RegExprCalculator<Result> var1, Result var2);
    }

    @Syntax(value="expr1 %s expr2")
    @ToolTipHeader(value="Concatenation")
    @ToolTipBody(value={"Satisfied by a path <i>p</i> if it is the concatenation", "of a path <i>p1</i> satisfying %1$s, followed by a path <i>p2</i>", "satisfying %2$s"})
    public static class Seq
    extends Infix {
        public Seq(List<RegExpr> innerRegExps) {
            super(".", RegExpr.SEQ_SYMBOLIC_NAME, innerRegExps);
        }

        Seq() {
            this(null);
        }

        @Override
        protected Infix newInstance(List<RegExpr> operandList) {
            return new Seq(operandList);
        }

        @Override
        protected <Result> Result applyInfix(RegExprCalculator<Result> visitor, List<Result> argsList) {
            return visitor.computeSeq(this, argsList);
        }

        @Override
        boolean computeAcceptsEmptyWord(List<RegExpr> operandList) {
            boolean result = true;
            for (RegExpr operand : operandList) {
                if (operand.isAcceptsEmptyWord()) continue;
                result = false;
                break;
            }
            return result;
        }
    }

    @Syntax(value="%s label")
    @ToolTipHeader(value="Sharp type")
    @ToolTipBody(value={"Satisfied only by the node type %s (and not by any subtype of it)"})
    public static class Sharp
    extends Constant {
        private TypeLabel typeLabel;

        public Sharp() {
            super("#", RegExpr.SHARP_SYMBOLIC_NAME);
        }

        public Sharp(TypeLabel typeLabel) {
            this();
            assert (typeLabel.getRole() == EdgeRole.NODE_TYPE);
            this.typeLabel = typeLabel;
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            Constant result = this.getTypeLabel().equals(oldLabel) ? (newLabel.getRole() == EdgeRole.NODE_TYPE ? this.newInstance(newLabel) : new Atom(newLabel.text())) : this;
            return result;
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            HashSet<TypeLabel> result = new HashSet<TypeLabel>();
            result.add(this.getTypeLabel());
            return result;
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return calculator.computeSharp(this);
        }

        @Override
        public String toString() {
            return String.valueOf(EdgeRole.NODE_TYPE.getPrefix()) + super.toString() + this.getTypeLabel().text();
        }

        @Override
        protected RegExpr parseOperator(String expr) throws FormatException {
            int index = expr.indexOf(this.getOperator());
            if (index < 0) {
                return null;
            }
            Pair<EdgeRole, String> parsedExpr = EdgeRole.parseLabel(expr.substring(0, index));
            String text = expr.substring(index + 1);
            if (parsedExpr.one() != EdgeRole.NODE_TYPE || parsedExpr.two().length() != 0) {
                throw new FormatException("Sharp operator '%s' must be preceded by '%s'", this.getOperator(), EdgeRole.NODE_TYPE.getPrefix());
            }
            return this.newInstance(TypeLabel.createLabel(EdgeRole.NODE_TYPE, text, true));
        }

        protected Sharp newInstance(TypeLabel typeLabel) {
            return new Sharp(typeLabel);
        }

        @Override
        protected Constant newInstance() {
            return new Sharp();
        }

        public TypeLabel getTypeLabel() {
            return this.typeLabel;
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return false;
        }
    }

    @Syntax(value="expr %s")
    @ToolTipHeader(value="Zero or more")
    @ToolTipBody(value={"Matched by a path <i>p</i> if it is the concatenation of multiple", "fragments satisfying %1$s"})
    public static class Star
    extends Postfix {
        public Star(RegExpr operand) {
            super("*", RegExpr.STAR_SYMBOLIC_NAME, operand);
        }

        Star() {
            this(null);
        }

        @Override
        protected Postfix newInstance(RegExpr operand) {
            return new Star(operand);
        }

        @Override
        protected <Result> Result applyPostfix(RegExprCalculator<Result> visitor, Result arg) {
            return visitor.computeStar(this, arg);
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return true;
        }
    }

    @Syntax(value="[role COLON] %s [name] [ LSQUARE [HAT]label_list RSQUARE ]")
    @ToolTipHeader(value="Label variable or wildcard")
    @ToolTipBody(value={"Satisfied by an edge if its label fulfils the following conditions:", "<ul>", "<li> If the prefix %1$s is specified (either FLAG or TYPE)", "then the label must have that role;", "if it is absent, the edge must be binary.", "<li> If a suffix of the form LSQUARE %3$s RSQUARE is specified", "then the label must be one of the elements of %3$s.", "<li> If a suffix of the form LSQUARE HAT %3$s RSQUARE is specified", "then the label may <i>not</i> be one of the elements of %3$s.", "</ul>", "The optional %2$s acts as a variable binding the label.", "Multiple occurrences of %2$s in a rule must all be bound to the same label."})
    @ToolTipPars(value={"the optional role of the label: either FLAG or TYPE", "the optional wildcard variable name", "comma-separated list of labels, either containing or excluding the matched label"})
    public static class Wildcard
    extends Constant {
        private final TypeGuard guard;

        Wildcard() {
            this(null);
        }

        private Wildcard(TypeGuard guard) {
            super("?", RegExpr.WILDCARD_SYMBOLIC_NAME);
            this.guard = guard;
        }

        @Override
        public RegExpr relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            TypeGuard newGuard = null;
            newGuard = this.guard.relabel(oldLabel, newLabel);
            return newGuard == this.guard ? this : this.newInstance(newGuard);
        }

        @Override
        public Set<TypeLabel> getTypeLabels() {
            Set<TypeLabel> result = this.guard.getLabels();
            if (result == null) {
                result = Collections.emptySet();
            }
            return result;
        }

        @Override
        public <Result> Result apply(RegExprCalculator<Result> calculator) {
            return calculator.computeWildcard(this);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.getGuard().getKind().getPrefix());
            result.append(super.toString());
            result.append(this.getLabelVar().getName());
            result.append(this.getGuard());
            return result.toString();
        }

        @Override
        public String getDescription() {
            StringBuilder result = new StringBuilder();
            if (this.getIdentifier() != null) {
                result.append(String.valueOf(this.getIdentifier()) + "=");
            }
            result.append(this.getSymbol());
            if (this.guard != null) {
                String type = this.guard.getKind().getPrefix();
                if (!type.isEmpty()) {
                    result.append(" ");
                    result.append(type.subSequence(0, type.length() - 1));
                }
                if (this.guard.getLabels() != null) {
                    result.append(this.guard.isNegated() ? " not in " : " from ");
                    result.append(Groove.toString(this.guard.getLabels().toArray()));
                }
            }
            return result.toString();
        }

        public TypeGuard getGuard() {
            return this.guard;
        }

        public EdgeRole getKind() {
            return this.getGuard().getKind();
        }

        public String getIdentifier() {
            return this.getLabelVar().getName();
        }

        public LabelVar getLabelVar() {
            return this.guard.getVar();
        }

        @Override
        protected RegExpr parseOperator(String expr) throws FormatException {
            FormatException error = new FormatException("Can't parse wildcard expression '%s'", expr);
            int index = expr.indexOf(this.getOperator());
            if (index < 0) {
                return null;
            }
            String text = expr.substring(index + 1);
            if (text.indexOf(this.getOperator()) >= 0) {
                throw error;
            }
            String prefix = expr.substring(0, index);
            Pair<EdgeRole, String> parsedPrefix = EdgeRole.parseLabel(prefix);
            if (parsedPrefix.two().length() > 0) {
                throw error;
            }
            EdgeRole kind = parsedPrefix.one();
            String identifier = null;
            String parameter = null;
            if (!text.isEmpty()) {
                Pair<String, List<String>> operand = ExprParser.parseExpr(text);
                int subStringCount = operand.two().size();
                identifier = operand.one();
                if (subStringCount > 1) {
                    throw error;
                }
                if (subStringCount == 1) {
                    parameter = operand.two().iterator().next();
                    if (identifier.indexOf(65535) != identifier.length() - 1) {
                        throw error;
                    }
                    identifier = identifier.substring(0, identifier.length() - 1);
                }
                if (identifier.isEmpty()) {
                    identifier = null;
                } else if (!ExprParser.isIdentifier(identifier)) {
                    throw new FormatException("Invalid wildcard identifier '%s'", text);
                }
            }
            LabelVar var = identifier == null ? new LabelVar(kind) : new LabelVar(identifier, kind);
            TypeGuard guard = new TypeGuard(var);
            if (parameter != null) {
                Pair<List<String>, Boolean> constraint = this.getConstraint(parameter);
                guard.setLabels(constraint.one(), constraint.two());
            }
            return this.newInstance(guard);
        }

        private Pair<List<String>, Boolean> getConstraint(String parameter) throws FormatException {
            String[] constraintParts;
            boolean negated;
            String constraintList = ExprParser.toTrimmed(parameter, '[', ']');
            if (constraintList == null) {
                throw new FormatException("Invalid constraint parameter '%s'", parameter);
            }
            boolean bl = negated = constraintList.indexOf(94) == 0;
            if (negated) {
                constraintList = constraintList.substring(1);
            }
            if ((constraintParts = ExprParser.splitExpr(constraintList, ",", 0)).length == 0) {
                throw new FormatException("Invalid constraint parameter '%s'", parameter);
            }
            ArrayList<String> constrainedLabels = new ArrayList<String>();
            String[] stringArray = constraintParts;
            int n = constraintParts.length;
            int n2 = 0;
            while (n2 < n) {
                RuleLabel label;
                RegExpr atom;
                String part = stringArray[n2];
                try {
                    atom = Wildcard.parse(part);
                }
                catch (FormatException formatException) {
                    throw new FormatException("Label '%s' in constraint '%s' cannot be parsed", part, parameter);
                }
                if (atom instanceof Atom) {
                    label = atom.toLabel();
                    if (label.getRole() != EdgeRole.BINARY) {
                        throw new FormatException("Label '%s' in constraint '%s' should not be prefixed", part, parameter);
                    }
                } else {
                    throw new FormatException("Label '%s' in constraint '%s' should be an atom", part, parameter);
                }
                constrainedLabels.add(label.text());
                ++n2;
            }
            return Pair.newPair(constrainedLabels, negated);
        }

        protected Wildcard newInstance(TypeGuard constraint) {
            return new Wildcard(constraint);
        }

        @Override
        protected Constant newInstance() {
            return new Wildcard();
        }

        @Override
        public boolean isAcceptsEmptyWord() {
            return false;
        }
    }
}

