/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.DFA;
import groove.automaton.DFAState;
import groove.automaton.Direction;
import groove.automaton.RegAut;
import groove.automaton.RegEdge;
import groove.automaton.RegFactory;
import groove.automaton.RegNode;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.Valuation;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.NodeSetEdgeSetGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleNFA
extends NodeSetEdgeSetGraph<RegNode, RegEdge>
implements RegAut {
    private RegNode start;
    private RegNode end;
    private boolean acceptsEmptyWord;
    private final Map<Direction, Map<List<TypeLabel>, DFA>> dfas;
    private List<LabelVar> labelVars;
    private final TypeGraph typeGraph;
    private static final List<TypeLabel> EMPTY_LABEL_LIST = Collections.emptyList();
    public static final SimpleNFA PROTOTYPE = new SimpleNFA();

    private SimpleNFA() {
        super("prototype");
        this.start = null;
        this.end = null;
        this.typeGraph = null;
        this.dfas = null;
    }

    private SimpleNFA(RegNode start, RegNode end, TypeGraph typeGraph) {
        super("automaton");
        this.start = start;
        this.end = end;
        this.typeGraph = typeGraph;
        assert (typeGraph != null);
        this.addNode(start);
        this.addNode(end);
        this.dfas = new EnumMap<Direction, Map<List<TypeLabel>, DFA>>(Direction.class);
    }

    @Override
    public RegAut newAutomaton(RegNode start, RegNode end, TypeGraph typeGraph) {
        return new SimpleNFA(start, end, typeGraph);
    }

    @Override
    public RegNode addNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegNode getStartNode() {
        return this.start;
    }

    @Override
    public RegNode getEndNode() {
        return this.end;
    }

    @Override
    public boolean isAcceptsEmptyWord() {
        return this.acceptsEmptyWord;
    }

    @Override
    public void setAcceptsEmptyWord(boolean acceptsEmptyWord) {
        this.acceptsEmptyWord = acceptsEmptyWord;
    }

    @Override
    public void setEndNode(RegNode endNode) {
        this.end = endNode;
    }

    @Override
    public void setStartNode(RegNode startNode) {
        this.start = startNode;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("\nStart node: " + this.getStartNode());
        result.append("\nEnd node: " + this.getEndNode());
        result.append("\nAccepts empty word: " + this.isAcceptsEmptyWord());
        return result.toString();
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result) {
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction dir = directionArray[n2];
                this.dfas.put(dir, new HashMap());
                ++n2;
            }
            this.labelVars = this.computeLabelVars();
        }
        return result;
    }

    public DFA getDFA(Direction dir, Valuation valuation) {
        List<TypeLabel> varImages;
        Map<List<TypeLabel>, DFA> dfaMap;
        DFA result;
        this.testFixed(true);
        if (valuation == null) {
            valuation = Valuation.EMPTY;
        }
        if ((result = (dfaMap = this.dfas.get((Object)dir)).get(varImages = this.getVarImages(valuation))) == null) {
            result = this.computeDFA(dir, valuation);
            dfaMap.put(varImages, result);
        }
        return result;
    }

    private DFA computeDFA(Direction dir, Valuation valuation) {
        DFA result = new DFA(dir, dir == Direction.FORWARD ? this.getStartNode() : this.getEndNode(), this.isAcceptsEmptyWord());
        HashSet<DFAState> unexplored = new HashSet<DFAState>();
        unexplored.add(result.getStartState());
        do {
            Iterator iter = unexplored.iterator();
            DFAState current = (DFAState)iter.next();
            iter.remove();
            EnumMap succMaps = new EnumMap(Direction.class);
            Object object = Direction.values();
            int n = ((Direction[])object).length;
            int n2 = 0;
            while (n2 < n) {
                Direction edgeDir = object[n2];
                succMaps.put(edgeDir, new HashMap());
                ++n2;
            }
            for (RegNode rn : current.getNodes()) {
                for (RegEdge re : dir.edges(this, rn)) {
                    TypeLabel l2;
                    RuleLabel rel = (RuleLabel)re.label();
                    Set<TypeLabel> matches = this.getMatchingLabels(rel);
                    Map succMap = (Map)succMaps.get((Object)(rel.isInv() ? dir.getInverse() : dir));
                    RegNode opposite = (RegNode)dir.opposite(re);
                    TypeGuard guard = rel.getWildcardGuard();
                    if (guard == null || !guard.isNamed()) {
                        for (TypeLabel l2 : matches) {
                            this.addToImages(succMap, l2, opposite);
                        }
                        continue;
                    }
                    l2 = ((TypeElement)valuation.get(guard.getVar())).label();
                    if (!matches.contains(l2)) continue;
                    this.addToImages(succMap, l2, opposite);
                }
            }
            object = Direction.values();
            n = ((Direction[])object).length;
            n2 = 0;
            while (n2 < n) {
                Object d = object[n2];
                for (Map.Entry le : ((Map)succMaps.get(d)).entrySet()) {
                    Set ns = (Set)le.getValue();
                    DFAState target = result.getState(ns);
                    if (target == null) {
                        RegNode finalNode = dir == Direction.FORWARD ? this.getEndNode() : this.getStartNode();
                        target = result.addState(ns, ns.contains(finalNode));
                        unexplored.add(target);
                    }
                    current.addSuccessor((Direction)((Object)d), (TypeLabel)le.getKey(), target);
                }
                ++n2;
            }
        } while (!unexplored.isEmpty());
        return result.toMinimised();
    }

    private Set<TypeLabel> getMatchingLabels(RuleLabel label) {
        HashSet<TypeLabel> result = new HashSet<TypeLabel>();
        for (TypeElement type : this.typeGraph.getMatches(label)) {
            result.add(type.label());
        }
        return result;
    }

    private <K> void addToImages(Map<K, Set<RegNode>> map, K key, RegNode node) {
        Set<RegNode> images = map.get(key);
        if (images == null) {
            images = new HashSet<RegNode>();
            map.put(key, images);
        }
        images.add(node);
    }

    private List<TypeLabel> getVarImages(Valuation valuation) {
        List<TypeLabel> result;
        List<LabelVar> labelVars = this.getLabelVars();
        if (labelVars.isEmpty()) {
            result = EMPTY_LABEL_LIST;
        } else {
            result = new ArrayList<TypeLabel>(labelVars.size());
            for (LabelVar v : labelVars) {
                TypeElement e = (TypeElement)valuation.get(v);
                assert (e != null);
                result.add(e.label());
            }
        }
        return result;
    }

    private List<LabelVar> getLabelVars() {
        return this.labelVars;
    }

    private List<LabelVar> computeLabelVars() {
        ArrayList<LabelVar> result = new ArrayList<LabelVar>();
        for (RegEdge e : this.edgeSet()) {
            RuleLabel label = (RuleLabel)e.label();
            if (!label.isWildcard() || !label.getWildcardGuard().isNamed()) continue;
            result.add(label.getWildcardGuard().getVar());
        }
        return result;
    }

    @Override
    public ElementFactory<RegNode, RegEdge> getFactory() {
        return RegFactory.instance();
    }

    @Override
    public boolean accepts(List<String> word) {
        assert (this.isFixed());
        DFA dfa = this.getDFA(Direction.FORWARD, null);
        DFAState dfaState = dfa.getStartState();
        String invOp = "-";
        TypeFactory typeFactory = this.getTypeGraph().getFactory();
        for (String letter : word) {
            boolean inverse = letter.startsWith(invOp);
            if (inverse) {
                letter = letter.substring(invOp.length());
            }
            TypeLabel label = typeFactory.createLabel(letter);
            if ((dfaState = dfaState.getLabelMap().get((Object)(inverse ? Direction.BACKWARD : Direction.FORWARD)).get(label)) == null) break;
        }
        return dfaState != null && dfaState.isFinal();
    }

    @Override
    public Set<RegAut.Result> getMatches(HostGraph graph, HostNode startImage, HostNode endImage, Valuation valuation) {
        HostNode toNode;
        HostNode fromNode;
        Direction dir;
        assert (this.isFixed());
        if (valuation == null) {
            valuation = Valuation.EMPTY;
        }
        if (endImage == null || startImage != null) {
            dir = Direction.FORWARD;
            fromNode = startImage;
            toNode = endImage;
        } else {
            dir = Direction.BACKWARD;
            fromNode = endImage;
            toNode = startImage;
        }
        DFA normalAut = this.getDFA(dir, valuation);
        return normalAut.getRecogniser(graph).getMatches(fromNode, toNode);
    }

    @Override
    public Set<RegAut.Result> getMatches(HostGraph graph, HostNode startImage, HostNode endImage) {
        return this.getMatches(graph, startImage, endImage, null);
    }

    @Override
    public Set<TypeElement> getAlphabet() {
        assert (this.isFixed());
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (RegEdge edge : this.edgeSet()) {
            result.addAll(this.typeGraph.getMatches((RuleLabel)edge.label()));
        }
        return result;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        boolean result = edge instanceof RegEdge;
        if (result) {
            RuleLabel edgeLabel = (RuleLabel)((RegEdge)edge).label();
            if (edgeLabel.isInv()) {
                edgeLabel = edgeLabel.getInvLabel();
            }
            result = edgeLabel.isWildcard() || edgeLabel.isSharp() || edgeLabel.isAtom();
        }
        return result;
    }

    @Override
    public final TypeGraph getTypeGraph() {
        return this.typeGraph;
    }
}

