/*
 * Decompiled with CFR 0.152.
 */
package groove.control.parse;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class CtrlTokenMaker
extends AbstractTokenMaker {
    protected final String operators = "+-*/%!=<>^&|?:#";
    protected final String separators = "()[]{}";
    protected final String separators2 = ".,;";
    protected final String hexCharacters = "0123456789ABCDEFabcdef";
    protected final String numberEndChars = "FfLl";
    private int currentTokenStart;
    private int currentTokenType;

    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        switch (tokenType) {
            case 15: {
                int value = this.wordsToHighlight.get(segment, start, end);
                if (value == -1) break;
                tokenType = value;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                new Exception("Unknown tokenType: '" + tokenType + "'").printStackTrace();
                tokenType = 15;
            }
        }
        super.addToken(segment, start, end, tokenType, startOffset);
    }

    public String[] getLineCommentStartAndEnd() {
        String[] stringArray = new String[2];
        stringArray[0] = "//";
        return stringArray;
    }

    public TokenMap getWordsToHighlight() {
        TokenMap tokenMap = new TokenMap();
        int reservedWord = 4;
        tokenMap.put("alap", reservedWord);
        tokenMap.put("any", reservedWord);
        tokenMap.put("choice", reservedWord);
        tokenMap.put("do", reservedWord);
        tokenMap.put("else", reservedWord);
        tokenMap.put("function", reservedWord);
        tokenMap.put("if", reservedWord);
        tokenMap.put("import", reservedWord);
        tokenMap.put("or", reservedWord);
        tokenMap.put("other", reservedWord);
        tokenMap.put("package", reservedWord);
        tokenMap.put("priority", reservedWord);
        tokenMap.put("recipe", reservedWord);
        tokenMap.put("try", reservedWord);
        tokenMap.put("until", reservedWord);
        tokenMap.put("var", reservedWord);
        tokenMap.put("while", reservedWord);
        int literalBoolean = 6;
        tokenMap.put("false", literalBoolean);
        tokenMap.put("true", literalBoolean);
        int dataType = 13;
        tokenMap.put("bool", dataType);
        tokenMap.put("float", dataType);
        tokenMap.put("int", dataType);
        tokenMap.put("node", dataType);
        tokenMap.put("string", dataType);
        tokenMap.put("out", dataType);
        return tokenMap;
    }

    public Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        this.resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        int newStartOffset = startOffset - offset;
        this.currentTokenStart = offset;
        this.currentTokenType = initialTokenType;
        boolean backslash = false;
        boolean numContainsExponent = false;
        boolean numContainsEndCharacter = false;
        int i = offset;
        while (i < end) {
            char c = array[i];
            block0 : switch (this.currentTokenType) {
                case 0: {
                    this.currentTokenStart = i;
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            if (backslash) {
                                this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                                backslash = false;
                                break block0;
                            }
                            this.currentTokenType = 25;
                            break block0;
                        }
                        case '\'': {
                            if (backslash) {
                                this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                                backslash = false;
                                break block0;
                            }
                            this.currentTokenType = 26;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenType = 0;
                            backslash = !backslash;
                            break block0;
                        }
                    }
                    if (RSyntaxUtilities.isDigit((char)c)) {
                        this.currentTokenType = 7;
                        break;
                    }
                    if (RSyntaxUtilities.isLetter((char)c) || c == '_') {
                        this.currentTokenType = 15;
                        break;
                    }
                    int indexOf = "+-*/%!=<>^&|?:#".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i, 17, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 23;
                    break;
                }
                case 16: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                    }
                    this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                    this.currentTokenStart = i;
                    if (RSyntaxUtilities.isDigit((char)c)) {
                        this.currentTokenType = 7;
                        break;
                    }
                    if (RSyntaxUtilities.isLetter((char)c) || c == '_') {
                        this.currentTokenType = 15;
                        break;
                    }
                    int indexOf = "+-*/%!=<>^&|?:#".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 23;
                    break;
                }
                default: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    if (RSyntaxUtilities.isLetterOrDigit((char)c) || c == '_') break;
                    int indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 23;
                    break;
                }
                case 7: {
                    if (this.currentTokenStart == i - 1) {
                        numContainsExponent = false;
                        numContainsEndCharacter = false;
                    }
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    if (RSyntaxUtilities.isDigit((char)c)) break;
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            break;
                        }
                        this.currentTokenType = 24;
                        break;
                    }
                    if (c == '.') {
                        if (numContainsExponent) {
                            this.currentTokenType = 24;
                            break;
                        }
                        this.currentTokenType = 8;
                        break;
                    }
                    int indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            break;
                        }
                        numContainsEndCharacter = true;
                        break;
                    }
                    indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 24;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    if (RSyntaxUtilities.isDigit((char)c)) break;
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            break;
                        }
                        this.currentTokenType = 24;
                        break;
                    }
                    if (c == '.') {
                        this.currentTokenType = 24;
                        break;
                    }
                    int indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            break;
                        }
                        numContainsEndCharacter = true;
                        break;
                    }
                    indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 24;
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            break;
                        }
                        this.currentTokenType = 24;
                        break;
                    }
                    int indexOf = "0123456789ABCDEFabcdef".indexOf(c);
                    if (indexOf > -1) break;
                    indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            break;
                        }
                        numContainsEndCharacter = true;
                        break;
                    }
                    indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        break;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        break;
                    }
                    this.currentTokenType = 24;
                    break;
                }
                case 2: {
                    while (i < end - 1) {
                        if (array[i] == '*' && array[i + 1] == '/') {
                            this.addToken(text, this.currentTokenStart, i + 1, 2, newStartOffset + this.currentTokenStart);
                            ++i;
                            this.currentTokenType = 0;
                            backslash = false;
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    i = end - 1;
                    this.addToken(text, this.currentTokenStart, i, 1, newStartOffset + this.currentTokenStart);
                    this.currentTokenType = 0;
                    break;
                }
                case 18: {
                    if (array[i - 1] == '/') {
                        if (c == '*') {
                            this.currentTokenType = 2;
                            break;
                        }
                        if (c == '/') {
                            this.currentTokenType = 1;
                            i = end - 1;
                            break;
                        }
                        this.addToken(text, this.currentTokenStart, i - 1, 18, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        --i;
                        break;
                    }
                    this.addToken(text, this.currentTokenStart, i - 1, 18, newStartOffset + this.currentTokenStart);
                    --i;
                    this.currentTokenType = 0;
                    break;
                }
                case 23: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case ';': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    int indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                    }
                    if ((indexOf = "()[]{}".indexOf(c)) > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                    }
                    if ((indexOf = ".,;".indexOf(c)) <= -1) break;
                    this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                    this.addToken(text, i, i, 15, newStartOffset + i);
                    this.currentTokenType = 0;
                    break;
                }
                case 24: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            break block0;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            break block0;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            break block0;
                        }
                        case ';': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            break block0;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            break block0;
                        }
                    }
                    int indexOf = "0123456789ABCDEFabcdef".indexOf(c);
                    if (indexOf > -1 && i - this.currentTokenStart == 2 && array[i - 1] == 'x' && array[i - 2] == '0') {
                        this.currentTokenType = 9;
                        break;
                    }
                    indexOf = "+-*/%!=<>^&|?:#".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                    }
                    if ((indexOf = "()[]{}".indexOf(c)) > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                    }
                    if ((indexOf = ".,;".indexOf(c)) <= -1) break;
                    this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                    this.addToken(text, i, i, 15, newStartOffset + i);
                    this.currentTokenType = 0;
                    break;
                }
                case 26: {
                    if (c == '\\') {
                        backslash = !backslash;
                        break;
                    }
                    if (c == '\'' && !backslash) {
                        this.addToken(text, this.currentTokenStart, i, 11, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                    }
                    backslash = false;
                    break;
                }
                case 25: {
                    if (c == '\\') {
                        backslash = !backslash;
                        break;
                    }
                    if (c == '\"' && !backslash) {
                        this.addToken(text, this.currentTokenStart, i, 10, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                    }
                    backslash = false;
                }
            }
            ++i;
        }
        if (this.currentTokenType != 0) {
            this.addToken(text, this.currentTokenStart, end - 1, this.currentTokenType, newStartOffset + this.currentTokenStart);
        }
        if (this.currentTokenType != 2) {
            this.addNullToken();
        }
        return this.firstToken;
    }
}

